/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.ElementValidationEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.util.MiscUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphireTestCase
extends TestCase {
    private IProject project;

    protected SapphireTestCase(String name) {
        super(name);
    }

    protected final IProject project() throws Exception {
        if (this.project == null) {
            String name = String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + this.getName();
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            this.project.create(null);
            this.project.open(null);
        }
        return this.project;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.project != null) {
            this.project.delete(true, null);
        }
    }

    protected final InputStream loadResourceAsStream(String name) {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        if (in == null) {
            throw new IllegalArgumentException(name);
        }
        return in;
    }

    protected final String loadResource(String name) throws Exception {
        String string;
        InputStream in = this.loadResourceAsStream(name);
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            char[] chars = new char[1024];
            StringBuilder buf = new StringBuilder();
            int i = r.read(chars);
            while (i != -1) {
                buf.append(chars, 0, i);
                i = r.read(chars);
            }
            string = buf.toString();
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    protected static final void assertEqualsIgnoreNewLineDiffs(String expected, String actual) {
        SapphireTestCase.assertEquals((String)expected.trim().replace("\r", ""), (String)actual.trim().replace("\r", ""));
    }

    protected static final void assertValidationOk(Value<?> value) {
        SapphireTestCase.assertValidationOk(value.validation());
    }

    protected static final void assertValidationOk(IModelElement element) {
        SapphireTestCase.assertValidationOk(element.validation());
    }

    protected static final void assertValidationOk(Status status) {
        SapphireTestCase.assertEquals((Object)Status.Severity.OK, (Object)status.severity());
    }

    protected static final void assertValidationWarning(Value<?> value, String expectedMessage) {
        SapphireTestCase.assertValidationWarning(value.validation(), expectedMessage);
    }

    protected static final void assertValidationWarning(IModelElement element, String expectedMessage) {
        SapphireTestCase.assertValidationWarning(element.validation(), expectedMessage);
    }

    protected static final void assertValidationWarning(Status status, String expectedMessage) {
        SapphireTestCase.assertEquals((Object)Status.Severity.WARNING, (Object)status.severity());
        SapphireTestCase.assertEquals((String)expectedMessage, (String)status.message());
    }

    protected static final void assertValidationError(Value<?> value, String expectedMessage) {
        SapphireTestCase.assertValidationError(value.validation(), expectedMessage);
    }

    protected static final void assertValidationError(IModelElement element, String expectedMessage) {
        SapphireTestCase.assertValidationError(element.validation(), expectedMessage);
    }

    protected static final void assertValidationError(Status status, String expectedMessage) {
        SapphireTestCase.assertEquals((Object)Status.Severity.ERROR, (Object)status.severity());
        SapphireTestCase.assertEquals((String)expectedMessage, (String)status.message());
    }

    protected static void assertElementValidationEvent(Event event, IModelElement element, Status before, Status after) {
        SapphireTestCase.assertTrue((boolean)(event instanceof ElementValidationEvent));
        ElementValidationEvent evt = (ElementValidationEvent)event;
        SapphireTestCase.assertSame((Object)element, (Object)evt.element());
        SapphireTestCase.assertEquals((Object)before, (Object)evt.before());
        SapphireTestCase.assertEquals((Object)after, (Object)evt.after());
    }

    protected static void assertElementDisposeEvent(Event event, IModelElement element) {
        SapphireTestCase.assertTrue((boolean)(event instanceof ElementDisposeEvent));
        ElementDisposeEvent evt = (ElementDisposeEvent)event;
        SapphireTestCase.assertSame((Object)element, (Object)evt.element());
    }

    protected static void assertPropertyInitializationEvent(Event event, IModelElement element, ModelProperty property) {
        SapphireTestCase.assertTrue((boolean)(event instanceof PropertyInitializationEvent));
        PropertyInitializationEvent evt = (PropertyInitializationEvent)event;
        SapphireTestCase.assertSame((Object)element, (Object)evt.element());
        SapphireTestCase.assertSame((Object)property, (Object)evt.property());
    }

    protected static void assertPropertyContentEvent(Event event, IModelElement element, ModelProperty property) {
        SapphireTestCase.assertTrue((boolean)(event instanceof PropertyContentEvent));
        PropertyContentEvent evt = (PropertyContentEvent)event;
        SapphireTestCase.assertSame((Object)element, (Object)evt.element());
        SapphireTestCase.assertSame((Object)property, (Object)evt.property());
    }

    protected static void assertPropertyValidationEvent(Event event, IModelElement element, ModelProperty property, Status before, Status after) {
        SapphireTestCase.assertTrue((boolean)(event instanceof PropertyValidationEvent));
        PropertyValidationEvent evt = (PropertyValidationEvent)event;
        SapphireTestCase.assertSame((Object)element, (Object)evt.element());
        SapphireTestCase.assertSame((Object)property, (Object)evt.property());
        SapphireTestCase.assertEquals((Object)before, (Object)evt.before());
        SapphireTestCase.assertEquals((Object)after, (Object)evt.after());
    }

    protected static void assertPropertyEnablementEvent(Event event, IModelElement element, ModelProperty property, boolean before, boolean after) {
        SapphireTestCase.assertTrue((boolean)(event instanceof PropertyEnablementEvent));
        PropertyEnablementEvent evt = (PropertyEnablementEvent)event;
        SapphireTestCase.assertSame((Object)element, (Object)evt.element());
        SapphireTestCase.assertSame((Object)property, (Object)evt.property());
        SapphireTestCase.assertEquals((boolean)before, (boolean)evt.before());
        SapphireTestCase.assertEquals((boolean)after, (boolean)evt.after());
    }

    protected static <T> List<T> list(T ... items) {
        return MiscUtil.list((Object[])items);
    }

    protected static <T> Set<T> set(T ... items) {
        return MiscUtil.set((Object[])items);
    }
}

