/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.events.t0002.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.services.ValueSerializationMasterService;
import org.eclipse.sapphire.tests.modeling.events.t0002.ChildElement;
import org.eclipse.sapphire.tests.modeling.events.t0002.RootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RootElementImpl
extends ModelElement
implements RootElement {
    private ModelElementList<ChildElement> children;
    private Value<Boolean> enablement;

    public RootElementImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public RootElementImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<ChildElement> getChildren() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.children == null) {
                this.refresh((ModelProperty)PROP_CHILDREN, true);
            }
            return this.children;
        }
    }

    protected void disposeProperties() {
        if (this.children != null) {
            for (IModelElement element : this.children) {
                element.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Boolean> getEnablement() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.enablement == null) {
                this.refresh((ModelProperty)PROP_ENABLEMENT, true);
            }
            return this.enablement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnablement(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ENABLEMENT.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_ENABLEMENT, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_ENABLEMENT, true);
            if (!RootElementImpl.equal((String)this.enablement.getText(false), (String)value)) {
                this.resource().binding(PROP_ENABLEMENT).write(value);
                this.refresh((ModelProperty)PROP_ENABLEMENT, false);
            }
        }
    }

    @Override
    public void setEnablement(Boolean value) {
        this.setEnablement(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_ENABLEMENT, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CHILDREN) {
                if (this.children == null) {
                    if (force) {
                        this.children = new ModelElementList((IModelElement)this, PROP_CHILDREN);
                        ListBindingImpl binding = this.resource().binding(PROP_CHILDREN);
                        this.children.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_CHILDREN);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_CHILDREN));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CHILDREN);
                    boolean notified = this.children.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_CHILDREN, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_ENABLEMENT && (this.enablement != null || force)) {
                Value<Boolean> oldValue = this.enablement;
                String val = this.resource().binding(PROP_ENABLEMENT).read();
                this.enablement = new Value((IModelElement)this, PROP_ENABLEMENT, ((ValueNormalizationService)this.service((ModelProperty)PROP_ENABLEMENT, ValueNormalizationService.class)).normalize(PROP_ENABLEMENT.encodeKeywords(val)));
                this.enablement.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ENABLEMENT);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_ENABLEMENT));
                } else {
                    if (this.enablement.equals(oldValue)) {
                        this.enablement = oldValue;
                    } else {
                        if (!RootElementImpl.equal((String)this.enablement.getText(false), (String)oldValue.getText(false)) || !RootElementImpl.equal((String)this.enablement.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_ENABLEMENT));
                        }
                        if (!this.enablement.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_ENABLEMENT, oldValue.validation(), this.enablement.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_ENABLEMENT, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_CHILDREN) {
            return this.getChildren();
        }
        if (property == PROP_ENABLEMENT) {
            return this.getEnablement();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_ENABLEMENT) {
            if (!(value instanceof String)) {
                this.setEnablement((Boolean)value);
            } else {
                this.setEnablement((String)value);
            }
            return;
        }
        super.write(property, value);
    }
}

