/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.misc.t0014.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.tests.modeling.misc.t0014.ChildElement;
import org.eclipse.sapphire.tests.modeling.misc.t0014.RootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RootElementImpl
extends ModelElement
implements RootElement {
    private ModelElementHandle<ChildElement> child;
    private ModelElementHandle<ChildElement> childImplied;
    private ModelElementList<ChildElement> children;

    public RootElementImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public RootElementImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementHandle<ChildElement> getChild() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.child == null) {
                this.refresh((ModelProperty)PROP_CHILD, true);
            }
            return this.child;
        }
    }

    protected void disposeProperties() {
        IModelElement element2;
        if (this.child != null && (element2 = this.child.element(false)) != null) {
            element2.dispose();
        }
        if (this.children != null) {
            for (IModelElement element2 : this.children) {
                element2.dispose();
            }
        }
        if (this.childImplied != null && (element2 = this.childImplied.element(false)) != null) {
            element2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<ChildElement> getChildren() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.children == null) {
                this.refresh((ModelProperty)PROP_CHILDREN, true);
            }
            return this.children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChildElement getChildImplied() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.childImplied == null) {
                this.refresh((ModelProperty)PROP_CHILD_IMPLIED, true);
            }
            return (ChildElement)this.childImplied.element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CHILD) {
                if (this.child == null) {
                    if (force) {
                        this.child = new ModelElementHandle((IModelElement)this, PROP_CHILD);
                        this.child.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_CHILD);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_CHILD));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CHILD);
                    boolean notified = this.child.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_CHILD, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_CHILDREN) {
                if (this.children == null) {
                    if (force) {
                        this.children = new ModelElementList((IModelElement)this, PROP_CHILDREN);
                        ListBindingImpl binding = this.resource().binding(PROP_CHILDREN);
                        this.children.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_CHILDREN);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_CHILDREN));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CHILDREN);
                    boolean notified = this.children.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_CHILDREN, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_CHILD_IMPLIED) {
                if (this.childImplied == null) {
                    if (force) {
                        this.childImplied = new ModelElementHandle((IModelElement)this, (ElementProperty)PROP_CHILD_IMPLIED);
                        this.childImplied.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_CHILD_IMPLIED);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_CHILD_IMPLIED));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CHILD_IMPLIED);
                    boolean notified = this.childImplied.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_CHILD_IMPLIED, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_CHILD) {
            return this.getChild();
        }
        if (property == PROP_CHILDREN) {
            return this.getChildren();
        }
        if (property == PROP_CHILD_IMPLIED) {
            return this.getChildImplied();
        }
        return super.read(property);
    }
}

