/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.services.t0004.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.tests.services.t0004.TestElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestElementImpl
extends ModelElement
implements TestElement {
    private Value<String> colors;
    private Value<String> shapes;

    public TestElementImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public TestElementImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getColors() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.colors == null) {
                this.refresh((ModelProperty)PROP_COLORS, true);
            }
            return this.colors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setColors(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_COLORS.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_COLORS, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_COLORS, true);
            if (!TestElementImpl.equal((String)this.colors.getText(false), (String)value)) {
                this.resource().binding(PROP_COLORS).write(value);
                this.refresh((ModelProperty)PROP_COLORS, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getShapes() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.shapes == null) {
                this.refresh((ModelProperty)PROP_SHAPES, true);
            }
            return this.shapes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShapes(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_SHAPES.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_SHAPES, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_SHAPES, true);
            if (!TestElementImpl.equal((String)this.shapes.getText(false), (String)value)) {
                this.resource().binding(PROP_SHAPES).write(value);
                this.refresh((ModelProperty)PROP_SHAPES, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_COLORS) {
                if (this.colors != null || force) {
                    Value<String> oldValue = this.colors;
                    String val = this.resource().binding(PROP_COLORS).read();
                    this.colors = new Value((IModelElement)this, PROP_COLORS, ((ValueNormalizationService)this.service((ModelProperty)PROP_COLORS, ValueNormalizationService.class)).normalize(PROP_COLORS.encodeKeywords(val)));
                    this.colors.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_COLORS);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_COLORS));
                    } else {
                        if (this.colors.equals(oldValue)) {
                            this.colors = oldValue;
                        } else {
                            if (!TestElementImpl.equal((String)this.colors.getText(false), (String)oldValue.getText(false)) || !TestElementImpl.equal((String)this.colors.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_COLORS));
                            }
                            if (!this.colors.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_COLORS, oldValue.validation(), this.colors.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_COLORS, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_SHAPES && (this.shapes != null || force)) {
                Value<String> oldValue = this.shapes;
                String val = this.resource().binding(PROP_SHAPES).read();
                this.shapes = new Value((IModelElement)this, PROP_SHAPES, ((ValueNormalizationService)this.service((ModelProperty)PROP_SHAPES, ValueNormalizationService.class)).normalize(PROP_SHAPES.encodeKeywords(val)));
                this.shapes.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_SHAPES);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_SHAPES));
                } else {
                    if (this.shapes.equals(oldValue)) {
                        this.shapes = oldValue;
                    } else {
                        if (!TestElementImpl.equal((String)this.shapes.getText(false), (String)oldValue.getText(false)) || !TestElementImpl.equal((String)this.shapes.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_SHAPES));
                        }
                        if (!this.shapes.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_SHAPES, oldValue.validation(), this.shapes.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_SHAPES, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_COLORS) {
            return this.getColors();
        }
        if (property == PROP_SHAPES) {
            return this.getShapes();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_COLORS) {
            this.setColors((String)value);
            return;
        }
        if (property == PROP_SHAPES) {
            this.setShapes((String)value);
            return;
        }
        super.write(property, value);
    }
}

