/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.contextbuttons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.AbstractConnectionCreationTool;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.ContextButtonPad;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.ContextButtonPadData;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.StandardContextButtonPadDeclaration;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramNodeEditPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextButtonManager {
    private static final String DIAGRAM_NODE_DEFAULT_ACTION = "Sapphire.Diagram.Node.Default";
    protected static final double MINIMUM_ZOOM_LEVEL = 0.75;
    private SapphireDiagramEditor editor;
    private Map<IFigure, EditPart> figure2EditPart = new HashMap<IFigure, EditPart>();
    private IFigure activeFigure;
    private ContextButtonPad activeContextButtonPad;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomChanged(double newZoom) {
            ContextButtonManager.this.handleZoomChanged();
        }
    };
    private MouseMotionListener mouseMotionListener = new MouseMotionListener.Stub(){

        public void mouseEntered(MouseEvent me) {
            this.reactOnMouse(me);
        }

        public void mouseMoved(MouseEvent me) {
            this.reactOnMouse(me);
        }

        private void reactOnMouse(MouseEvent me) {
            SapphireDiagramEditor ed = ContextButtonManager.this.getEditor();
            if (ed.getSelectedParts().size() > 1) {
                return;
            }
            Tool activeTool = ed.getEditDomain().getActiveTool();
            if (activeTool instanceof CreationTool || activeTool instanceof AbstractConnectionCreationTool) {
                return;
            }
            Object source = me.getSource();
            ContextButtonManager.this.showContextButtonsInstantly((IFigure)source, me.getLocation());
        }
    };

    public ContextButtonManager(SapphireDiagramEditor editor) {
        this.editor = editor;
        ZoomManager zoomMgr = (ZoomManager)this.getEditor().getGraphicalViewer().getProperty(ZoomManager.class.toString());
        if (zoomMgr != null) {
            zoomMgr.addZoomListener(this.zoomListener);
        }
    }

    public SapphireDiagramEditor getEditor() {
        return this.editor;
    }

    private Map<IFigure, EditPart> getFigure2EditPart() {
        return this.figure2EditPart;
    }

    private void setActive(IFigure activeFigure, ContextButtonPad activeContextButtonPad) {
        this.activeFigure = activeFigure;
        this.activeContextButtonPad = activeContextButtonPad;
    }

    private IFigure getActiveFigure() {
        return this.activeFigure;
    }

    private ContextButtonPad getActiveContextButtonPad() {
        return this.activeContextButtonPad;
    }

    public void register(GraphicalEditPart graphicalEditPart) {
        this.getFigure2EditPart().put(graphicalEditPart.getFigure(), (EditPart)graphicalEditPart);
        graphicalEditPart.getFigure().addMouseMotionListener(this.mouseMotionListener);
    }

    public void deRegister(GraphicalEditPart graphicalEditPart) {
        if (graphicalEditPart.getFigure().equals(this.getActiveFigure())) {
            this.hideContextButtonsInstantly();
        }
        this.getFigure2EditPart().remove(graphicalEditPart.getFigure());
        graphicalEditPart.getFigure().removeMouseMotionListener(this.mouseMotionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideContextButtonsInstantly() {
        if (this.getActiveContextButtonPad() != null) {
            ContextButtonManager contextButtonManager = this;
            synchronized (contextButtonManager) {
                ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.getEditor().getGraphicalViewer().getRootEditPart();
                IFigure feedbackLayer = rootEditPart.getLayer((Object)"Handle Layer");
                feedbackLayer.remove((IFigure)this.getActiveContextButtonPad());
                this.setActive(null, null);
            }
        }
    }

    private boolean replaceContextButtonPad(IFigure figure) {
        if (this.getActiveFigure() == null) {
            return true;
        }
        if (figure.equals(this.getActiveFigure())) {
            return false;
        }
        IFigure parent = figure.getParent();
        while (parent != null) {
            if (parent.equals(this.getActiveFigure())) {
                return true;
            }
            parent = parent.getParent();
        }
        return this.getActiveContextButtonPad() == null || !this.getActiveContextButtonPad().isMouseInOverlappingArea();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showContextButtonsInstantly(IFigure figure, Point mouse) {
        if (!this.replaceContextButtonPad(figure)) {
            return;
        }
        ContextButtonManager contextButtonManager = this;
        synchronized (contextButtonManager) {
            this.hideContextButtonsInstantly();
            ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.getEditor().getGraphicalViewer().getRootEditPart();
            double zoom = rootEditPart.getZoomManager().getZoom();
            if (zoom < 0.75) {
                return;
            }
            EditPart activeEditPart = this.getFigure2EditPart().get(figure);
            if (!(activeEditPart instanceof DiagramNodeEditPart)) {
                return;
            }
            DiagramNodeEditPart nodeEditPart = (DiagramNodeEditPart)activeEditPart;
            ContextButtonPadData contextButtonPadData = this.getContextButtonPad(nodeEditPart);
            if (contextButtonPadData.getRightContextButtons().size() == 0 && contextButtonPadData.getTopContextButtons().size() == 0) {
                return;
            }
            if (!contextButtonPadData.getPadLocation().contains(mouse.x, mouse.y)) {
                return;
            }
            StandardContextButtonPadDeclaration declaration = new StandardContextButtonPadDeclaration(contextButtonPadData);
            ContextButtonPad contextButtonPad = new ContextButtonPad(declaration, zoom, this.getEditor(), activeEditPart);
            this.setActive(figure, contextButtonPad);
            IFigure feedbackLayer = rootEditPart.getLayer((Object)"Handle Layer");
            feedbackLayer.add((IFigure)contextButtonPad);
        }
    }

    private void handleZoomChanged() {
        this.hideContextButtonsInstantly();
    }

    private ContextButtonPadData getContextButtonPad(DiagramNodeEditPart nodeEditPart) {
        SapphireAction action;
        ContextButtonPadData contextButtonPadData = new ContextButtonPadData();
        Rectangle bounds = nodeEditPart.getFigure().getBounds();
        Point loc = bounds.getLocation();
        Point botRight = bounds.getBottomRight();
        contextButtonPadData.getPadLocation().set(loc.x, loc.y, botRight.x - loc.x, botRight.y - loc.y);
        DiagramNodePart nodePart = nodeEditPart.getCastedModel().getModelPart();
        SapphireActionGroup actionGroup = nodePart.getActions("Sapphire.Diagram.Node");
        List originalActions = actionGroup.getActions();
        ArrayList<SapphireAction> actions = new ArrayList<SapphireAction>(originalActions.size());
        for (SapphireAction action2 : originalActions) {
            if (action2.getId().equals(DIAGRAM_NODE_DEFAULT_ACTION) || action2.getActiveHandlers().size() <= 0) continue;
            actions.add(action2);
        }
        int numOfActions = actions.size();
        int half = numOfActions / 2;
        LinkedHashMap<String, ArrayList<SapphireAction>> buckets = new LinkedHashMap<String, ArrayList<SapphireAction>>();
        for (SapphireAction action3 : actions) {
            String group = MiscUtil.normalizeToEmptyString((String)action3.getGroup());
            ArrayList<SapphireAction> bucket = (ArrayList<SapphireAction>)buckets.get(group);
            if (bucket == null) {
                bucket = new ArrayList<SapphireAction>();
                buckets.put(group, bucket);
            }
            bucket.add(action3);
        }
        int numTopActions = 0;
        if (buckets.size() < 2) {
            numTopActions = half;
        } else {
            int i = 0;
            for (List bucket : buckets.values()) {
                if (buckets.size() == 2 || (numTopActions += bucket.size()) >= half || i == buckets.size() - 2) break;
                ++i;
            }
        }
        int i = numTopActions - 1;
        while (i >= 0) {
            action = (SapphireAction)actions.get(i);
            contextButtonPadData.getTopContextButtons().add(action);
            --i;
        }
        i = numTopActions;
        while (i < numOfActions) {
            action = (SapphireAction)actions.get(i);
            contextButtonPadData.getRightContextButtons().add(action);
            ++i;
        }
        return contextButtonPadData;
    }
}

