/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.sapphire.ui.swt.gef.parts.ConnectionEditorLocator;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

public class ConnectionDirectEditManager
extends DirectEditManager {
    Font scaledFont;
    protected VerifyListener verifyListener;
    protected Label nodeLabel;

    public ConnectionDirectEditManager(GraphicalEditPart source, Class editorType, ConnectionEditorLocator locator, Label label) {
        super(source, editorType, (CellEditorLocator)locator);
        this.nodeLabel = label;
    }

    protected void bringDown() {
        Font disposeFont = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
    }

    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                Text text = (Text)ConnectionDirectEditManager.this.getCellEditor().getControl();
                String oldText = text.getText();
                String leftText = oldText.substring(0, event.start);
                String rightText = oldText.substring(event.end, oldText.length());
                GC gc = new GC((Drawable)text);
                Point size = gc.textExtent(String.valueOf(leftText) + event.text + rightText);
                gc.dispose();
                if (size.x != 0) {
                    size = text.computeSize(size.x, -1);
                }
                ConnectionDirectEditManager.this.getCellEditor().getControl().setSize(size.x, size.y);
            }
        };
        text.addVerifyListener(this.verifyListener);
        String initialLabelText = this.nodeLabel.getText();
        this.getCellEditor().setValue((Object)initialLabelText);
        IFigure figure = this.getEditPart().getFigure();
        this.scaledFont = figure.getFont();
        FontData data = this.scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        this.nodeLabel.translateToAbsolute((Translatable)fontSize);
        data.setHeight(fontSize.height);
        this.scaledFont = new Font(null, data);
        text.setFont(this.scaledFont);
    }

    protected void unhookListeners() {
        super.unhookListeners();
        Text text = (Text)this.getCellEditor().getControl();
        text.removeVerifyListener(this.verifyListener);
        this.verifyListener = null;
    }
}

