/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionLabelModel;
import org.eclipse.sapphire.ui.swt.gef.parts.ConnectionDirectEditManager;
import org.eclipse.sapphire.ui.swt.gef.parts.ConnectionEditorLocator;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramConnectionEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.IConfigurationManagerHolder;
import org.eclipse.sapphire.ui.swt.gef.parts.SapphireMidpointLocator;
import org.eclipse.sapphire.ui.swt.gef.policies.ConnectionLabelDirectEditPolicy;

public class DiagramConnectionLabelEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
IConfigurationManagerHolder {
    private DiagramConfigurationManager configManager;
    private ConnectionDirectEditManager manager;

    public DiagramConnectionLabelEditPart(DiagramConfigurationManager configManager) {
        this.configManager = configManager;
    }

    public DiagramConfigurationManager getConfigurationManager() {
        return this.configManager;
    }

    protected IFigure createFigure() {
        Label label = new Label(){

            public Insets getInsets() {
                return new Insets(0, 2, 0, 2);
            }
        };
        return label;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ConnectionLabelDirectEditPolicy());
    }

    public DiagramConnectionPart getDiagramConnectionPart() {
        return ((DiagramConnectionLabelModel)this.getModel()).getModelPart();
    }

    public DiagramConnectionLabelModel getCastedModel() {
        return (DiagramConnectionLabelModel)this.getModel();
    }

    public EditPart getParent() {
        EditPart parent = super.getParent();
        if (parent instanceof DiagramConnectionEditPart) {
            DiagramConnectionEditPart connectionEditPart = (DiagramConnectionEditPart)parent;
            if (connectionEditPart.getSource() != null) {
                return connectionEditPart.getSource().getParent();
            }
            if (connectionEditPart.getTarget() != null) {
                connectionEditPart.getTarget().getParent();
            }
        }
        return parent;
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().addPropertyChangeListener(this);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getCastedModel().removePropertyChangeListener(this);
        }
    }

    private void performDirectEdit() {
        if (this.manager == null) {
            Label label = (Label)this.getFigure();
            this.manager = new ConnectionDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new ConnectionEditorLocator(label), label);
        }
        this.manager.show();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            if (!(request instanceof DirectEditRequest)) {
                this.performDirectEdit();
            }
        } else if (request.getType().equals("open")) {
            this.performDirectEdit();
        }
    }

    private void refreshLabel() {
        ((Label)this.getFigure()).setText(this.getDiagramConnectionPart().getLabel());
    }

    private void refreshLabelLocation() {
        PolylineConnection parent = (PolylineConnection)this.getFigure().getParent();
        Point position = this.getDiagramConnectionPart().getLabelPosition();
        SapphireMidpointLocator locator = position == null ? new SapphireMidpointLocator(this.getConfigurationManager(), (Connection)parent) : new SapphireMidpointLocator(this.getConfigurationManager(), (Connection)parent, position.getX(), position.getY());
        parent.getLayoutManager().setConstraint(this.getFigure(), (Object)locator);
    }

    public void refresh() {
        super.refresh();
        this.refreshLabel();
        this.refreshLabelLocation();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("CONNECTION_LABEL".equals(prop)) {
            this.refreshLabel();
        } else if ("CONNECTION_LABEL_MOVED".equals(prop)) {
            this.refreshLabelLocation();
            this.getFigure().revalidate();
        } else if ("CONNECTION_START_EDITING".equals(prop)) {
            this.performDirectEdit();
        }
    }
}

