/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer.actions.internal;

import java.util.SortedSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.ui.PropertyEditorPart;
import org.eclipse.sapphire.ui.SapphireBrowseActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.renderers.swt.ValueLabelProvider;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public final class PossibleValuesBrowseActionHandler
extends SapphireBrowseActionHandler {
    public static final String ID = "Sapphire.Browse.Possible";

    public PossibleValuesBrowseActionHandler() {
        this.setId(ID);
    }

    protected String browse(SapphireRenderingContext context) {
        ValueProperty property = this.getProperty();
        PossibleValuesService valuesProvider = (PossibleValuesService)this.getModelElement().service((ModelProperty)property, PossibleValuesService.class);
        if (valuesProvider != null) {
            SortedSet valuesList = valuesProvider.values();
            Object[] valuesArray = valuesList.toArray(new String[valuesList.size()]);
            ValueLabelProvider labelProvider = new ValueLabelProvider((PropertyEditorPart)this.getPart(), property);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(context.getShell(), (ILabelProvider)labelProvider);
            dialog.setElements(valuesArray);
            dialog.setMultipleSelection(false);
            dialog.setHelpAvailable(false);
            dialog.setTitle(property.getLabel(false, CapitalizationType.TITLE_STYLE, false));
            dialog.setMessage(this.createBrowseDialogMessage(property.getLabel(true, CapitalizationType.NO_CAPS, false)));
            dialog.open();
            Object[] result = dialog.getResult();
            if (result != null && result.length == 1) {
                return (String)result[0];
            }
        }
        return null;
    }
}

