/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.Arrays;
import org.eclipse.sapphire.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event {
    public boolean supersedes(Event event) {
        return false;
    }

    public static final Listener filter(Listener listener, Class<?> ... types) {
        if (types.length == 0) {
            return new FilteredListenerForZero(listener);
        }
        if (types.length == 1) {
            return new FilteredListenerForOne(listener, types[0]);
        }
        if (types.length == 2) {
            return new FilteredListenerForTwo(listener, types[0], types[1]);
        }
        if (types.length == 3) {
            return new FilteredListenerForThree(listener, types[0], types[1], types[2]);
        }
        return new FilteredListenerForMultiple(listener, types);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FilteredListenerForMultiple
    extends Listener {
        private final Listener listener;
        private final Class<?>[] eventTypes;

        public FilteredListenerForMultiple(Listener listener, Class<?>[] eventTypes) {
            this.listener = listener;
            this.eventTypes = eventTypes;
        }

        @Override
        public void handle(Event event) {
            boolean ok = false;
            Class<?>[] classArray = this.eventTypes;
            int n = this.eventTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type = classArray[n2];
                if (type.isInstance(event)) {
                    ok = true;
                    break;
                }
                ++n2;
            }
            if (ok) {
                this.listener.handle(event);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof FilteredListenerForMultiple) {
                FilteredListenerForMultiple x = (FilteredListenerForMultiple)obj;
                return this.listener.equals(x.listener) && Arrays.equals(this.eventTypes, x.eventTypes);
            }
            return false;
        }

        public int hashCode() {
            int hashcode = this.listener.hashCode();
            Class<?>[] classArray = this.eventTypes;
            int n = this.eventTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> eventType = classArray[n2];
                hashcode ^= eventType.hashCode();
                ++n2;
            }
            return hashcode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FilteredListenerForOne
    extends Listener {
        private final Listener listener;
        private final Class<?> eventType;

        public FilteredListenerForOne(Listener listener, Class<?> eventType) {
            this.listener = listener;
            this.eventType = eventType;
        }

        @Override
        public void handle(Event event) {
            if (this.eventType.isInstance(event)) {
                this.listener.handle(event);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof FilteredListenerForOne) {
                FilteredListenerForOne x = (FilteredListenerForOne)obj;
                return this.listener.equals(x.listener) && this.eventType == x.eventType;
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode() ^ this.eventType.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FilteredListenerForThree
    extends Listener {
        private final Listener listener;
        private final Class<?> eventType1;
        private final Class<?> eventType2;
        private final Class<?> eventType3;

        public FilteredListenerForThree(Listener listener, Class<?> eventType1, Class<?> eventType2, Class<?> eventType3) {
            this.listener = listener;
            this.eventType1 = eventType1;
            this.eventType2 = eventType2;
            this.eventType3 = eventType3;
        }

        @Override
        public void handle(Event event) {
            if (this.eventType1.isInstance(event) || this.eventType2.isInstance(event) || this.eventType3.isInstance(event)) {
                this.listener.handle(event);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof FilteredListenerForThree) {
                FilteredListenerForThree x = (FilteredListenerForThree)obj;
                return this.listener.equals(x.listener) && this.eventType1 == x.eventType1 && this.eventType2 == x.eventType2 && this.eventType3 == x.eventType3;
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode() ^ this.eventType1.hashCode() ^ this.eventType2.hashCode() ^ this.eventType3.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FilteredListenerForTwo
    extends Listener {
        private final Listener listener;
        private final Class<?> eventType1;
        private final Class<?> eventType2;

        public FilteredListenerForTwo(Listener listener, Class<?> eventType1, Class<?> eventType2) {
            this.listener = listener;
            this.eventType1 = eventType1;
            this.eventType2 = eventType2;
        }

        @Override
        public void handle(Event event) {
            if (this.eventType1.isInstance(event) || this.eventType2.isInstance(event)) {
                this.listener.handle(event);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof FilteredListenerForTwo) {
                FilteredListenerForTwo x = (FilteredListenerForTwo)obj;
                return this.listener.equals(x.listener) && this.eventType1 == x.eventType1 && this.eventType2 == x.eventType2;
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode() ^ this.eventType1.hashCode() ^ this.eventType2.hashCode();
        }
    }

    private static final class FilteredListenerForZero
    extends Listener {
        private final Listener listener;

        public FilteredListenerForZero(Listener listener) {
            this.listener = listener;
        }

        public void handle(Event event) {
        }

        public boolean equals(Object obj) {
            if (obj instanceof FilteredListenerForZero) {
                FilteredListenerForZero x = (FilteredListenerForZero)obj;
                return this.listener.equals(x.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

