/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.help.IContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.ISapphireEditorActionContributor;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphireHelpContext;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.def.SapphireUiDefFactory;
import org.eclipse.sapphire.ui.diagram.def.IDiagramEditorPageDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPageEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPartEvent;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramPartListener;
import org.eclipse.sapphire.ui.diagram.layout.DiagramLayoutPersistenceService;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.sapphire.ui.swt.ActionBridge;
import org.eclipse.sapphire.ui.swt.ActionSystemPartBridge;
import org.eclipse.sapphire.ui.swt.EditorPagePresentation;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.DiagramRenderingContext;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditorFactory;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramGridLayer;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramKeyHandler;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramOutline;
import org.eclipse.sapphire.ui.swt.gef.SapphirePaletteRoot;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.ContextButtonManager;
import org.eclipse.sapphire.ui.swt.gef.dnd.ObjectsTransferDropTargetListener;
import org.eclipse.sapphire.ui.swt.gef.dnd.SapphireTemplateTransferDropTargetListener;
import org.eclipse.sapphire.ui.swt.gef.internal.DiagramEditorContextMenuProvider;
import org.eclipse.sapphire.ui.swt.gef.layout.HorizontalGraphLayout;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModelBase;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.palette.DefaultFlyoutPalettePreferences;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramConnectionEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramNodeEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.SapphireDiagramEditorEditPartFactory;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarManagerActionPresentation;
import org.eclipse.sapphire.ui.util.SapphireHelpSystem;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.SizeCache;
import org.eclipse.ui.internal.forms.widgets.FormHeading;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphireDiagramEditor
extends GraphicalEditorWithFlyoutPalette
implements ISapphireEditorActionContributor,
EditorPagePresentation {
    private DiagramLayoutPersistenceService layoutPersistenceService;
    private PaletteRoot root;
    private IDiagramEditorPageDef diagramPageDef;
    private SapphireDiagramEditorPagePart diagramPart;
    private DiagramModel diagramModel;
    private SapphireDiagramPartListener diagramPartListener;
    private Listener layoutPersistenceServiceListener;
    private List<ISapphirePart> selectedParts = new ArrayList<ISapphirePart>();
    private List<GraphicalEditPart> selectedEditParts = null;
    private boolean editorIsDirty = false;
    private Point mouseLocation;
    private DiagramConfigurationManager configManager;
    private GraphicalViewerKeyHandler graphicalViewerKeyHandler;
    private SapphireDiagramKeyHandler diagramKeyHandler;
    private ContextButtonManager contextButtonManager = null;
    private FormHeading header;
    private String headerText;
    private Composite body;
    private SizeCache bodyCache = new SizeCache();
    private SizeCache headCache = new SizeCache();
    private FormColors formColors;
    private Listener diagramEditorPagePartListener;
    private Map<String, ActionBridge> globalActions;
    private SapphireDiagramOutline diagramOutline;

    public SapphireDiagramEditor(SapphireEditor editor, IModelElement rootModelElement, IPath pageDefinitionLocation) {
        String bundleId = pageDefinitionLocation.segment(0);
        String pageId = pageDefinitionLocation.lastSegment();
        String relPath = pageDefinitionLocation.removeFirstSegments(1).removeLastSegments(1).toPortableString();
        ISapphireUiDef def = SapphireUiDefFactory.load((String)bundleId, (String)relPath);
        this.diagramPageDef = (IDiagramEditorPageDef)def.getPartDef(pageId, true, IDiagramEditorPageDef.class);
        String partName = this.diagramPageDef.getPageName().getLocalizedText(CapitalizationType.TITLE_STYLE, false);
        this.setPartName(partName);
        this.diagramPart = new SapphireDiagramEditorPagePart();
        this.diagramPart.init((ISapphirePart)editor, rootModelElement, (PartDef)this.diagramPageDef, Collections.emptyMap());
        this.layoutPersistenceService = SapphireDiagramEditorFactory.getLayoutPersistenceService(this.diagramPart);
        this.configManager = new DiagramConfigurationManager(this);
        this.diagramModel = new DiagramModel(this.diagramPart, this.configManager);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.diagramPartListener = new SapphireDiagramPartListener(){

            public void handleNodeUpdateEvent(DiagramNodeEvent event) {
                SapphireDiagramEditor.this.updateNode((DiagramNodePart)event.getPart());
            }

            public void handleNodeAddEvent(DiagramNodeEvent event) {
                SapphireDiagramEditor.this.addNode((DiagramNodePart)event.getPart());
            }

            public void handleNodeDeleteEvent(DiagramNodeEvent event) {
                SapphireDiagramEditor.this.removeNode((DiagramNodePart)event.getPart());
            }

            public void handleNodeMoveEvent(DiagramNodeEvent event) {
                DiagramNodePart nodePart = (DiagramNodePart)event.getPart();
                SapphireDiagramEditor.this.moveNode(nodePart);
            }

            public void handleConnectionUpdateEvent(DiagramConnectionEvent event) {
                SapphireDiagramEditor.this.updateConnection((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionEndpointEvent(DiagramConnectionEvent event) {
                SapphireDiagramEditor.this.updateConnectionEndpoint((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionAddEvent(DiagramConnectionEvent event) {
                SapphireDiagramEditor.this.addConnectionIfPossible((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionDeleteEvent(DiagramConnectionEvent event) {
                SapphireDiagramEditor.this.removeConnection((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionAddBendpointEvent(DiagramConnectionEvent event) {
                DiagramConnectionPart connPart = (DiagramConnectionPart)event.getPart();
                SapphireDiagramEditor.this.updateConnectionBendpoint(connPart);
            }

            public void handleConnectionRemoveBendpointEvent(DiagramConnectionEvent event) {
                DiagramConnectionPart connPart = (DiagramConnectionPart)event.getPart();
                SapphireDiagramEditor.this.updateConnectionBendpoint(connPart);
            }

            public void handleConnectionMoveBendpointEvent(DiagramConnectionEvent event) {
                DiagramConnectionPart connPart = (DiagramConnectionPart)event.getPart();
                SapphireDiagramEditor.this.updateConnectionBendpoint(connPart);
            }

            public void handleConnectionResetBendpointsEvent(DiagramConnectionEvent event) {
                DiagramConnectionPart connPart = (DiagramConnectionPart)event.getPart();
                SapphireDiagramEditor.this.updateConnectionBendpoint(connPart);
            }

            public void handleConnectionMoveLabelEvent(DiagramConnectionEvent event) {
                DiagramConnectionPart connPart = (DiagramConnectionPart)event.getPart();
                SapphireDiagramEditor.this.updateConnectionMoveLabel(connPart);
            }

            public void handleDirectEditEvent(DiagramPartEvent event) {
                SapphireDiagramEditor.this.selectAndDirectEditPart(event.getPart());
            }

            public void handleGridStateChangeEvent(DiagramPageEvent event) {
                SapphireDiagramEditor.this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)new Boolean(SapphireDiagramEditor.this.diagramPart.isGridVisible()));
                SapphireDiagramEditor.this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)new Boolean(SapphireDiagramEditor.this.diagramPart.isGridVisible()));
                SapphireDiagramEditor.this.getGraphicalViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(SapphireDiagramEditor.this.diagramPart.getGridUnit(), SapphireDiagramEditor.this.diagramPart.getVerticalGridUnit()));
                SapphireDiagramEditor.this.markEditorDirty();
            }

            public void handleGuideStateChangeEvent(DiagramPageEvent event) {
                SapphireDiagramEditor.this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)new Boolean(SapphireDiagramEditor.this.diagramPart.isShowGuides()));
                SapphireDiagramEditor.this.markEditorDirty();
            }

            public void handleDiagramUpdateEvent(DiagramPageEvent event) {
                SapphireDiagramEditor.this.refreshPalette();
            }

            public void handleSelectAllEvent(DiagramPageEvent event) {
                SapphireDiagramEditor.this.selectAll();
            }

            public void handleSelectAllNodesEvent(DiagramPageEvent event) {
                SapphireDiagramEditor.this.selectAllNodes();
            }
        };
        this.diagramPart.addListener((SapphirePartListener)this.diagramPartListener);
        this.layoutPersistenceServiceListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof DiagramLayoutPersistenceService.DirtyStateEvent) {
                    DiagramLayoutPersistenceService.DirtyStateEvent evt = (DiagramLayoutPersistenceService.DirtyStateEvent)event;
                    if (evt.after()) {
                        SapphireDiagramEditor.this.markEditorDirty();
                    } else {
                        SapphireDiagramEditor.this.markEditorClean();
                    }
                }
            }
        };
        this.layoutPersistenceService.attach(this.layoutPersistenceServiceListener);
        this.diagramEditorPagePartListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphirePart.ImageChangedEvent) {
                    SapphireDiagramEditor.this.refreshFormHeaderImage();
                } else if (event instanceof SapphireDiagramEditorPagePart.ZoomLevelEvent) {
                    SapphireDiagramEditor.this.refreshZoomLevel();
                }
            }
        };
        this.diagramPart.attach(this.diagramEditorPagePartListener);
    }

    public IDiagramEditorPageDef getDiagramEditorPageDef() {
        return this.diagramPageDef;
    }

    public DiagramLayoutPersistenceService getLayoutPersistenceService() {
        return this.layoutPersistenceService;
    }

    public boolean isDirty() {
        return this.editorIsDirty;
    }

    protected void markEditorDirty() {
        this.editorIsDirty = true;
        this.firePropertyChange(257);
    }

    protected void markEditorClean() {
        this.editorIsDirty = false;
        this.firePropertyChange(257);
    }

    public DefaultEditDomain getEditDomain() {
        return super.getEditDomain();
    }

    protected void removeConnection(DiagramConnectionPart connPart) {
        if (this.diagramModel == null) {
            return;
        }
        this.diagramModel.removeConnection(connPart);
        this.getConfigurationManager().getDiagramRenderingContextCache().remove((ISapphirePart)connPart);
    }

    private void addConnection(DiagramConnectionPart connPart) {
        this.diagramModel.addConnection(connPart);
        DiagramRenderingContext ctx = new DiagramRenderingContext((ISapphirePart)connPart, this);
        this.getConfigurationManager().getDiagramRenderingContextCache().put((ISapphirePart)connPart, ctx);
    }

    protected void addConnectionIfPossible(DiagramConnectionPart connPart) {
        if (this.diagramModel == null) {
            return;
        }
        IModelElement endpoint1 = connPart.getEndpoint1();
        IModelElement endpoint2 = connPart.getEndpoint2();
        DiagramNodePart nodePart1 = this.diagramPart.getDiagramNodePart(endpoint1);
        DiagramNodePart nodePart2 = this.diagramPart.getDiagramNodePart(endpoint2);
        GraphicalEditPart node1 = this.getGraphicalEditPart((ISapphirePart)nodePart1);
        GraphicalEditPart node2 = this.getGraphicalEditPart((ISapphirePart)nodePart2);
        if (node1 != null && node2 != null) {
            this.addConnection(connPart);
        }
    }

    private void refreshConnectionNodes(DiagramConnectionPart connPart) {
        if (this.diagramModel == null) {
            return;
        }
        DiagramConnectionModel connectionModel = this.diagramModel.getDiagramConnectionModel(connPart);
        if (connectionModel != null) {
            connectionModel.handleUpdateConnection();
        }
    }

    protected void updateConnectionEndpoint(DiagramConnectionPart connPart) {
        IModelElement endpoint1 = connPart.getEndpoint1();
        IModelElement endpoint2 = connPart.getEndpoint2();
        DiagramNodePart nodePart1 = this.diagramPart.getDiagramNodePart(endpoint1);
        DiagramNodePart nodePart2 = this.diagramPart.getDiagramNodePart(endpoint2);
        GraphicalEditPart newSrcNode = this.getGraphicalEditPart((ISapphirePart)nodePart1);
        GraphicalEditPart newTargetNode = this.getGraphicalEditPart((ISapphirePart)nodePart2);
        ConnectionEditPart connEditPart = (ConnectionEditPart)this.getGraphicalEditPart((ISapphirePart)connPart);
        GraphicalEditPart oldSrcNode = null;
        GraphicalEditPart oldTargetNode = null;
        if (connEditPart != null) {
            oldSrcNode = (GraphicalEditPart)connEditPart.getSource();
            oldTargetNode = (GraphicalEditPart)connEditPart.getTarget();
        }
        if ((oldSrcNode != newSrcNode || oldTargetNode != newTargetNode) && newSrcNode != null && newTargetNode != null) {
            this.removeConnection(connPart);
            this.addConnection(connPart);
        }
    }

    protected void updateConnection(DiagramConnectionPart connPart) {
        this.refreshConnectionNodes(connPart);
    }

    protected void updateConnectionMoveLabel(DiagramConnectionPart connPart) {
        if (this.diagramModel == null) {
            return;
        }
        DiagramConnectionModel connectionModel = this.diagramModel.getDiagramConnectionModel(connPart);
        if (connectionModel != null) {
            connectionModel.handleUpdateConnectionMoveLabel();
        }
    }

    protected void updateConnectionBendpoint(DiagramConnectionPart connPart) {
        if (this.diagramModel == null) {
            return;
        }
        DiagramConnectionModel connectionModel = this.diagramModel.getDiagramConnectionModel(connPart);
        if (connectionModel != null) {
            connectionModel.handleUpdateBendPoints();
        }
    }

    protected void moveNode(DiagramNodePart part) {
        if (this.diagramModel == null) {
            return;
        }
        DiagramNodeModel nodeModel = this.diagramModel.getDiagramNodeModel(part);
        if (nodeModel != null) {
            nodeModel.handleMoveNode();
        }
    }

    protected void removeNode(DiagramNodePart part) {
        if (this.diagramModel == null) {
            return;
        }
        this.diagramModel.handleRemoveNode(part);
        this.getConfigurationManager().getDiagramRenderingContextCache().remove((ISapphirePart)part);
    }

    protected void addNode(DiagramNodePart part) {
        if (this.diagramModel == null) {
            return;
        }
        this.diagramModel.handleAddNode(part);
        DiagramRenderingContext ctx = new DiagramRenderingContext((ISapphirePart)part, this);
        this.getConfigurationManager().getDiagramRenderingContextCache().put((ISapphirePart)part, ctx);
    }

    protected void updateNode(DiagramNodePart part) {
        if (this.diagramModel == null) {
            return;
        }
        DiagramNodeModel nodeModel = this.diagramModel.getDiagramNodeModel(part);
        if (nodeModel != null) {
            nodeModel.handleUpdateNode();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IEditorPart activeEditor;
        boolean editorIsActive = this.getSite().getPage().isPartVisible((IWorkbenchPart)this);
        if (!editorIsActive && (activeEditor = this.getSite().getPage().getActiveEditor()) != null) {
            editorIsActive = this.getSite().getPage().isPartVisible((IWorkbenchPart)activeEditor);
            if (activeEditor instanceof FormEditor && !((Object)((Object)this)).equals(((FormEditor)activeEditor).getActiveEditor())) {
                editorIsActive = false;
            }
        }
        if (editorIsActive && selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            ArrayList<ISapphirePart> partList = new ArrayList<ISapphirePart>();
            ArrayList<GraphicalEditPart> editPartList = new ArrayList<GraphicalEditPart>();
            for (Object object : structuredSelection) {
                EditPart editPart = null;
                if (object instanceof EditPart) {
                    editPart = (EditPart)object;
                } else if (object instanceof IAdaptable) {
                    editPart = (EditPart)((IAdaptable)object).getAdapter(EditPart.class);
                }
                if (editPart == null || !(editPart.getModel() instanceof DiagramModelBase)) continue;
                SapphirePart sp = ((DiagramModelBase)editPart.getModel()).getSapphirePart();
                partList.add((ISapphirePart)sp);
                editPartList.add((GraphicalEditPart)editPart);
            }
            if (!partList.isEmpty()) {
                this.getPart().setSelections(partList);
                this.selectedParts = partList;
                this.selectedEditParts = editPartList;
                this.updateKeyHandler();
                if (partList.size() > 1) {
                    this.contextButtonManager.hideContextButtonsInstantly();
                }
            }
        }
    }

    private void initActions() {
        DiagramRenderingContext diagramRenderingContext = this.getConfigurationManager().getDiagramRenderingContextCache().get((ISapphirePart)this.diagramPart);
        this.globalActions = new HashMap<String, ActionBridge>();
        ActionBridge selectAllBridge = new ActionBridge((SapphireRenderingContext)diagramRenderingContext, this.diagramPart.getAction("Sapphire.Diagram.SelectAll"));
        this.globalActions.put(ActionFactory.SELECT_ALL.getId(), selectAllBridge);
        ActionBridge deleteBridge = new ActionBridge((SapphireRenderingContext)diagramRenderingContext, this.diagramPart.getAction("Sapphire.Delete"));
        this.globalActions.put(ActionFactory.DELETE.getId(), deleteBridge);
        ActionBridge printBridge = new ActionBridge((SapphireRenderingContext)diagramRenderingContext, this.diagramPart.getAction("Sapphire.Diagram.Print"));
        this.globalActions.put(ActionFactory.PRINT.getId(), printBridge);
    }

    private void updateKeyHandler() {
        if (this.diagramKeyHandler != null) {
            this.diagramKeyHandler.dispose();
            this.diagramKeyHandler = null;
        }
        List<ISapphirePart> selectedParts = this.getSelectedParts();
        this.diagramKeyHandler = new SapphireDiagramKeyHandler(this, selectedParts);
        if (this.graphicalViewerKeyHandler == null) {
            this.graphicalViewerKeyHandler = new GraphicalViewerKeyHandler(this.getGraphicalViewer());
        }
        KeyHandler parentKeyHandler = this.graphicalViewerKeyHandler.setParent((KeyHandler)this.diagramKeyHandler);
        this.getGraphicalViewer().setKeyHandler(parentKeyHandler);
    }

    private void refreshPalette() {
        PaletteRoot pr = this.getPaletteRoot();
        if (pr instanceof SapphirePaletteRoot) {
            SapphirePaletteRoot spr = (SapphirePaletteRoot)pr;
            spr.updatePaletteEntries();
        }
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.root == null) {
            this.root = new SapphirePaletteRoot(this.diagramPart);
        }
        return this.root;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.diagramPart.saveDiagram();
            this.markEditorClean();
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log((Throwable)e);
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.getControl().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                SapphireDiagramEditor.this.setMouseLocation(e.x, e.y);
            }
        });
        viewer.setContents((Object)this.diagramModel);
        viewer.addDropTargetListener((TransferDropTargetListener)new SapphireTemplateTransferDropTargetListener(this));
        viewer.addDropTargetListener((org.eclipse.jface.util.TransferDropTargetListener)new ObjectsTransferDropTargetListener((EditPartViewer)viewer));
        this.postInit();
    }

    private void postInit() {
        this.initRenderingContext();
        this.initActions();
        this.configureDiagramHeading();
        if (this.hasNoExistingLayout()) {
            new HorizontalGraphLayout().layout(this, true);
            this.markEditorClean();
        }
    }

    private void initRenderingContext() {
        DiagramRenderingContext ctx = new DiagramRenderingContext((ISapphirePart)this.diagramPart, this);
        this.configManager.getDiagramRenderingContextCache().put((ISapphirePart)this.diagramPart, ctx);
        List<DiagramNodeModel> nodes = this.diagramModel.getNodes();
        for (DiagramNodeModel node : nodes) {
            ctx = new DiagramRenderingContext((ISapphirePart)node.getModelPart(), this);
            this.getConfigurationManager().getDiagramRenderingContextCache().put((ISapphirePart)node.getModelPart(), ctx);
        }
        List<DiagramConnectionModel> conns = this.diagramModel.getConnections();
        for (DiagramConnectionModel conn : conns) {
            ctx = new DiagramRenderingContext((ISapphirePart)conn.getModelPart(), this);
            this.getConfigurationManager().getDiagramRenderingContextCache().put((ISapphirePart)conn.getModelPart(), ctx);
        }
    }

    private boolean hasNoExistingLayout() {
        if (this.layoutPersistenceService == null) {
            return true;
        }
        List<DiagramNodeModel> nodes = this.diagramModel.getNodes();
        for (DiagramNodeModel node : nodes) {
            DiagramNodePart nodePart = node.getModelPart();
            DiagramNodeBounds bounds = nodePart.getNodeBounds();
            if (bounds.getX() != -1 && bounds.getY() != -1) continue;
            return true;
        }
        return false;
    }

    public DiagramModel getDiagramModel() {
        return this.diagramModel;
    }

    public DiagramResourceCache getResourceCache() {
        return this.diagramModel.getResourceCache();
    }

    public DiagramConfigurationManager getConfigurationManager() {
        return this.configManager;
    }

    public ContextButtonManager getContextButtonManager() {
        return this.contextButtonManager;
    }

    public void createPartControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FormLayout());
        this.header = new FormHeading(main, 0);
        this.headerText = this.diagramPageDef.getPageHeaderText().getLocalizedText(CapitalizationType.TITLE_STYLE, false);
        this.formColors = new FormColors(parent.getDisplay());
        super.createPartControl(main);
        this.body = this.getGraphicalControl().getParent();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new SapphireDiagramEditorEditPartFactory(this.getConfigurationManager()));
        viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart(){

            protected GridLayer createGridLayer() {
                return new SapphireDiagramGridLayer(SapphireDiagramEditor.this.diagramModel);
            }
        });
        DiagramEditorContextMenuProvider cmProvider = new DiagramEditorContextMenuProvider(this);
        viewer.setContextMenu((MenuManager)cmProvider);
        boolean isGridVisibleInViewer = false;
        if (viewer.getProperty("SnapToGrid.isVisible") != null) {
            isGridVisibleInViewer = (Boolean)viewer.getProperty("SnapToGrid.isVisible");
        }
        if (this.diagramPart.isGridVisible() != isGridVisibleInViewer) {
            viewer.setProperty("SnapToGrid.isVisible", (Object)this.diagramPart.isGridVisible());
            viewer.setProperty("SnapToGrid.isEnabled", (Object)this.diagramPart.isGridVisible());
            viewer.setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(this.diagramPart.getGridUnit(), this.diagramPart.getVerticalGridUnit()));
        }
        boolean isShowGuidesInViewer = false;
        if (viewer.getProperty("SnapToGeometry.isEnabled") != null) {
            isShowGuidesInViewer = (Boolean)viewer.getProperty("SnapToGeometry.isEnabled");
        }
        if (this.diagramPart.isShowGuides() != isShowGuidesInViewer) {
            viewer.setProperty("SnapToGeometry.isEnabled", (Object)this.diagramPart.isShowGuides());
        }
        this.getGraphicalControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                ISapphirePart part;
                SapphireHelpContext context;
                if (SapphireDiagramEditor.this.getSelectedParts() != null && SapphireDiagramEditor.this.getSelectedParts().size() == 1 && ((context = new SapphireHelpContext((part = SapphireDiagramEditor.this.getSelectedParts().get(0)).getLocalModelElement(), null)).getText() != null || context.getRelatedTopics() != null && context.getRelatedTopics().length > 0)) {
                    org.eclipse.swt.graphics.Point point = SapphireHelpSystem.computePopUpLocation((Display)event.widget.getDisplay());
                    PlatformUI.getWorkbench().getHelpSystem().displayContext((IContext)context, point.x, point.y);
                }
            }
        });
        this.contextButtonManager = new ContextButtonManager(this);
        int zoomLevel = (Integer)this.getPart().getState().getZoomLevel().getContent();
        double zoom = (double)zoomLevel / 100.0;
        this.getZoomManager().setZoom(zoom);
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return new DefaultFlyoutPalettePreferences(this.getPart().getState());
    }

    public IAction getAction(String actionId) {
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            return (IAction)this.globalActions.get(ActionFactory.SELECT_ALL.getId());
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            return (IAction)this.globalActions.get(ActionFactory.DELETE.getId());
        }
        if (actionId.equals(ActionFactory.PRINT.getId())) {
            return (IAction)this.globalActions.get(ActionFactory.PRINT.getId());
        }
        return this.getActionRegistry().getAction((Object)actionId);
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            return this.getDiagramOutline();
        }
        return super.getAdapter(type);
    }

    public SapphireDiagramEditorPagePart getPart() {
        return this.diagramPart;
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public List<ISapphirePart> getSelectedParts() {
        return this.selectedParts;
    }

    public List<GraphicalEditPart> getSelectedEditParts() {
        return this.selectedEditParts;
    }

    public GraphicalEditPart getGraphicalEditPart(ISapphirePart sapphirePart) {
        if (sapphirePart instanceof DiagramNodePart || sapphirePart instanceof DiagramConnectionPart) {
            GraphicalViewer viewer = this.getGraphicalViewer();
            Object editpartObj = null;
            DiagramNodePart nodePart = null;
            DiagramConnectionPart connPart = null;
            if (sapphirePart instanceof DiagramNodePart) {
                nodePart = (DiagramNodePart)sapphirePart;
                DiagramNodeModel nodeModel = this.getDiagramModel().getDiagramNodeModel(nodePart);
                editpartObj = viewer.getEditPartRegistry().get(nodeModel);
            } else if (sapphirePart instanceof DiagramConnectionPart) {
                connPart = (DiagramConnectionPart)sapphirePart;
                DiagramConnectionModel connModel = this.getDiagramModel().getDiagramConnectionModel(connPart);
                editpartObj = viewer.getEditPartRegistry().get(connModel);
            }
            return editpartObj;
        }
        return null;
    }

    public void selectAndDirectEditPart(ISapphirePart part) {
        if (part instanceof DiagramNodePart || part instanceof DiagramConnectionPart) {
            GraphicalViewer viewer = this.getGraphicalViewer();
            GraphicalEditPart editpart = this.getGraphicalEditPart(part);
            if (editpart != null) {
                viewer.flush();
                viewer.select((EditPart)editpart);
                if (part instanceof DiagramNodePart) {
                    this.getDiagramModel().handleDirectEditing((DiagramNodePart)part);
                } else if (part instanceof DiagramConnectionPart) {
                    this.getDiagramModel().handleDirectEditing((DiagramConnectionPart)part);
                }
            }
        }
    }

    public void selectAll() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        for (Object obj : viewer.getEditPartRegistry().values()) {
            if (!(obj instanceof DiagramConnectionEditPart) && !(obj instanceof DiagramNodeEditPart)) continue;
            viewer.appendSelection((EditPart)obj);
        }
    }

    public void selectAllNodes() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.deselectAll();
        for (Object obj : viewer.getEditPartRegistry().values()) {
            if (!(obj instanceof DiagramNodeEditPart)) continue;
            viewer.appendSelection((EditPart)((DiagramNodeEditPart)obj));
        }
    }

    public Point getMouseLocation() {
        if (this.mouseLocation == null) {
            this.mouseLocation = new Point();
        }
        return this.mouseLocation;
    }

    private void setMouseLocation(int x, int y) {
        this.getMouseLocation().setLocation(x, y);
        Point realLocation = this.calculateRealMouseLocation(this.getMouseLocation());
        this.diagramPart.setMouseLocation(realLocation.x, realLocation.y);
    }

    public FigureCanvas getFigureCanvas() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        return (FigureCanvas)viewer.getControl();
    }

    public double getZoomLevel() {
        ZoomManager zoomManager = this.getZoomManager();
        if (zoomManager == null) {
            return 1.0;
        }
        return Math.max(0.05, zoomManager.getZoom());
    }

    public Point calculateRealMouseLocation(Point nativeLocation) {
        Point ret = new Point(nativeLocation);
        Point viewLocation = this.getFigureCanvas().getViewport().getViewLocation();
        ret.x += viewLocation.x;
        ret.y += viewLocation.y;
        ZoomManager zoomManager = this.getZoomManager();
        if (zoomManager != null) {
            ret = ret.getScaled(1.0 / zoomManager.getZoom());
        }
        return ret;
    }

    public void dispose() {
        super.dispose();
        this.diagramModel.dispose();
        this.diagramPart.dispose();
        this.diagramPart.removeListener((SapphirePartListener)this.diagramPartListener);
        this.layoutPersistenceService.detach(this.layoutPersistenceServiceListener);
        if (this.layoutPersistenceService != null) {
            this.layoutPersistenceService.dispose();
        }
        this.diagramPart.detach(this.diagramEditorPagePartListener);
        Image image = this.header.getImage();
        if (image != null) {
            image.dispose();
        }
        for (ActionSystemPartBridge actionSystemPartBridge : this.globalActions.values()) {
            actionSystemPartBridge.dispose();
        }
    }

    public void setDiagramHeaderText(String text) {
        this.headerText = LabelTransformer.transform((String)text, (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false);
        if (this.header != null) {
            this.header.setText(this.headerText);
            this.header.layout();
        }
    }

    private void configureDiagramHeading() {
        this.decorateHeading();
        this.header.setText(this.headerText);
        SapphireActionGroup actions = this.diagramPart.getActions("Sapphire.Diagram.Header");
        if (actions != null && !actions.isEmpty()) {
            DiagramRenderingContext context = this.configManager.getDiagramRenderingContextCache().get((ISapphirePart)this.diagramPart);
            SapphireActionPresentationManager actionPresentationManager = new SapphireActionPresentationManager((SapphireRenderingContext)context, actions);
            SapphireToolBarManagerActionPresentation actionPresentation = new SapphireToolBarManagerActionPresentation(actionPresentationManager);
            actionPresentation.setToolBarManager(this.header.getToolBarManager());
            actionPresentation.render();
        }
        this.refreshFormHeaderImage();
    }

    private void decorateHeading() {
        Color top = this.formColors.getColor("org.eclipse.ui.forms.H_GRADIENT_END");
        Color bot = this.formColors.getColor("org.eclipse.ui.forms.H_GRADIENT_START");
        this.header.setTextBackground(new Color[]{top, bot}, new int[]{100}, true);
        this.header.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", this.formColors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1"));
        this.header.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", this.formColors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2"));
        this.header.putColor("org.eclipse.ui.forms.H_H_HOVER_LIGHT", this.formColors.getColor("org.eclipse.ui.forms.H_H_HOVER_LIGHT"));
        this.header.putColor("org.eclipse.ui.forms.H_H_HOVER_FULL", this.formColors.getColor("org.eclipse.ui.forms.H_H_HOVER_FULL"));
        this.header.putColor("org.eclipse.ui.forms.TB_TOGGLE", this.formColors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.header.putColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER", this.formColors.getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER"));
        this.header.setSeparatorVisible(true);
        this.header.setFont(JFaceResources.getHeaderFont());
        this.header.setForeground(this.formColors.getColor("org.eclipse.ui.forms.TITLE"));
    }

    private void refreshFormHeaderImage() {
        ImageData newImageData;
        Image oldImage = this.header.getImage();
        if (oldImage != null) {
            oldImage.dispose();
        }
        if ((newImageData = this.diagramPart.getPageHeaderImage()) == null) {
            this.header.setImage(null);
        } else {
            this.header.setImage(SwtRendererUtil.toImageDescriptor((ImageData)newImageData).createImage());
        }
    }

    private void refreshZoomLevel() {
        int zoomLevel = this.diagramPart.getZoomLevel();
        double zoom = (double)zoomLevel / 100.0;
        this.getZoomManager().setZoom(zoom);
    }

    private ZoomManager getZoomManager() {
        return (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
    }

    private SapphireDiagramOutline getDiagramOutline() {
        RootEditPart rootEditPart;
        if (this.diagramOutline == null && this.getGraphicalViewer() != null && (rootEditPart = this.getGraphicalViewer().getRootEditPart()) instanceof ScalableFreeformRootEditPart) {
            this.diagramOutline = new SapphireDiagramOutline((ScalableFreeformRootEditPart)rootEditPart);
        }
        return this.diagramOutline;
    }

    private class FormLayout
    extends Layout
    implements ILayoutExtension {
        private FormLayout() {
        }

        public int computeMinimumWidth(Composite composite, boolean flushCache) {
            return this.computeSize((Composite)composite, (int)5, (int)-1, (boolean)flushCache).x;
        }

        public int computeMaximumWidth(Composite composite, boolean flushCache) {
            return this.computeSize((Composite)composite, (int)-1, (int)-1, (boolean)flushCache).x;
        }

        public org.eclipse.swt.graphics.Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (flushCache) {
                SapphireDiagramEditor.this.bodyCache.flush();
                SapphireDiagramEditor.this.headCache.flush();
            }
            SapphireDiagramEditor.this.bodyCache.setControl((Control)SapphireDiagramEditor.this.body);
            SapphireDiagramEditor.this.headCache.setControl((Control)SapphireDiagramEditor.this.header);
            int width = 0;
            int height = 0;
            org.eclipse.swt.graphics.Point hsize = SapphireDiagramEditor.this.headCache.computeSize(FormUtil.getWidthHint((int)wHint, (Control)SapphireDiagramEditor.this.header), -1);
            width = Math.max(hsize.x, width);
            height = hsize.y;
            boolean ignoreBody = false;
            org.eclipse.swt.graphics.Point bsize = ignoreBody ? new org.eclipse.swt.graphics.Point(0, 0) : SapphireDiagramEditor.this.bodyCache.computeSize(FormUtil.getWidthHint((int)wHint, (Control)SapphireDiagramEditor.this.body), -1);
            width = Math.max(bsize.x, width);
            return new org.eclipse.swt.graphics.Point(width, height += bsize.y);
        }

        protected void layout(Composite composite, boolean flushCache) {
            if (flushCache) {
                SapphireDiagramEditor.this.bodyCache.flush();
                SapphireDiagramEditor.this.headCache.flush();
            }
            SapphireDiagramEditor.this.bodyCache.setControl((Control)SapphireDiagramEditor.this.body);
            SapphireDiagramEditor.this.headCache.setControl((Control)SapphireDiagramEditor.this.header);
            Rectangle carea = composite.getClientArea();
            org.eclipse.swt.graphics.Point hsize = SapphireDiagramEditor.this.headCache.computeSize(carea.width, -1);
            SapphireDiagramEditor.this.headCache.setBounds(0, 0, carea.width, hsize.y);
            SapphireDiagramEditor.this.bodyCache.setBounds(0, hsize.y, carea.width, carea.height - hsize.y);
        }
    }
}

