/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.architecture.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.architecture.IComponent;
import org.eclipse.sapphire.samples.architecture.IComponentDependency;
import org.eclipse.sapphire.samples.architecture.Position;
import org.eclipse.sapphire.services.ValueNormalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Component
extends ModelElement
implements IComponent {
    private Value<String> copyright;
    private ModelElementList<IComponentDependency> dependencies;
    private Value<String> description;
    private Value<String> name;
    private ModelElementHandle<Position> position;
    private Value<String> provider;

    public Component(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public Component(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getCopyright() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.copyright == null) {
                this.refresh((ModelProperty)PROP_COPYRIGHT, true);
            }
            return this.copyright;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCopyright(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_COPYRIGHT.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_COPYRIGHT, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_COPYRIGHT, true);
            if (!Component.equal((String)this.copyright.getText(false), (String)value)) {
                this.resource().binding(PROP_COPYRIGHT).write(value);
                this.refresh((ModelProperty)PROP_COPYRIGHT, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IComponentDependency> getDependencies() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.dependencies == null) {
                this.refresh((ModelProperty)PROP_DEPENDENCIES, true);
            }
            return this.dependencies;
        }
    }

    protected void disposeProperties() {
        IModelElement element2;
        if (this.dependencies != null) {
            for (IModelElement element2 : this.dependencies) {
                element2.dispose();
            }
        }
        if (this.position != null && (element2 = this.position.element(false)) != null) {
            element2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getDescription() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.description == null) {
                this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            }
            return this.description;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_DESCRIPTION.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_DESCRIPTION, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            if (!Component.equal((String)this.description.getText(false), (String)value)) {
                this.resource().binding(PROP_DESCRIPTION).write(value);
                this.refresh((ModelProperty)PROP_DESCRIPTION, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getName() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.name == null) {
                this.refresh((ModelProperty)PROP_NAME, true);
            }
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_NAME.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_NAME, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_NAME, true);
            if (!Component.equal((String)this.name.getText(false), (String)value)) {
                this.resource().binding(PROP_NAME).write(value);
                this.refresh((ModelProperty)PROP_NAME, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Position getPosition() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.position == null) {
                this.refresh((ModelProperty)PROP_POSITION, true);
            }
            return (Position)this.position.element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getProvider() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.provider == null) {
                this.refresh((ModelProperty)PROP_PROVIDER, true);
            }
            return this.provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProvider(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_PROVIDER.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_PROVIDER, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_PROVIDER, true);
            if (!Component.equal((String)this.provider.getText(false), (String)value)) {
                this.resource().binding(PROP_PROVIDER).write(value);
                this.refresh((ModelProperty)PROP_PROVIDER, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_COPYRIGHT) {
                if (this.copyright != null || force) {
                    Value<String> oldValue = this.copyright;
                    String val = this.resource().binding(PROP_COPYRIGHT).read();
                    this.copyright = new Value((IModelElement)this, PROP_COPYRIGHT, ((ValueNormalizationService)this.service((ModelProperty)PROP_COPYRIGHT, ValueNormalizationService.class)).normalize(PROP_COPYRIGHT.encodeKeywords(val)));
                    this.copyright.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_COPYRIGHT);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_COPYRIGHT));
                    } else {
                        if (this.copyright.equals(oldValue)) {
                            this.copyright = oldValue;
                        } else {
                            if (!Component.equal((String)this.copyright.getText(false), (String)oldValue.getText(false)) || !Component.equal((String)this.copyright.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_COPYRIGHT));
                            }
                            if (!this.copyright.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_COPYRIGHT, oldValue.validation(), this.copyright.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_COPYRIGHT, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_DEPENDENCIES) {
                if (this.dependencies == null) {
                    if (force) {
                        this.dependencies = new ModelElementList((IModelElement)this, PROP_DEPENDENCIES);
                        ListBindingImpl binding = this.resource().binding(PROP_DEPENDENCIES);
                        this.dependencies.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_DEPENDENCIES);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_DEPENDENCIES));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DEPENDENCIES);
                    boolean notified = this.dependencies.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_DEPENDENCIES, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_DESCRIPTION) {
                if (this.description != null || force) {
                    Value<String> oldValue = this.description;
                    String val = this.resource().binding(PROP_DESCRIPTION).read();
                    this.description = new Value((IModelElement)this, PROP_DESCRIPTION, ((ValueNormalizationService)this.service((ModelProperty)PROP_DESCRIPTION, ValueNormalizationService.class)).normalize(PROP_DESCRIPTION.encodeKeywords(val)));
                    this.description.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DESCRIPTION);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_DESCRIPTION));
                    } else {
                        if (this.description.equals(oldValue)) {
                            this.description = oldValue;
                        } else {
                            if (!Component.equal((String)this.description.getText(false), (String)oldValue.getText(false)) || !Component.equal((String)this.description.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_DESCRIPTION));
                            }
                            if (!this.description.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_DESCRIPTION, oldValue.validation(), this.description.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_DESCRIPTION, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_NAME) {
                if (this.name != null || force) {
                    Value<String> oldValue = this.name;
                    String val = this.resource().binding(PROP_NAME).read();
                    this.name = new Value((IModelElement)this, PROP_NAME, ((ValueNormalizationService)this.service((ModelProperty)PROP_NAME, ValueNormalizationService.class)).normalize(PROP_NAME.encodeKeywords(val)));
                    this.name.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_NAME);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_NAME));
                    } else {
                        if (this.name.equals(oldValue)) {
                            this.name = oldValue;
                        } else {
                            if (!Component.equal((String)this.name.getText(false), (String)oldValue.getText(false)) || !Component.equal((String)this.name.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_NAME));
                            }
                            if (!this.name.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_NAME, oldValue.validation(), this.name.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_NAME, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_POSITION) {
                if (this.position == null) {
                    if (force) {
                        this.position = new ModelElementHandle((IModelElement)this, (ElementProperty)PROP_POSITION);
                        this.position.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_POSITION);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_POSITION));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_POSITION);
                    boolean notified = this.position.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_POSITION, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_PROVIDER && (this.provider != null || force)) {
                Value<String> oldValue = this.provider;
                String val = this.resource().binding(PROP_PROVIDER).read();
                this.provider = new Value((IModelElement)this, PROP_PROVIDER, ((ValueNormalizationService)this.service((ModelProperty)PROP_PROVIDER, ValueNormalizationService.class)).normalize(PROP_PROVIDER.encodeKeywords(val)));
                this.provider.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_PROVIDER);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_PROVIDER));
                } else {
                    if (this.provider.equals(oldValue)) {
                        this.provider = oldValue;
                    } else {
                        if (!Component.equal((String)this.provider.getText(false), (String)oldValue.getText(false)) || !Component.equal((String)this.provider.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_PROVIDER));
                        }
                        if (!this.provider.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_PROVIDER, oldValue.validation(), this.provider.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_PROVIDER, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_COPYRIGHT) {
            return this.getCopyright();
        }
        if (property == PROP_DEPENDENCIES) {
            return this.getDependencies();
        }
        if (property == PROP_DESCRIPTION) {
            return this.getDescription();
        }
        if (property == PROP_NAME) {
            return this.getName();
        }
        if (property == PROP_POSITION) {
            return this.getPosition();
        }
        if (property == PROP_PROVIDER) {
            return this.getProvider();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_COPYRIGHT) {
            this.setCopyright((String)value);
            return;
        }
        if (property == PROP_DESCRIPTION) {
            this.setDescription((String)value);
            return;
        }
        if (property == PROP_NAME) {
            this.setName((String)value);
            return;
        }
        if (property == PROP_PROVIDER) {
            this.setProvider((String)value);
            return;
        }
        super.write(property, value);
    }
}

