/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.calendar.IAttendee;
import org.eclipse.sapphire.samples.calendar.IEvent;
import org.eclipse.sapphire.samples.calendar.IEventAttachment;
import org.eclipse.sapphire.services.ValueNormalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Event
extends ModelElement
implements IEvent {
    private ModelElementList<IEventAttachment> attachments;
    private ModelElementList<IAttendee> attendees;
    private Value<String> endTime;
    private Value<String> location;
    private Value<String> notes;
    private Value<String> startTime;
    private Value<String> subject;

    public Event(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public Event(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IEventAttachment> getAttachments() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.attachments == null) {
                this.refresh((ModelProperty)PROP_ATTACHMENTS, true);
            }
            return this.attachments;
        }
    }

    protected void disposeProperties() {
        if (this.attachments != null) {
            for (IModelElement element : this.attachments) {
                element.dispose();
            }
        }
        if (this.attendees != null) {
            for (IModelElement element : this.attendees) {
                element.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IAttendee> getAttendees() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.attendees == null) {
                this.refresh((ModelProperty)PROP_ATTENDEES, true);
            }
            return this.attendees;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getEndTime() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.endTime == null) {
                this.refresh((ModelProperty)PROP_END_TIME, true);
            }
            return this.endTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndTime(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_END_TIME.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_END_TIME, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_END_TIME, true);
            if (!Event.equal((String)this.endTime.getText(false), (String)value)) {
                this.resource().binding(PROP_END_TIME).write(value);
                this.refresh((ModelProperty)PROP_END_TIME, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getLocation() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.location == null) {
                this.refresh((ModelProperty)PROP_LOCATION, true);
            }
            return this.location;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocation(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_LOCATION.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_LOCATION, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_LOCATION, true);
            if (!Event.equal((String)this.location.getText(false), (String)value)) {
                this.resource().binding(PROP_LOCATION).write(value);
                this.refresh((ModelProperty)PROP_LOCATION, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getNotes() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.notes == null) {
                this.refresh((ModelProperty)PROP_NOTES, true);
            }
            return this.notes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNotes(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_NOTES.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_NOTES, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_NOTES, true);
            if (!Event.equal((String)this.notes.getText(false), (String)value)) {
                this.resource().binding(PROP_NOTES).write(value);
                this.refresh((ModelProperty)PROP_NOTES, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getStartTime() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.startTime == null) {
                this.refresh((ModelProperty)PROP_START_TIME, true);
            }
            return this.startTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStartTime(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_START_TIME.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_START_TIME, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_START_TIME, true);
            if (!Event.equal((String)this.startTime.getText(false), (String)value)) {
                this.resource().binding(PROP_START_TIME).write(value);
                this.refresh((ModelProperty)PROP_START_TIME, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getSubject() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.subject == null) {
                this.refresh((ModelProperty)PROP_SUBJECT, true);
            }
            return this.subject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSubject(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_SUBJECT.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_SUBJECT, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_SUBJECT, true);
            if (!Event.equal((String)this.subject.getText(false), (String)value)) {
                this.resource().binding(PROP_SUBJECT).write(value);
                this.refresh((ModelProperty)PROP_SUBJECT, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ATTACHMENTS) {
                if (this.attachments == null) {
                    if (force) {
                        this.attachments = new ModelElementList((IModelElement)this, PROP_ATTACHMENTS);
                        ListBindingImpl binding = this.resource().binding(PROP_ATTACHMENTS);
                        this.attachments.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_ATTACHMENTS);
                        this.broadcast((org.eclipse.sapphire.Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_ATTACHMENTS));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ATTACHMENTS);
                    boolean notified = this.attachments.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((org.eclipse.sapphire.Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_ATTACHMENTS, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_ATTENDEES) {
                if (this.attendees == null) {
                    if (force) {
                        this.attendees = new ModelElementList((IModelElement)this, PROP_ATTENDEES);
                        ListBindingImpl binding = this.resource().binding(PROP_ATTENDEES);
                        this.attendees.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_ATTENDEES);
                        this.broadcast((org.eclipse.sapphire.Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_ATTENDEES));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ATTENDEES);
                    boolean notified = this.attendees.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((org.eclipse.sapphire.Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_ATTENDEES, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_END_TIME) {
                if (this.endTime != null || force) {
                    Value<String> oldValue = this.endTime;
                    String val = this.resource().binding(PROP_END_TIME).read();
                    this.endTime = new Value((IModelElement)this, PROP_END_TIME, ((ValueNormalizationService)this.service((ModelProperty)PROP_END_TIME, ValueNormalizationService.class)).normalize(PROP_END_TIME.encodeKeywords(val)));
                    this.endTime.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_END_TIME);
                    if (oldValue == null) {
                        this.broadcast((org.eclipse.sapphire.Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_END_TIME));
                    } else {
                        if (this.endTime.equals(oldValue)) {
                            this.endTime = oldValue;
                        } else {
                            if (!Event.equal((String)this.endTime.getText(false), (String)oldValue.getText(false)) || !Event.equal((String)this.endTime.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((org.eclipse.sapphire.Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_END_TIME));
                            }
                            if (!this.endTime.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((org.eclipse.sapphire.Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_END_TIME, oldValue.validation(), this.endTime.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((org.eclipse.sapphire.Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_END_TIME, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_LOCATION) {
                if (this.location != null || force) {
                    Value<String> oldValue = this.location;
                    String val = this.resource().binding(PROP_LOCATION).read();
                    this.location = new Value((IModelElement)this, PROP_LOCATION, ((ValueNormalizationService)this.service((ModelProperty)PROP_LOCATION, ValueNormalizationService.class)).normalize(PROP_LOCATION.encodeKeywords(val)));
                    this.location.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_LOCATION);
                    if (oldValue == null) {
                        this.broadcast((org.eclipse.sapphire.Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_LOCATION));
                    } else {
                        if (this.location.equals(oldValue)) {
                            this.location = oldValue;
                        } else {
                            if (!Event.equal((String)this.location.getText(false), (String)oldValue.getText(false)) || !Event.equal((String)this.location.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((org.eclipse.sapphire.Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_LOCATION));
                            }
                            if (!this.location.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((org.eclipse.sapphire.Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_LOCATION, oldValue.validation(), this.location.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((org.eclipse.sapphire.Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_LOCATION, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_NOTES) {
                if (this.notes != null || force) {
                    Value<String> oldValue = this.notes;
                    String val = this.resource().binding(PROP_NOTES).read();
                    this.notes = new Value((IModelElement)this, PROP_NOTES, ((ValueNormalizationService)this.service((ModelProperty)PROP_NOTES, ValueNormalizationService.class)).normalize(PROP_NOTES.encodeKeywords(val)));
                    this.notes.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_NOTES);
                    if (oldValue == null) {
                        this.broadcast((org.eclipse.sapphire.Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_NOTES));
                    } else {
                        if (this.notes.equals(oldValue)) {
                            this.notes = oldValue;
                        } else {
                            if (!Event.equal((String)this.notes.getText(false), (String)oldValue.getText(false)) || !Event.equal((String)this.notes.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((org.eclipse.sapphire.Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_NOTES));
                            }
                            if (!this.notes.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((org.eclipse.sapphire.Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_NOTES, oldValue.validation(), this.notes.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((org.eclipse.sapphire.Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_NOTES, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_START_TIME) {
                if (this.startTime != null || force) {
                    Value<String> oldValue = this.startTime;
                    String val = this.resource().binding(PROP_START_TIME).read();
                    this.startTime = new Value((IModelElement)this, PROP_START_TIME, ((ValueNormalizationService)this.service((ModelProperty)PROP_START_TIME, ValueNormalizationService.class)).normalize(PROP_START_TIME.encodeKeywords(val)));
                    this.startTime.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_START_TIME);
                    if (oldValue == null) {
                        this.broadcast((org.eclipse.sapphire.Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_START_TIME));
                    } else {
                        if (this.startTime.equals(oldValue)) {
                            this.startTime = oldValue;
                        } else {
                            if (!Event.equal((String)this.startTime.getText(false), (String)oldValue.getText(false)) || !Event.equal((String)this.startTime.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((org.eclipse.sapphire.Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_START_TIME));
                            }
                            if (!this.startTime.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((org.eclipse.sapphire.Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_START_TIME, oldValue.validation(), this.startTime.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((org.eclipse.sapphire.Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_START_TIME, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_SUBJECT && (this.subject != null || force)) {
                Value<String> oldValue = this.subject;
                String val = this.resource().binding(PROP_SUBJECT).read();
                this.subject = new Value((IModelElement)this, PROP_SUBJECT, ((ValueNormalizationService)this.service((ModelProperty)PROP_SUBJECT, ValueNormalizationService.class)).normalize(PROP_SUBJECT.encodeKeywords(val)));
                this.subject.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_SUBJECT);
                if (oldValue == null) {
                    this.broadcast((org.eclipse.sapphire.Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_SUBJECT));
                } else {
                    if (this.subject.equals(oldValue)) {
                        this.subject = oldValue;
                    } else {
                        if (!Event.equal((String)this.subject.getText(false), (String)oldValue.getText(false)) || !Event.equal((String)this.subject.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((org.eclipse.sapphire.Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_SUBJECT));
                        }
                        if (!this.subject.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((org.eclipse.sapphire.Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_SUBJECT, oldValue.validation(), this.subject.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((org.eclipse.sapphire.Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_SUBJECT, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_ATTACHMENTS) {
            return this.getAttachments();
        }
        if (property == PROP_ATTENDEES) {
            return this.getAttendees();
        }
        if (property == PROP_END_TIME) {
            return this.getEndTime();
        }
        if (property == PROP_LOCATION) {
            return this.getLocation();
        }
        if (property == PROP_NOTES) {
            return this.getNotes();
        }
        if (property == PROP_START_TIME) {
            return this.getStartTime();
        }
        if (property == PROP_SUBJECT) {
            return this.getSubject();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_END_TIME) {
            this.setEndTime((String)value);
            return;
        }
        if (property == PROP_LOCATION) {
            this.setLocation((String)value);
            return;
        }
        if (property == PROP_NOTES) {
            this.setNotes((String)value);
            return;
        }
        if (property == PROP_START_TIME) {
            this.setStartTime((String)value);
            return;
        }
        if (property == PROP_SUBJECT) {
            this.setSubject((String)value);
            return;
        }
        super.write(property, value);
    }
}

