/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.gallery.IChildElement;
import org.eclipse.sapphire.services.ValueNormalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChildElement
extends ModelElement
implements IChildElement {
    private Value<String> stringValue;

    public ChildElement(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public ChildElement(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getStringValue() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.stringValue == null) {
                this.refresh((ModelProperty)PROP_STRING_VALUE, true);
            }
            return this.stringValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringValue(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_STRING_VALUE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_STRING_VALUE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_STRING_VALUE, true);
            if (!ChildElement.equal((String)this.stringValue.getText(false), (String)value)) {
                this.resource().binding(PROP_STRING_VALUE).write(value);
                this.refresh((ModelProperty)PROP_STRING_VALUE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_STRING_VALUE && (this.stringValue != null || force)) {
                Value<String> oldValue = this.stringValue;
                String val = this.resource().binding(PROP_STRING_VALUE).read();
                this.stringValue = new Value((IModelElement)this, PROP_STRING_VALUE, ((ValueNormalizationService)this.service((ModelProperty)PROP_STRING_VALUE, ValueNormalizationService.class)).normalize(PROP_STRING_VALUE.encodeKeywords(val)));
                this.stringValue.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_STRING_VALUE);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_STRING_VALUE));
                } else {
                    if (this.stringValue.equals(oldValue)) {
                        this.stringValue = oldValue;
                    } else {
                        if (!ChildElement.equal((String)this.stringValue.getText(false), (String)oldValue.getText(false)) || !ChildElement.equal((String)this.stringValue.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_STRING_VALUE));
                        }
                        if (!this.stringValue.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_STRING_VALUE, oldValue.validation(), this.stringValue.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_STRING_VALUE, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_STRING_VALUE) {
            return this.getStringValue();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_STRING_VALUE) {
            this.setStringValue((String)value);
            return;
        }
        super.write(property, value);
    }
}

