/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.architecture.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.architecture.IArchitecture;
import org.eclipse.sapphire.samples.architecture.IComponent;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.services.ValueSerializationMasterService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Architecture
extends ModelElement
implements IArchitecture {
    private ModelElementList<IComponent> components;
    private Value<String> description;
    private Value<Integer> detailLevel;
    private Value<Boolean> showGrid;
    private Value<Boolean> showGuides;

    public Architecture(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public Architecture(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IComponent> getComponents() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.components == null) {
                this.refresh((ModelProperty)PROP_COMPONENTS, true);
            }
            return this.components;
        }
    }

    protected void disposeProperties() {
        if (this.components != null) {
            for (IModelElement element : this.components) {
                element.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getDescription() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.description == null) {
                this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            }
            return this.description;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_DESCRIPTION.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_DESCRIPTION, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            if (!Architecture.equal((String)this.description.getText(false), (String)value)) {
                this.resource().binding(PROP_DESCRIPTION).write(value);
                this.refresh((ModelProperty)PROP_DESCRIPTION, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Integer> getDetailLevel() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.detailLevel == null) {
                this.refresh((ModelProperty)PROP_DETAIL_LEVEL, true);
            }
            return this.detailLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDetailLevel(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_DETAIL_LEVEL.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_DETAIL_LEVEL, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_DETAIL_LEVEL, true);
            if (!Architecture.equal((String)this.detailLevel.getText(false), (String)value)) {
                this.resource().binding(PROP_DETAIL_LEVEL).write(value);
                this.refresh((ModelProperty)PROP_DETAIL_LEVEL, false);
            }
        }
    }

    @Override
    public void setDetailLevel(Integer value) {
        this.setDetailLevel(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_DETAIL_LEVEL, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Boolean> isShowGrid() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.showGrid == null) {
                this.refresh((ModelProperty)PROP_SHOW_GRID, true);
            }
            return this.showGrid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShowGrid(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_SHOW_GRID.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_SHOW_GRID, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_SHOW_GRID, true);
            if (!Architecture.equal((String)this.showGrid.getText(false), (String)value)) {
                this.resource().binding(PROP_SHOW_GRID).write(value);
                this.refresh((ModelProperty)PROP_SHOW_GRID, false);
            }
        }
    }

    @Override
    public void setShowGrid(Boolean value) {
        this.setShowGrid(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_SHOW_GRID, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Boolean> isShowGuides() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.showGuides == null) {
                this.refresh((ModelProperty)PROP_SHOW_GUIDES, true);
            }
            return this.showGuides;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShowGuides(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_SHOW_GUIDES.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_SHOW_GUIDES, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_SHOW_GUIDES, true);
            if (!Architecture.equal((String)this.showGuides.getText(false), (String)value)) {
                this.resource().binding(PROP_SHOW_GUIDES).write(value);
                this.refresh((ModelProperty)PROP_SHOW_GUIDES, false);
            }
        }
    }

    @Override
    public void setShowGuides(Boolean value) {
        this.setShowGuides(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_SHOW_GUIDES, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_COMPONENTS) {
                if (this.components == null) {
                    if (force) {
                        this.components = new ModelElementList((IModelElement)this, PROP_COMPONENTS);
                        ListBindingImpl binding = this.resource().binding(PROP_COMPONENTS);
                        this.components.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_COMPONENTS);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_COMPONENTS));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_COMPONENTS);
                    boolean notified = this.components.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_COMPONENTS, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_DESCRIPTION) {
                if (this.description != null || force) {
                    Value<String> oldValue = this.description;
                    String val = this.resource().binding(PROP_DESCRIPTION).read();
                    this.description = new Value((IModelElement)this, PROP_DESCRIPTION, ((ValueNormalizationService)this.service((ModelProperty)PROP_DESCRIPTION, ValueNormalizationService.class)).normalize(PROP_DESCRIPTION.encodeKeywords(val)));
                    this.description.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DESCRIPTION);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_DESCRIPTION));
                    } else {
                        if (this.description.equals(oldValue)) {
                            this.description = oldValue;
                        } else {
                            if (!Architecture.equal((String)this.description.getText(false), (String)oldValue.getText(false)) || !Architecture.equal((String)this.description.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_DESCRIPTION));
                            }
                            if (!this.description.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_DESCRIPTION, oldValue.validation(), this.description.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_DESCRIPTION, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_DETAIL_LEVEL) {
                if (this.detailLevel != null || force) {
                    Value<Integer> oldValue = this.detailLevel;
                    String val = this.resource().binding(PROP_DETAIL_LEVEL).read();
                    this.detailLevel = new Value((IModelElement)this, PROP_DETAIL_LEVEL, ((ValueNormalizationService)this.service((ModelProperty)PROP_DETAIL_LEVEL, ValueNormalizationService.class)).normalize(PROP_DETAIL_LEVEL.encodeKeywords(val)));
                    this.detailLevel.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DETAIL_LEVEL);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_DETAIL_LEVEL));
                    } else {
                        if (this.detailLevel.equals(oldValue)) {
                            this.detailLevel = oldValue;
                        } else {
                            if (!Architecture.equal((String)this.detailLevel.getText(false), (String)oldValue.getText(false)) || !Architecture.equal((String)this.detailLevel.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_DETAIL_LEVEL));
                            }
                            if (!this.detailLevel.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_DETAIL_LEVEL, oldValue.validation(), this.detailLevel.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_DETAIL_LEVEL, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_SHOW_GRID) {
                if (this.showGrid != null || force) {
                    Value<Boolean> oldValue = this.showGrid;
                    String val = this.resource().binding(PROP_SHOW_GRID).read();
                    this.showGrid = new Value((IModelElement)this, PROP_SHOW_GRID, ((ValueNormalizationService)this.service((ModelProperty)PROP_SHOW_GRID, ValueNormalizationService.class)).normalize(PROP_SHOW_GRID.encodeKeywords(val)));
                    this.showGrid.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_SHOW_GRID);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_SHOW_GRID));
                    } else {
                        if (this.showGrid.equals(oldValue)) {
                            this.showGrid = oldValue;
                        } else {
                            if (!Architecture.equal((String)this.showGrid.getText(false), (String)oldValue.getText(false)) || !Architecture.equal((String)this.showGrid.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_SHOW_GRID));
                            }
                            if (!this.showGrid.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_SHOW_GRID, oldValue.validation(), this.showGrid.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_SHOW_GRID, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_SHOW_GUIDES && (this.showGuides != null || force)) {
                Value<Boolean> oldValue = this.showGuides;
                String val = this.resource().binding(PROP_SHOW_GUIDES).read();
                this.showGuides = new Value((IModelElement)this, PROP_SHOW_GUIDES, ((ValueNormalizationService)this.service((ModelProperty)PROP_SHOW_GUIDES, ValueNormalizationService.class)).normalize(PROP_SHOW_GUIDES.encodeKeywords(val)));
                this.showGuides.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_SHOW_GUIDES);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_SHOW_GUIDES));
                } else {
                    if (this.showGuides.equals(oldValue)) {
                        this.showGuides = oldValue;
                    } else {
                        if (!Architecture.equal((String)this.showGuides.getText(false), (String)oldValue.getText(false)) || !Architecture.equal((String)this.showGuides.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_SHOW_GUIDES));
                        }
                        if (!this.showGuides.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_SHOW_GUIDES, oldValue.validation(), this.showGuides.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_SHOW_GUIDES, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_COMPONENTS) {
            return this.getComponents();
        }
        if (property == PROP_DESCRIPTION) {
            return this.getDescription();
        }
        if (property == PROP_DETAIL_LEVEL) {
            return this.getDetailLevel();
        }
        if (property == PROP_SHOW_GRID) {
            return this.isShowGrid();
        }
        if (property == PROP_SHOW_GUIDES) {
            return this.isShowGuides();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_DESCRIPTION) {
            this.setDescription((String)value);
            return;
        }
        if (property == PROP_DETAIL_LEVEL) {
            if (!(value instanceof String)) {
                this.setDetailLevel((Integer)value);
            } else {
                this.setDetailLevel((String)value);
            }
            return;
        }
        if (property == PROP_SHOW_GRID) {
            if (!(value instanceof String)) {
                this.setShowGrid((Boolean)value);
            } else {
                this.setShowGrid((String)value);
            }
            return;
        }
        if (property == PROP_SHOW_GUIDES) {
            if (!(value instanceof String)) {
                this.setShowGuides((Boolean)value);
            } else {
                this.setShowGuides((String)value);
            }
            return;
        }
        super.write(property, value);
    }
}

