/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.gallery.ActuatorsGallery;
import org.eclipse.sapphire.samples.gallery.IValuePropertyActionsGallery;
import org.eclipse.sapphire.samples.gallery.IValuePropertyActionsGalleryEntity;
import org.eclipse.sapphire.samples.gallery.IValuePropertyActionsGalleryReference;
import org.eclipse.sapphire.services.ValueNormalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValuePropertyActionsGallery
extends ModelElement
implements IValuePropertyActionsGallery {
    private ModelElementHandle<ActuatorsGallery> actuators;
    private ModelElementList<IValuePropertyActionsGalleryEntity> entities;
    private Value<String> reference;
    private ModelElementList<IValuePropertyActionsGalleryReference> references;

    public ValuePropertyActionsGallery(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public ValuePropertyActionsGallery(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActuatorsGallery getActuators() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.actuators == null) {
                this.refresh((ModelProperty)PROP_ACTUATORS, true);
            }
            return (ActuatorsGallery)this.actuators.element();
        }
    }

    protected void disposeProperties() {
        IModelElement element2;
        if (this.actuators != null && (element2 = this.actuators.element(false)) != null) {
            element2.dispose();
        }
        if (this.entities != null) {
            for (IModelElement element2 : this.entities) {
                element2.dispose();
            }
        }
        if (this.references != null) {
            for (IModelElement element2 : this.references) {
                element2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IValuePropertyActionsGalleryEntity> getEntities() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.entities == null) {
                this.refresh((ModelProperty)PROP_ENTITIES, true);
            }
            return this.entities;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getReference() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.reference == null) {
                this.refresh((ModelProperty)PROP_REFERENCE, true);
            }
            return this.reference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReference(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_REFERENCE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_REFERENCE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_REFERENCE, true);
            if (!ValuePropertyActionsGallery.equal((String)this.reference.getText(false), (String)value)) {
                this.resource().binding(PROP_REFERENCE).write(value);
                this.refresh((ModelProperty)PROP_REFERENCE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IValuePropertyActionsGalleryReference> getReferences() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.references == null) {
                this.refresh((ModelProperty)PROP_REFERENCES, true);
            }
            return this.references;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ACTUATORS) {
                if (this.actuators == null) {
                    if (force) {
                        this.actuators = new ModelElementHandle((IModelElement)this, (ElementProperty)PROP_ACTUATORS);
                        this.actuators.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_ACTUATORS);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_ACTUATORS));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ACTUATORS);
                    boolean notified = this.actuators.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_ACTUATORS, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_ENTITIES) {
                if (this.entities == null) {
                    if (force) {
                        this.entities = new ModelElementList((IModelElement)this, PROP_ENTITIES);
                        ListBindingImpl binding = this.resource().binding(PROP_ENTITIES);
                        this.entities.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_ENTITIES);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_ENTITIES));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ENTITIES);
                    boolean notified = this.entities.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_ENTITIES, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_REFERENCE) {
                if (this.reference != null || force) {
                    Value<String> oldValue = this.reference;
                    String val = this.resource().binding(PROP_REFERENCE).read();
                    this.reference = new Value((IModelElement)this, PROP_REFERENCE, ((ValueNormalizationService)this.service((ModelProperty)PROP_REFERENCE, ValueNormalizationService.class)).normalize(PROP_REFERENCE.encodeKeywords(val)));
                    this.reference.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_REFERENCE);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_REFERENCE));
                    } else {
                        if (this.reference.equals(oldValue)) {
                            this.reference = oldValue;
                        } else {
                            if (!ValuePropertyActionsGallery.equal((String)this.reference.getText(false), (String)oldValue.getText(false)) || !ValuePropertyActionsGallery.equal((String)this.reference.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_REFERENCE));
                            }
                            if (!this.reference.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_REFERENCE, oldValue.validation(), this.reference.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_REFERENCE, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_REFERENCES) {
                if (this.references == null) {
                    if (force) {
                        this.references = new ModelElementList((IModelElement)this, PROP_REFERENCES);
                        ListBindingImpl binding = this.resource().binding(PROP_REFERENCES);
                        this.references.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_REFERENCES);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_REFERENCES));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_REFERENCES);
                    boolean notified = this.references.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_REFERENCES, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_ACTUATORS) {
            return this.getActuators();
        }
        if (property == PROP_ENTITIES) {
            return this.getEntities();
        }
        if (property == PROP_REFERENCE) {
            return this.getReference();
        }
        if (property == PROP_REFERENCES) {
            return this.getReferences();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_REFERENCE) {
            this.setReference((String)value);
            return;
        }
        super.write(property, value);
    }
}

