/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer.actions;

import java.io.File;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireBrowseActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.swt.widgets.DirectoryDialog;

public class AbsoluteFolderPathBrowseActionHandler
extends SapphireBrowseActionHandler {
    public static final String ID = "Sapphire.Browse.Folder.Absolute";

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.setId(ID);
        this.setLabel(Resources.label);
        this.addImage(ImageData.createFromClassLoader(this.getClass(), (String)"Folder.png"));
    }

    protected String browse(SapphireRenderingContext context) {
        ValueProperty property = this.getProperty();
        DirectoryDialog dialog = new DirectoryDialog(context.getShell());
        dialog.setText(property.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false));
        dialog.setMessage(this.createBrowseDialogMessage(property.getLabel(true, CapitalizationType.NO_CAPS, false)));
        Value value = this.getModelElement().read(property);
        Path path = (Path)value.getContent();
        if (path != null) {
            File f = new File(path.toOSString());
            while (f != null && !f.exists()) {
                f = f.getParentFile();
            }
            if (f != null) {
                dialog.setFilterPath(f.getAbsolutePath());
            }
        }
        return dialog.open();
    }

    private static final class Resources
    extends NLS {
        public static String label;

        static {
            Resources.initializeMessages((String)AbsoluteFolderPathBrowseActionHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

