/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.ui.def.IDefinitionReference;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.internal.DefinitionReferenceMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefinitionReference
extends ModelElement
implements IDefinitionReference {
    private Value<String> path;

    public DefinitionReference(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public DefinitionReference(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getPath() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.path == null) {
                this.refresh((ModelProperty)PROP_PATH, true);
            }
            return this.path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPath(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_PATH.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_PATH, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_PATH, true);
            if (!DefinitionReference.equal((String)this.path.getText(false), (String)value)) {
                this.resource().binding(PROP_PATH).write(value);
                this.refresh((ModelProperty)PROP_PATH, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISapphireUiDef resolve() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            return DefinitionReferenceMethods.resolve(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_PATH && (this.path != null || force)) {
                Value<String> oldValue = this.path;
                String val = this.resource().binding(PROP_PATH).read();
                this.path = new Value((IModelElement)this, PROP_PATH, ((ValueNormalizationService)this.service((ModelProperty)PROP_PATH, ValueNormalizationService.class)).normalize(PROP_PATH.encodeKeywords(val)));
                this.path.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_PATH);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_PATH));
                } else {
                    if (this.path.equals(oldValue)) {
                        this.path = oldValue;
                    } else {
                        if (!DefinitionReference.equal((String)this.path.getText(false), (String)oldValue.getText(false)) || !DefinitionReference.equal((String)this.path.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_PATH));
                        }
                        if (!this.path.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_PATH, oldValue.validation(), this.path.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_PATH, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_PATH) {
            return this.getPath();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_PATH) {
            this.setPath((String)value);
            return;
        }
        super.write(property, value);
    }
}

