/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.ui.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentOutline;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.IMasterDetailsEditorPageDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.state.MasterDetailsEditorPageState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterDetailsEditorPagePart
extends SapphireEditorPagePart {
    private MasterDetailsEditorPageState state;
    private MasterDetailsContentOutline contentOutline;

    @Override
    protected void init() {
        super.init();
        try {
            File stateFile = this.adapt(SapphireEditor.class).getDefaultStateStorageFile(this);
            this.state = (MasterDetailsEditorPageState)MasterDetailsEditorPageState.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore(stateFile)));
        }
        catch (ResourceStoreException resourceStoreException) {
            this.state = (MasterDetailsEditorPageState)MasterDetailsEditorPageState.TYPE.instantiate();
        }
        this.contentOutline = new MasterDetailsContentOutline(this);
        this.contentOutline.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof MasterDetailsContentOutline.SelectionChangedEvent) {
                    MasterDetailsContentOutline.SelectionChangedEvent evt = (MasterDetailsContentOutline.SelectionChangedEvent)event;
                    List<MasterDetailsContentNode> selection = evt.selection();
                    PropertiesViewContributionPart propertiesViewContribution = null;
                    if (selection.size() == 1) {
                        propertiesViewContribution = selection.get(0).getPropertiesViewContribution();
                    }
                    MasterDetailsEditorPagePart.this.setPropertiesViewContribution(propertiesViewContribution);
                }
            }
        });
    }

    @Override
    public IMasterDetailsEditorPageDef definition() {
        return (IMasterDetailsEditorPageDef)super.definition();
    }

    @Override
    public Set<String> getActionContexts() {
        HashSet<String> contexts = new HashSet<String>();
        contexts.addAll(super.getActionContexts());
        contexts.add("Sapphire.EditorPage.Outline.Header");
        return contexts;
    }

    @Override
    public String getMainActionContext() {
        return "Sapphire.EditorPage";
    }

    public final MasterDetailsContentOutline outline() {
        return this.contentOutline;
    }

    public final void expandAllNodes() {
        for (MasterDetailsContentNode node : this.contentOutline.getRoot().getChildNodes()) {
            node.setExpanded(true, true);
        }
    }

    public final void collapseAllNodes() {
        for (MasterDetailsContentNode node : this.contentOutline.getRoot().getChildNodes()) {
            node.setExpanded(false, true);
        }
    }

    public final MasterDetailsEditorPageState getState() {
        return this.state;
    }

    public final void setFocusOnDetails() {
        this.broadcast(new DetailsFocusRequested(this));
    }

    public static final class DetailsFocusRequested
    extends SapphirePart.PartEvent {
        public DetailsFocusRequested(MasterDetailsEditorPagePart part) {
            super(part);
        }
    }
}

