/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.internal;

import java.util.SortedSet;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.ValueLabelService;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.ui.renderers.swt.DefaultListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.swt.internal.PopUpListFieldStyle;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public final class PopUpListFieldCellEditorPresentation
extends ComboBoxCellEditor {
    private final StructuredViewer viewer;
    private final DefaultListPropertyEditorRenderer.SelectionProvider selectionProvider;
    private final IModelElement element;
    private final ValueProperty property;
    private String[] possibleValues;
    private boolean isDefaultValue;
    private CCombo combo;
    private boolean disableFocusLostHandler;
    private ISelection selectionPriorToActivation;

    public PopUpListFieldCellEditorPresentation(StructuredViewer parent, DefaultListPropertyEditorRenderer.SelectionProvider selectionProvider, IModelElement element, ValueProperty property, PopUpListFieldStyle popUpListFieldStyle, int style) {
        this.viewer = parent;
        this.selectionProvider = selectionProvider;
        this.element = element;
        this.property = property;
        this.setStyle(style | (popUpListFieldStyle == PopUpListFieldStyle.STRICT ? 8 : 0));
        this.create((Composite)parent.getControl());
        this.combo = (CCombo)this.getControl();
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PopUpListFieldCellEditorPresentation.this.isDefaultValue = false;
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PopUpListFieldCellEditorPresentation.this.isDefaultValue = false;
            }
        });
        PossibleValuesService possibleValuesService = (PossibleValuesService)element.service((ModelProperty)property, PossibleValuesService.class);
        ValueLabelService valueLabelService = (ValueLabelService)element.service((ModelProperty)property, ValueLabelService.class);
        ValueNormalizationService valueNormalizationService = (ValueNormalizationService)element.service((ModelProperty)property, ValueNormalizationService.class);
        SortedSet possibleValuesFromService = possibleValuesService.values();
        this.possibleValues = new String[possibleValuesFromService.size()];
        String[] contentForCombo = new String[this.possibleValues.length];
        int i = 0;
        for (String possibleValue : possibleValuesFromService) {
            String normalizedPossibleValue;
            this.possibleValues[i] = normalizedPossibleValue = valueNormalizationService.normalize(possibleValue);
            contentForCombo[i] = valueLabelService.provide(normalizedPossibleValue);
            ++i;
        }
        this.setItems(contentForCombo);
    }

    protected Object doGetValue() {
        if (this.isDefaultValue) {
            return null;
        }
        int index = this.combo.getSelectionIndex();
        if (index == -1) {
            ValueNormalizationService valueNormalizationService = (ValueNormalizationService)this.element.service((ModelProperty)this.property, ValueNormalizationService.class);
            String value = valueNormalizationService.normalize(this.combo.getText());
            if (value.length() > 0) {
                return value;
            }
            return null;
        }
        return this.possibleValues[index];
    }

    protected void doSetValue(Object value) {
        Value val = (Value)value;
        ValueNormalizationService valueNormalizationService = (ValueNormalizationService)this.element.service((ModelProperty)this.property, ValueNormalizationService.class);
        String text = valueNormalizationService.normalize(val.getText());
        int index = -1;
        int i = 0;
        while (index == -1 && i < this.possibleValues.length) {
            if (this.possibleValues[i].equals(text)) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            if (text != null) {
                this.combo.setText(text);
            }
        } else {
            this.combo.select(index);
        }
        this.isDefaultValue = val.getText(false) == null && val.getDefaultContent() != null;
    }

    public void activate() {
        this.selectionPriorToActivation = this.viewer.getSelection();
        if (this.selectionProvider != null) {
            this.selectionProvider.setFakeSelection(this.selectionPriorToActivation);
        }
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        super.activate();
    }

    protected void focusLost() {
        if (!this.disableFocusLostHandler) {
            this.disableFocusLostHandler = true;
            super.focusLost();
            this.disableFocusLostHandler = false;
            this.viewer.setSelection(this.selectionPriorToActivation);
            if (this.selectionProvider != null) {
                this.selectionProvider.setFakeSelection(null);
            }
            this.selectionPriorToActivation = null;
        }
    }
}

