/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.ValueLabelService;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.ui.PropertyEditorPart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.renderers.swt.ValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.swt.internal.PopUpListFieldStyle;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class PopUpListFieldPropertyEditorPresentation
extends ValuePropertyEditorRenderer {
    private final PopUpListFieldStyle style;
    private Combo combo;

    public PopUpListFieldPropertyEditorPresentation(SapphireRenderingContext context, PropertyEditorPart part, PopUpListFieldStyle style) {
        super(context, part);
        if (style == null) {
            throw new IllegalArgumentException();
        }
        this.style = style;
    }

    protected void createContents(Composite parent) {
        PropertyEditorPart part = this.getPart();
        final IModelElement element = part.getLocalModelElement();
        final ValueProperty property = (ValueProperty)part.getProperty();
        Composite composite = this.createMainComposite(parent);
        composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
        PropertyEditorAssistDecorator decorator = this.createDecorator(composite);
        decorator.addEditorControl((Control)composite);
        decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
        final Combo combo = new Combo(composite, 0x804 | (this.style == PopUpListFieldStyle.STRICT ? 8 : 0));
        combo.setLayoutData((Object)GridLayoutUtil.gdhfill());
        combo.setVisibleItemCount(10);
        decorator.addEditorControl((Control)combo, true);
        this.addControl((Control)combo);
        this.context.adapt((Control)combo);
        this.combo = combo;
        final PossibleValuesService possibleValuesService = (PossibleValuesService)element.service((ModelProperty)property, PossibleValuesService.class);
        final ValueLabelService valueLabelService = (ValueLabelService)element.service((ModelProperty)property, ValueLabelService.class);
        final ValueNormalizationService valueNormalizationService = (ValueNormalizationService)element.service((ModelProperty)property, ValueNormalizationService.class);
        final MutableReference possibleValuesRef = new MutableReference();
        final Runnable updateComboSelectionOp = new Runnable(){

            public void run() {
                String value = valueNormalizationService.normalize(element.read(property).getText());
                if (value == null) {
                    combo.deselectAll();
                    combo.setText("");
                } else if (PopUpListFieldPropertyEditorPresentation.this.style == PopUpListFieldStyle.STRICT) {
                    String[] possibleValues = (String[])possibleValuesRef.get();
                    int possibleValueIndex = -1;
                    int i = 0;
                    while (i < possibleValues.length && possibleValueIndex == -1) {
                        if (MiscUtil.equal((Object)possibleValues[i], (Object)value)) {
                            possibleValueIndex = i;
                        }
                        ++i;
                    }
                    if (possibleValueIndex == -1) {
                        if (possibleValues.length == combo.getItemCount()) {
                            combo.add(value);
                        } else {
                            String existingNonConformingValue = combo.getItem(possibleValues.length);
                            if (!existingNonConformingValue.equals(value)) {
                                combo.setItem(possibleValues.length, value);
                            }
                        }
                        possibleValueIndex = possibleValues.length;
                    } else if (possibleValues.length < combo.getItemCount()) {
                        combo.remove(possibleValues.length);
                    }
                    if (combo.getSelectionIndex() != possibleValueIndex) {
                        combo.select(possibleValueIndex);
                    }
                } else if (!MiscUtil.equal((Object)valueNormalizationService.normalize(combo.getText()), (Object)value)) {
                    combo.setText(value);
                }
            }
        };
        final Runnable updateComboContentOp = new Runnable(){

            public void run() {
                SortedSet possibleValues = possibleValuesService.values();
                String[] possibleValuesArray = new String[possibleValues.size()];
                String[] contentForCombo = new String[possibleValuesArray.length];
                int i = 0;
                for (String possibleValue : possibleValues) {
                    String normalizedPossibleValue;
                    possibleValuesArray[i] = normalizedPossibleValue = valueNormalizationService.normalize(possibleValue);
                    contentForCombo[i] = valueLabelService.provide(normalizedPossibleValue);
                    ++i;
                }
                combo.setItems(contentForCombo);
                possibleValuesRef.set((Object)possibleValuesArray);
                updateComboSelectionOp.run();
            }
        };
        updateComboContentOp.run();
        final Listener possibleValuesServiceListener = new Listener(){

            public void handle(Event event) {
                updateComboContentOp.run();
            }
        };
        possibleValuesService.attach(possibleValuesServiceListener);
        FilteredListener<PropertyContentEvent> propertyListener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                updateComboSelectionOp.run();
            }
        };
        element.attach((Listener)propertyListener, property.getName());
        final Runnable updateModelOp = new Runnable(){

            public void run() {
                element.write(property, (Object)combo.getText());
            }
        };
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                updateModelOp.run();
            }
        });
        this.addOnDisposeOperation(new Runnable((Listener)propertyListener, property){
            private final /* synthetic */ Listener val$propertyListener;
            private final /* synthetic */ ValueProperty val$property;
            {
                this.val$propertyListener = listener2;
                this.val$property = valueProperty;
            }

            public void run() {
                possibleValuesService.detach(possibleValuesServiceListener);
                element.detach(this.val$propertyListener, this.val$property.getName());
            }
        });
    }

    protected void handleFocusReceivedEvent() {
        this.combo.setFocus();
    }
}

