/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.commands;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;

public class CreateConnectionCommand
extends Command {
    private SapphireDiagramEditorPagePart diagramPart;
    private IDiagramConnectionDef connDef;
    private final DiagramNodeModel source;
    private DiagramNodeModel target;

    public CreateConnectionCommand(DiagramNodeModel source, IDiagramConnectionDef connDef) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("connection creation");
        this.source = source;
        this.connDef = connDef;
        this.diagramPart = (SapphireDiagramEditorPagePart)source.getModelPart().nearest(SapphireDiagramEditorPagePart.class);
    }

    public boolean canExecute() {
        return this.target != null && !this.source.equals(this.target);
    }

    public void execute() {
        DiagramConnectionTemplate connectionTemplate = this.getConnectionTemplate(this.source);
        DiagramConnectionPart connection = connectionTemplate.createNewDiagramConnection(this.source.getModelPart(), this.target.getModelPart());
        if (connection.canEditLabel()) {
            this.diagramPart.selectAndDirectEdit((ISapphirePart)connection);
        }
    }

    public void setTarget(DiagramNodeModel target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.target = target;
    }

    private DiagramConnectionTemplate getConnectionTemplate(DiagramNodeModel srcNode) {
        DiagramEmbeddedConnectionTemplate embeddedConn = srcNode.getModelPart().getDiagramNodeTemplate().getEmbeddedConnectionTemplate();
        if (embeddedConn != null && embeddedConn.getConnectionId().equalsIgnoreCase((String)this.connDef.getId().getContent())) {
            return embeddedConn;
        }
        List connTemplates = this.diagramPart.getConnectionTemplates();
        for (DiagramConnectionTemplate connTemplate : connTemplates) {
            if (!connTemplate.getConnectionId().equalsIgnoreCase((String)this.connDef.getId().getContent())) continue;
            return connTemplate;
        }
        return null;
    }
}

