/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PossibleValuesService
extends Service {
    public final SortedSet<String> values() {
        TreeSet<String> values = new TreeSet<String>();
        this.fillPossibleValues(values);
        return Collections.unmodifiableSortedSet(values);
    }

    protected abstract void fillPossibleValues(SortedSet<String> var1);

    public String getInvalidValueMessage(String invalidValue) {
        return NLS.bind(Resources.defaultInvalidValueMessage, invalidValue, this.context(ModelProperty.class).getLabel(true, CapitalizationType.NO_CAPS, false));
    }

    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return Status.Severity.ERROR;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    private static final class Resources
    extends NLS {
        public static String defaultInvalidValueMessage;

        static {
            Resources.initializeMessages(PossibleValuesService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

