/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReadOnlyListFactory<E> {
    private E firstElement = null;
    private ArrayList<E> list = null;
    private boolean exported = false;

    private ReadOnlyListFactory() {
    }

    public static <E> ReadOnlyListFactory<E> create() {
        return new ReadOnlyListFactory<E>();
    }

    public static <E> List<E> create(E element) {
        return Collections.singletonList(element);
    }

    public static <E> List<E> create(E ... elements) {
        return ReadOnlyListFactory.create().add(elements).export();
    }

    public static <E> List<E> create(Collection<E> elements) {
        return ReadOnlyListFactory.create().add(elements).export();
    }

    public ReadOnlyListFactory<E> add(E element) {
        if (this.exported) {
            throw new IllegalStateException();
        }
        if (this.list != null) {
            this.list.add(element);
        } else if (this.firstElement != null) {
            this.list = new ArrayList();
            this.list.add(this.firstElement);
            this.list.add(element);
            this.firstElement = null;
        } else {
            this.firstElement = element;
        }
        return this;
    }

    public ReadOnlyListFactory<E> add(E ... elements) {
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            this.add(element);
            ++n2;
        }
        return this;
    }

    public ReadOnlyListFactory<E> add(Collection<E> elements) {
        for (E element : elements) {
            this.add(element);
        }
        return this;
    }

    public List<E> export() {
        if (this.exported) {
            throw new IllegalStateException();
        }
        this.exported = true;
        if (this.list != null) {
            this.list.trimToSize();
            return Collections.unmodifiableList(this.list);
        }
        if (this.firstElement != null) {
            return Collections.singletonList(this.firstElement);
        }
        return Collections.emptyList();
    }
}

