/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReadOnlyMapFactory<K, V> {
    private K firstKey = null;
    private V firstValue = null;
    private Map<K, V> map = null;
    private boolean exported = false;

    private ReadOnlyMapFactory() {
    }

    public static <K, V> ReadOnlyMapFactory<K, V> create() {
        return new ReadOnlyMapFactory<K, V>();
    }

    public static <K, V> Map<K, V> create(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    public static <K, V> Map<K, V> create(Map<K, V> map) {
        return ReadOnlyMapFactory.create().add(map).export();
    }

    public ReadOnlyMapFactory<K, V> add(K key, V value) {
        if (this.exported) {
            throw new IllegalStateException();
        }
        if (this.map != null) {
            this.map.put(key, value);
        } else if (this.firstKey != null) {
            this.map = new HashMap();
            this.map.put(this.firstKey, this.firstValue);
            this.map.put(key, value);
            this.firstKey = null;
            this.firstValue = null;
        } else {
            this.firstKey = key;
            this.firstValue = value;
        }
        return this;
    }

    public ReadOnlyMapFactory<K, V> add(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Map<K, V> export() {
        if (this.exported) {
            throw new IllegalStateException();
        }
        this.exported = true;
        if (this.map != null) {
            return Collections.unmodifiableMap(this.map);
        }
        if (this.firstKey != null) {
            return Collections.singletonMap(this.firstKey, this.firstValue);
        }
        return Collections.emptyMap();
    }
}

