/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.binding.t0007.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0007.TestElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestElementImpl
extends ModelElement
implements TestElement {
    private Value<String> testProperty;

    public TestElementImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public TestElementImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getTestProperty() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.testProperty == null) {
                this.refresh((ModelProperty)PROP_TEST_PROPERTY, true);
            }
            return this.testProperty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTestProperty(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_TEST_PROPERTY.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_TEST_PROPERTY, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_TEST_PROPERTY, true);
            if (!TestElementImpl.equal((String)this.testProperty.getText(false), (String)value)) {
                this.resource().binding(PROP_TEST_PROPERTY).write(value);
                this.refresh((ModelProperty)PROP_TEST_PROPERTY, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_TEST_PROPERTY && (this.testProperty != null || force)) {
                Value<String> oldValue = this.testProperty;
                String val = this.resource().binding(PROP_TEST_PROPERTY).read();
                this.testProperty = new Value((IModelElement)this, PROP_TEST_PROPERTY, ((ValueNormalizationService)this.service((ModelProperty)PROP_TEST_PROPERTY, ValueNormalizationService.class)).normalize(PROP_TEST_PROPERTY.encodeKeywords(val)));
                this.testProperty.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_TEST_PROPERTY);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_TEST_PROPERTY));
                } else {
                    if (this.testProperty.equals(oldValue)) {
                        this.testProperty = oldValue;
                    } else {
                        if (!TestElementImpl.equal((String)this.testProperty.getText(false), (String)oldValue.getText(false)) || !TestElementImpl.equal((String)this.testProperty.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_TEST_PROPERTY));
                        }
                        if (!this.testProperty.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_TEST_PROPERTY, oldValue.validation(), this.testProperty.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_TEST_PROPERTY, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_TEST_PROPERTY) {
            return this.getTestProperty();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_TEST_PROPERTY) {
            this.setTestProperty((String)value);
            return;
        }
        super.write(property, value);
    }
}

