/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.gallery.PossibleValuesGallery;
import org.eclipse.sapphire.samples.gallery.PossibleValuesGalleryListItem;
import org.eclipse.sapphire.services.ValueNormalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PossibleValuesGalleryImpl
extends ModelElement
implements PossibleValuesGallery {
    private Value<String> color;
    private ModelElementList<PossibleValuesGalleryListItem> coloredShapes;
    private Value<String> shape;

    public PossibleValuesGalleryImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public PossibleValuesGalleryImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getColor() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.color == null) {
                this.refresh((ModelProperty)PROP_COLOR, true);
            }
            return this.color;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setColor(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_COLOR.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_COLOR, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_COLOR, true);
            if (!PossibleValuesGalleryImpl.equal((String)this.color.getText(false), (String)value)) {
                this.resource().binding(PROP_COLOR).write(value);
                this.refresh((ModelProperty)PROP_COLOR, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<PossibleValuesGalleryListItem> getColoredShapes() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.coloredShapes == null) {
                this.refresh((ModelProperty)PROP_COLORED_SHAPES, true);
            }
            return this.coloredShapes;
        }
    }

    protected void disposeProperties() {
        if (this.coloredShapes != null) {
            for (IModelElement element : this.coloredShapes) {
                element.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getShape() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.shape == null) {
                this.refresh((ModelProperty)PROP_SHAPE, true);
            }
            return this.shape;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShape(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_SHAPE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_SHAPE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_SHAPE, true);
            if (!PossibleValuesGalleryImpl.equal((String)this.shape.getText(false), (String)value)) {
                this.resource().binding(PROP_SHAPE).write(value);
                this.refresh((ModelProperty)PROP_SHAPE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_COLOR) {
                if (this.color != null || force) {
                    Value<String> oldValue = this.color;
                    String val = this.resource().binding(PROP_COLOR).read();
                    this.color = new Value((IModelElement)this, PROP_COLOR, ((ValueNormalizationService)this.service((ModelProperty)PROP_COLOR, ValueNormalizationService.class)).normalize(PROP_COLOR.encodeKeywords(val)));
                    this.color.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_COLOR);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_COLOR));
                    } else {
                        if (this.color.equals(oldValue)) {
                            this.color = oldValue;
                        } else {
                            if (!PossibleValuesGalleryImpl.equal((String)this.color.getText(false), (String)oldValue.getText(false)) || !PossibleValuesGalleryImpl.equal((String)this.color.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_COLOR));
                            }
                            if (!this.color.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_COLOR, oldValue.validation(), this.color.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_COLOR, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_COLORED_SHAPES) {
                if (this.coloredShapes == null) {
                    if (force) {
                        this.coloredShapes = new ModelElementList((IModelElement)this, PROP_COLORED_SHAPES);
                        ListBindingImpl binding = this.resource().binding(PROP_COLORED_SHAPES);
                        this.coloredShapes.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_COLORED_SHAPES);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_COLORED_SHAPES));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_COLORED_SHAPES);
                    boolean notified = this.coloredShapes.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_COLORED_SHAPES, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_SHAPE && (this.shape != null || force)) {
                Value<String> oldValue = this.shape;
                String val = this.resource().binding(PROP_SHAPE).read();
                this.shape = new Value((IModelElement)this, PROP_SHAPE, ((ValueNormalizationService)this.service((ModelProperty)PROP_SHAPE, ValueNormalizationService.class)).normalize(PROP_SHAPE.encodeKeywords(val)));
                this.shape.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_SHAPE);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_SHAPE));
                } else {
                    if (this.shape.equals(oldValue)) {
                        this.shape = oldValue;
                    } else {
                        if (!PossibleValuesGalleryImpl.equal((String)this.shape.getText(false), (String)oldValue.getText(false)) || !PossibleValuesGalleryImpl.equal((String)this.shape.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_SHAPE));
                        }
                        if (!this.shape.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_SHAPE, oldValue.validation(), this.shape.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_SHAPE, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_COLOR) {
            return this.getColor();
        }
        if (property == PROP_COLORED_SHAPES) {
            return this.getColoredShapes();
        }
        if (property == PROP_SHAPE) {
            return this.getShape();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_COLOR) {
            this.setColor((String)value);
            return;
        }
        if (property == PROP_SHAPE) {
            this.setShape((String)value);
            return;
        }
        super.write(property, value);
    }
}

