/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelMetadataItem;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.LocalizationSystem;
import org.eclipse.sapphire.modeling.localization.LocalizationUtil;
import org.eclipse.sapphire.util.ReadOnlyListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumValueType
extends ModelMetadataItem {
    private Class<?> enumClass;
    private LocalizationService localizationService;

    public EnumValueType(Class<?> enumClass) {
        this.enumClass = enumClass;
        this.localizationService = LocalizationSystem.service(enumClass);
    }

    public Class<?> getEnumTypeClass() {
        return this.enumClass;
    }

    @Override
    protected void initAnnotations(ReadOnlyListFactory<Annotation> annotations) {
        annotations.add((Annotation[])this.enumClass.getDeclaredAnnotations());
    }

    public <A extends Annotation> A getAnnotation(Enum<?> enumItem, Class<A> type) {
        Field enumItemField;
        try {
            enumItemField = this.enumClass.getField(enumItem.name());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return enumItemField.getAnnotation(type);
    }

    public Enum<?>[] getItems() {
        try {
            Method valuesMethod = this.enumClass.getMethod("values", new Class[0]);
            return (Enum[])valuesMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getDefaultLabel() {
        String className = this.enumClass.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            className = className.substring(lastDot + 1);
        }
        return LocalizationUtil.transformCamelCaseToLabel(className);
    }

    public String getLabel(Enum<?> enumItem, boolean longLabel, CapitalizationType capitalizationType, boolean includeMnemonic) {
        String labelText = null;
        Label labelAnnotation = this.getAnnotation(enumItem, Label.class);
        if (labelAnnotation != null) {
            if (longLabel) {
                labelText = labelAnnotation.full().trim();
            }
            if (labelText == null || labelText.length() == 0) {
                labelText = labelAnnotation.standard().trim();
            }
        }
        if (labelText == null || labelText.length() == 0) {
            labelText = enumItem.name().toLowerCase().replace('_', ' ');
        }
        labelText = this.getLocalizationService().text(labelText, capitalizationType, includeMnemonic);
        return labelText;
    }

    @Override
    public LocalizationService getLocalizationService() {
        return this.localizationService;
    }
}

