/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.TypeCast;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FunctionResult {
    private final Function function;
    private final FunctionContext context;
    private final List<FunctionResult> operands;
    private final ListenerContext listeners;
    private Object value;
    private Status status;

    public FunctionResult(Function function, FunctionContext context) {
        this.function = function;
        this.context = context;
        this.listeners = new ListenerContext();
        this.operands = Collections.unmodifiableList(this.initOperands());
        if (!this.operands.isEmpty()) {
            Listener listener = new Listener(){

                public void handle(Event event) {
                    FunctionResult.this.refresh();
                }
            };
            for (FunctionResult operand : this.operands) {
                operand.attach(listener);
            }
        }
        this.init();
        this.refresh();
    }

    protected List<FunctionResult> initOperands() {
        List<Function> operands = this.function().operands();
        if (operands.size() == 0) {
            return Collections.emptyList();
        }
        if (operands.size() == 1) {
            return Collections.singletonList(operands.get(0).evaluate(this.context));
        }
        ArrayList<FunctionResult> result = new ArrayList<FunctionResult>();
        for (Function operand : operands) {
            result.add(operand.evaluate(this.context));
        }
        return result;
    }

    protected void init() {
    }

    public final Function function() {
        return this.function;
    }

    public final FunctionContext context() {
        return this.context;
    }

    public final List<FunctionResult> operands() {
        return this.operands;
    }

    public final FunctionResult operand(int position) {
        if (position < this.operands.size()) {
            return this.operands.get(position);
        }
        throw new FunctionException(NLS.bind(Resources.missingOperandMessage, this.getClass().getName(), String.valueOf(position)));
    }

    protected abstract Object evaluate() throws FunctionException;

    public final Object value() throws FunctionException {
        if (this.status.severity() == Status.Severity.ERROR) {
            throw new FunctionException(this.status);
        }
        return this.value;
    }

    public final Status status() {
        return this.status;
    }

    protected final void refresh() {
        Object newValue = null;
        Status newStatus = Status.createOkStatus();
        try {
            newValue = this.evaluate();
        }
        catch (FunctionException e) {
            newStatus = e.status();
        }
        catch (Exception e) {
            newStatus = Status.createErrorStatus(e);
        }
        if (newValue instanceof Function) {
            throw new IllegalStateException();
        }
        if (!this.equal(this.value, newValue) || !this.equal(this.status, newStatus)) {
            this.value = newValue;
            this.status = newStatus;
            this.listeners.broadcast();
        }
    }

    public final boolean attach(Listener listener) {
        return this.listeners.attach(listener);
    }

    public final boolean detach(Listener listener) {
        return this.listeners.detach(listener);
    }

    public void dispose() {
        for (FunctionResult operand : this.operands) {
            operand.dispose();
        }
    }

    protected final <X> X cast(Object obj, Class<X> type) {
        if (obj instanceof FunctionResult) {
            throw new IllegalArgumentException();
        }
        if (type == String.class) {
            if (obj instanceof String) {
                return (X)obj;
            }
            if (obj == null) {
                return (X)"";
            }
            if (obj instanceof Enum) {
                return (X)((Enum)obj).name();
            }
            if (obj instanceof Value) {
                String res = ((Value)obj).getText();
                res = res == null ? "" : res;
                return (X)res;
            }
            if (obj instanceof List || obj instanceof Set) {
                StringBuilder res = new StringBuilder();
                boolean first = true;
                for (Object entry : (Collection)obj) {
                    if (first) {
                        first = false;
                    } else {
                        res.append(',');
                    }
                    String str = this.cast(entry, String.class);
                    if (str == null) continue;
                    res.append(str);
                }
                return (X)res.toString();
            }
            if (obj.getClass().isArray()) {
                StringBuilder res = new StringBuilder();
                int i = 0;
                int n = Array.getLength(obj);
                while (i < n) {
                    String str;
                    if (i > 0) {
                        res.append(',');
                    }
                    if ((str = this.cast(Array.get(obj, i), String.class)) != null) {
                        res.append(str);
                    }
                    ++i;
                }
                return (X)res.toString();
            }
            return (X)obj.toString();
        }
        if (Number.class.isAssignableFrom(type)) {
            if (obj instanceof Value) {
                obj = ((Value)obj).getContent();
            }
            if (obj == null || obj instanceof String && ((String)obj).length() == 0) {
                obj = (short)0;
            } else if (obj instanceof Character) {
                obj = (short)((Character)obj).charValue();
            } else if (obj instanceof Boolean) {
                throw new FunctionException(NLS.bind(Resources.cannotCastMessage, obj.getClass().getName(), type.getName()));
            }
            if (obj.getClass() == type) {
                return (X)obj;
            }
            if (obj instanceof Number) {
                if (type == BigInteger.class) {
                    if (obj instanceof BigDecimal) {
                        return (X)((BigDecimal)obj).toBigInteger();
                    }
                    return (X)BigInteger.valueOf(((Number)obj).longValue());
                }
                if (type == BigDecimal.class) {
                    if (obj instanceof BigInteger) {
                        return (X)new BigDecimal((BigInteger)obj);
                    }
                    return (X)new BigDecimal(((Number)obj).doubleValue());
                }
                if (type == Byte.class) {
                    return (X)new Byte(((Number)obj).byteValue());
                }
                if (type == Short.class) {
                    return (X)new Short(((Number)obj).shortValue());
                }
                if (type == Integer.class) {
                    return (X)new Integer(((Number)obj).intValue());
                }
                if (type == Long.class) {
                    return (X)new Long(((Number)obj).longValue());
                }
                if (type == Float.class) {
                    return (X)new Float(((Number)obj).floatValue());
                }
                if (type == Double.class) {
                    return (X)new Double(((Number)obj).doubleValue());
                }
            } else if (obj instanceof String) {
                if (type == BigDecimal.class) {
                    return (X)new BigDecimal((String)obj);
                }
                if (type == BigInteger.class) {
                    return (X)new BigInteger((String)obj);
                }
                if (type == Byte.class) {
                    return (X)Byte.valueOf((String)obj);
                }
                if (type == Short.class) {
                    return (X)Short.valueOf((String)obj);
                }
                if (type == Integer.class) {
                    return (X)Integer.valueOf((String)obj);
                }
                if (type == Long.class) {
                    return (X)Long.valueOf((String)obj);
                }
                if (type == Float.class) {
                    return (X)Float.valueOf((String)obj);
                }
                if (type == Double.class) {
                    return (X)Double.valueOf((String)obj);
                }
            }
            throw new FunctionException(NLS.bind(Resources.cannotCastMessage, obj.getClass().getName(), type.getName()));
        }
        if (type == Character.class) {
            if (obj instanceof Value) {
                obj = ((Value)obj).getContent();
            }
            if (obj == null || obj instanceof String && ((String)obj).length() == 0) {
                return (X)Character.valueOf('\u0000');
            }
            if (obj instanceof Character) {
                return (X)obj;
            }
            if (obj instanceof Boolean) {
                throw new FunctionException(NLS.bind(Resources.cannotCastMessage, obj.getClass().getName(), type.getName()));
            }
            if (obj instanceof Number) {
                return (X)Character.valueOf((char)this.cast(obj, Short.class).shortValue());
            }
            if (obj instanceof String) {
                return (X)Character.valueOf(((String)obj).charAt(0));
            }
            throw new FunctionException(NLS.bind(Resources.cannotCastMessage, obj.getClass().getName(), type.getName()));
        }
        if (type == Boolean.class) {
            if (obj instanceof Value) {
                obj = ((Value)obj).getContent();
            }
            if (obj == null || obj instanceof String && ((String)obj).length() == 0) {
                return (X)Boolean.FALSE;
            }
            if (obj instanceof Boolean) {
                return (X)obj;
            }
            if (obj instanceof String) {
                return (X)Boolean.valueOf((String)obj);
            }
            throw new FunctionException(NLS.bind(Resources.cannotCastMessage, obj.getClass().getName(), type.getName()));
        }
        if (Enum.class.isAssignableFrom(type)) {
            if (obj instanceof Value) {
                obj = ((Value)obj).getContent();
            }
            if (obj == null) {
                return null;
            }
            if (type.isInstance(obj)) {
                return (X)obj;
            }
            if (obj instanceof String) {
                String str = (String)obj;
                if (str.length() == 0) {
                    return null;
                }
                return Enum.valueOf(type, str);
            }
            throw new FunctionException(NLS.bind(Resources.cannotCastMessage, obj.getClass().getName(), type.getName()));
        }
        if (List.class.isAssignableFrom(type)) {
            if (obj instanceof Value) {
                obj = ((Value)obj).getContent();
            }
            if (obj == null) {
                return null;
            }
            if (obj instanceof List) {
                return (X)obj;
            }
            if (obj instanceof Collection) {
                return (X)new ArrayList((Collection)obj);
            }
            if (obj.getClass().isArray()) {
                ArrayList<Object> list = new ArrayList<Object>();
                int i = 0;
                int n = Array.getLength(obj);
                while (i < n) {
                    list.add(Array.get(obj, i));
                    ++i;
                }
                return (X)list;
            }
            if (obj instanceof String) {
                String str = (String)obj;
                if (str.length() == 0) {
                    return (X)Collections.emptyList();
                }
                return (X)Arrays.asList(((String)obj).split("\\,"));
            }
            return (X)Collections.singletonList(obj);
        }
        if (obj instanceof Value) {
            obj = ((Value)obj).getContent();
        }
        if (obj == null) {
            return null;
        }
        if (type.isInstance(obj)) {
            return (X)obj;
        }
        if (obj instanceof String && ((String)obj).length() == 0) {
            return null;
        }
        for (TypeCast cast : SapphireModelingExtensionSystem.getTypeCasts()) {
            if (!cast.applicable(this.context, this.function, obj, type)) continue;
            return (X)cast.evaluate(this.context, this.function, obj, type);
        }
        throw new FunctionException(NLS.bind(Resources.cannotCastMessage, obj.getClass().getName(), type.getName()));
    }

    protected final boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            if (b instanceof Value) {
                return ((Value)b).getText() == null;
            }
            return false;
        }
        if (b == null) {
            if (a instanceof Value) {
                return ((Value)a).getText() == null;
            }
            return false;
        }
        if (a instanceof BigDecimal || b instanceof BigDecimal) {
            BigDecimal x = this.cast(a, BigDecimal.class);
            BigDecimal y = this.cast(b, BigDecimal.class);
            return x.equals(y);
        }
        if (a instanceof Float || a instanceof Double || b instanceof Float || b instanceof Double) {
            Double y;
            Double x = this.cast(a, Double.class);
            return x == (y = this.cast(b, Double.class));
        }
        if (a instanceof BigInteger || b instanceof BigInteger) {
            BigInteger x = this.cast(a, BigInteger.class);
            BigInteger y = this.cast(b, BigInteger.class);
            return x.equals(y);
        }
        if (a instanceof Byte || a instanceof Short || a instanceof Character || a instanceof Integer || a instanceof Long || b instanceof Byte || b instanceof Short || b instanceof Character || b instanceof Integer || b instanceof Long) {
            Long y;
            Long x = this.cast(a, Long.class);
            return x == (y = this.cast(b, Long.class));
        }
        if (a instanceof Boolean || b instanceof Boolean) {
            Boolean y;
            Boolean x = this.cast(a, Boolean.class);
            return x == (y = this.cast(b, Boolean.class));
        }
        if (a instanceof Enum) {
            return a == this.cast(b, a.getClass());
        }
        if (b instanceof Enum) {
            return this.cast(a, b.getClass()) == b;
        }
        if (a instanceof String || b instanceof String) {
            String y;
            String x = this.cast(a, String.class);
            return x.compareTo(y = this.cast(b, String.class)) == 0;
        }
        return a.equals(b);
    }

    private static final class Resources
    extends NLS {
        public static String cannotCastMessage;
        public static String missingOperandMessage;

        static {
            Resources.initializeMessages(FunctionResult.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

