/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;

public final class Literal
extends Function {
    public static final Literal NULL = Literal.create(null);
    private Object value;

    public Literal(Object value) {
        if (value instanceof Function) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    public static Literal create(Object obj) {
        Literal literal = new Literal(obj);
        literal.init(new Function[0]);
        return literal;
    }

    public String name() {
        return "Literal";
    }

    public Object value() {
        return this.value;
    }

    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            protected Object evaluate() {
                Object val = Literal.this.value;
                if (val instanceof String) {
                    val = this.context().getLocalizationService().text((String)val, CapitalizationType.NO_CAPS, true);
                }
                return val;
            }
        };
    }

    public void toString(StringBuilder buf, boolean topLevel) {
        if (this.value == null) {
            buf.append("null");
        } else if (this.value instanceof Boolean || this.value instanceof Number) {
            buf.append(this.value.toString());
        } else if (this.value instanceof String) {
            if (topLevel) {
                buf.append((String)this.value);
            } else {
                buf.append('\"');
                buf.append(((String)this.value).replace("\"", "\\\""));
                buf.append('\"');
            }
        } else {
            buf.append('$');
            buf.append(this.value.toString());
            buf.append('$');
        }
    }
}

