/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.gallery.InitialValueGallery;
import org.eclipse.sapphire.services.ValueNormalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InitialValueGalleryImpl
extends ModelElement
implements InitialValueGallery {
    private Value<String> pString;

    public InitialValueGalleryImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public InitialValueGalleryImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getString() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pString == null) {
                this.refresh((ModelProperty)PROP_STRING, true);
            }
            return this.pString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_STRING.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_STRING, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_STRING, true);
            if (!InitialValueGalleryImpl.equal((String)this.pString.getText(false), (String)value)) {
                this.resource().binding(PROP_STRING).write(value);
                this.refresh((ModelProperty)PROP_STRING, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_STRING && (this.pString != null || force)) {
                Value<String> oldValue = this.pString;
                String val = this.resource().binding(PROP_STRING).read();
                this.pString = new Value((IModelElement)this, PROP_STRING, ((ValueNormalizationService)this.service((ModelProperty)PROP_STRING, ValueNormalizationService.class)).normalize(PROP_STRING.encodeKeywords(val)));
                this.pString.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_STRING);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_STRING));
                } else {
                    if (this.pString.equals(oldValue)) {
                        this.pString = oldValue;
                    } else {
                        if (!InitialValueGalleryImpl.equal((String)this.pString.getText(false), (String)oldValue.getText(false)) || !InitialValueGalleryImpl.equal((String)this.pString.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_STRING));
                        }
                        if (!this.pString.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_STRING, oldValue.validation(), this.pString.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_STRING, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_STRING) {
            return this.getString();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_STRING) {
            this.setString((String)value);
            return;
        }
        super.write(property, value);
    }
}

