/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.ui.PropertyEditorPart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListPropertyEditorRenderer
extends PropertyEditorRenderer {
    private Listener listElementListener = new Listener(){

        public void handle(Event event) {
            ListPropertyEditorRenderer.this.handleListElementChangedEvent(event);
        }
    };

    public ListPropertyEditorRenderer(SapphireRenderingContext context, PropertyEditorPart part) {
        super(context, part);
        this.attachListElementListener();
        this.addOnDisposeOperation(new Runnable(){

            public void run() {
                ModelElementList<IModelElement> list = ListPropertyEditorRenderer.this.getList();
                if (list != null) {
                    for (IModelElement entry : list) {
                        entry.detach(ListPropertyEditorRenderer.this.listElementListener);
                    }
                }
            }
        });
    }

    public ListProperty getProperty() {
        return (ListProperty)super.getProperty();
    }

    public final ModelElementList<IModelElement> getList() {
        IModelElement modelElement = this.getModelElement();
        if (modelElement != null) {
            return modelElement.read(this.getProperty());
        }
        return null;
    }

    @Override
    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        this.attachListElementListener();
    }

    protected void handleListElementChangedEvent(Event event) {
    }

    private void attachListElementListener() {
        ModelElementList<IModelElement> list = this.getList();
        if (list != null) {
            for (IModelElement entry : list) {
                entry.attach(this.listElementListener);
            }
        }
    }
}

