/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt;

import java.util.Collections;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireDialogPart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireDialogDef;
import org.eclipse.sapphire.ui.def.SapphireUiDefFactory;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SapphireDialog
extends Dialog {
    private final SapphireDialogPart part;
    private final boolean preferFormStyle;
    private Button okButton;

    public SapphireDialog(Shell shell, IModelElement modelElement, String dialogDefPath) {
        this(shell, modelElement, SapphireUiDefFactory.getDialogDef(dialogDefPath));
    }

    public SapphireDialog(Shell shell, IModelElement modelElement, ISapphireDialogDef definition) {
        this(shell, (SapphireDialogPart)SapphirePart.create(null, modelElement, definition, Collections.<String, String>emptyMap()));
    }

    public SapphireDialog(Shell shell, SapphireDialogPart part) {
        super(shell);
        this.part = part;
        this.preferFormStyle = part.getPreferFormStyle();
    }

    public final IModelElement getModelElement() {
        return this.part.getModelElement();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.part.getLabel());
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.preferFormStyle) {
            composite.setBackground(Display.getCurrent().getSystemColor(1));
        }
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        innerComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        SapphireRenderingContext context = new SapphireRenderingContext((ISapphirePart)this.part, innerComposite);
        this.part.render(context);
        String initialFocusProperty = (String)this.part.definition().getInitialFocus().getContent();
        if (initialFocusProperty != null) {
            this.part.setFocus(initialFocusProperty);
        }
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        if (this.preferFormStyle) {
            composite.setBackground(Display.getCurrent().getSystemColor(1));
        }
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(parent);
        if (this.preferFormStyle) {
            composite.setBackground(Display.getCurrent().getSystemColor(1));
        }
        this.okButton = this.getButton(0);
        final Listener listener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphirePart.ValidationChangedEvent) {
                    SapphireDialog.this.updateOkButtonEnablement();
                }
            }
        };
        this.part.attach(listener);
        this.okButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                SapphireDialog.this.part.detach(listener);
            }
        });
        this.updateOkButtonEnablement();
        return composite;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (this.preferFormStyle) {
            button.setBackground(Display.getCurrent().getSystemColor(1));
        }
        return button;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        DelayedTasksExecutor.sweep();
        super.okPressed();
    }

    private void updateOkButtonEnablement() {
        boolean actual;
        boolean expected;
        if (!this.okButton.isDisposed() && (expected = this.part.getValidationState().severity() != Status.Severity.ERROR) != (actual = this.okButton.isEnabled())) {
            this.okButton.setEnabled(expected);
        }
    }
}

