/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.misc.t0008.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.tests.modeling.misc.t0008.TestChildElement;
import org.eclipse.sapphire.tests.modeling.misc.t0008.TestRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestRootElementImpl
extends ModelElement
implements TestRootElement {
    private ModelElementList<TestChildElement> pChildren;
    private ModelElementList<TestChildElement> pChildrenReadOnly;

    public TestRootElementImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public TestRootElementImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<TestChildElement> getChildren() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pChildren == null) {
                this.refresh((ModelProperty)PROP_CHILDREN, true);
            }
            return this.pChildren;
        }
    }

    protected void disposeProperties() {
        if (this.pChildren != null) {
            for (IModelElement element : this.pChildren) {
                element.dispose();
            }
        }
        if (this.pChildrenReadOnly != null) {
            for (IModelElement element : this.pChildrenReadOnly) {
                element.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<TestChildElement> getChildrenReadOnly() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pChildrenReadOnly == null) {
                this.refresh((ModelProperty)PROP_CHILDREN_READ_ONLY, true);
            }
            return this.pChildrenReadOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CHILDREN) {
                if (this.pChildren == null) {
                    if (force) {
                        this.pChildren = new ModelElementList((IModelElement)this, PROP_CHILDREN);
                        ListBindingImpl binding = this.resource().binding(PROP_CHILDREN);
                        this.pChildren.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_CHILDREN);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_CHILDREN));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CHILDREN);
                    boolean notified = this.pChildren.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_CHILDREN, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_CHILDREN_READ_ONLY) {
                if (this.pChildrenReadOnly == null) {
                    if (force) {
                        this.pChildrenReadOnly = new ModelElementList((IModelElement)this, PROP_CHILDREN_READ_ONLY);
                        ListBindingImpl binding = this.resource().binding(PROP_CHILDREN_READ_ONLY);
                        this.pChildrenReadOnly.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_CHILDREN_READ_ONLY);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_CHILDREN_READ_ONLY));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CHILDREN_READ_ONLY);
                    boolean notified = this.pChildrenReadOnly.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_CHILDREN_READ_ONLY, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_CHILDREN) {
            return this.getChildren();
        }
        if (property == PROP_CHILDREN_READ_ONLY) {
            return this.getChildrenReadOnly();
        }
        return super.read(property);
    }
}

