/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.util.internal;

import org.eclipse.sapphire.modeling.docsys.BoldPart;
import org.eclipse.sapphire.modeling.docsys.CodePart;
import org.eclipse.sapphire.modeling.docsys.DocumentationContent;
import org.eclipse.sapphire.modeling.docsys.DocumentationPart;
import org.eclipse.sapphire.modeling.docsys.LineBreakPart;
import org.eclipse.sapphire.modeling.docsys.ListItem;
import org.eclipse.sapphire.modeling.docsys.ListPart;
import org.eclipse.sapphire.modeling.docsys.OrderedListPart;
import org.eclipse.sapphire.modeling.docsys.ParagraphBreakPart;
import org.eclipse.sapphire.modeling.docsys.TextPart;
import org.eclipse.sapphire.modeling.docsys.UnorderedListPart;
import org.eclipse.sapphire.services.StandardValueNormalizationService;

public class DocumentationUtil {
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String NEW_LINE_2 = String.valueOf(NEW_LINE) + NEW_LINE;
    private static final String BOLD_BEGIN = "<@#$b>";
    private static final String BOLD_END = "</@#$b>";

    public static final String decodeDocumentationTags(String str) {
        if (str == null) {
            return str;
        }
        DocumentationContent content = DocumentationContent.parse(str.trim());
        StringBuilder buf = new StringBuilder();
        FormatFlags flags = new FormatFlags();
        DocumentationUtil.format(buf, content, -1, flags);
        return buf.toString();
    }

    private static boolean startsWithSpaces(String text) {
        char ch = text.charAt(0);
        return Character.isWhitespace(ch);
    }

    private static boolean endsWithSpaces(String text) {
        char ch = text.charAt(text.length() - 1);
        return Character.isWhitespace(ch);
    }

    private static void format(StringBuilder buf, DocumentationPart part, int index, FormatFlags flags) {
        block9: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block8: {
                                            boolean collapseSpaces = flags.collapseSpaces;
                                            if (!(part instanceof TextPart)) break block8;
                                            String str = ((TextPart)part).getText();
                                            boolean endsWithSpace = DocumentationUtil.endsWithSpaces(str);
                                            boolean startsWithSpace = DocumentationUtil.startsWithSpaces(str);
                                            if (startsWithSpace && buf.toString().endsWith(BOLD_END)) {
                                                buf.append(' ');
                                            }
                                            buf.append(collapseSpaces ? StandardValueNormalizationService.collapse(str) : str);
                                            flags.endsInSpace = endsWithSpace;
                                            break block9;
                                        }
                                        if (!(part instanceof LineBreakPart)) break block10;
                                        buf.append(NEW_LINE);
                                        flags.endsInSpace = false;
                                        break block9;
                                    }
                                    if (!(part instanceof ParagraphBreakPart)) break block11;
                                    buf.append(NEW_LINE_2);
                                    flags.endsInSpace = false;
                                    break block9;
                                }
                                if (!(part instanceof OrderedListPart)) break block12;
                                buf.append(NEW_LINE_2);
                                int childIndex = 0;
                                for (ListItem item : ((ListPart)part).getItems()) {
                                    DocumentationUtil.format(buf, item, ++childIndex, flags);
                                }
                                break block9;
                            }
                            if (!(part instanceof UnorderedListPart)) break block13;
                            buf.append(NEW_LINE_2);
                            for (ListItem item : ((ListPart)part).getItems()) {
                                DocumentationUtil.format(buf, item, -1, flags);
                            }
                            break block9;
                        }
                        if (!(part instanceof ListItem)) break block14;
                        buf.append(index == -1 ? "*" : Integer.valueOf(index));
                        buf.append("  ");
                        for (DocumentationPart child : ((ListItem)part).getChildren()) {
                            DocumentationUtil.format(buf, child, -1, flags);
                        }
                        buf.append(NEW_LINE);
                        flags.endsInSpace = false;
                        break block9;
                    }
                    if (!(part instanceof BoldPart)) break block15;
                    BoldPart boldPart = (BoldPart)part;
                    if (boldPart.isOpen()) {
                        if (flags.endsInSpace) {
                            buf.append(' ');
                        }
                        buf.append(BOLD_BEGIN);
                    } else {
                        buf.append(BOLD_END);
                    }
                    break block9;
                }
                if (!(part instanceof CodePart)) break block16;
                CodePart codePart = (CodePart)part;
                flags.collapseSpaces = !codePart.isOpen();
                break block9;
            }
            if (!(part instanceof DocumentationContent)) break block9;
            for (DocumentationPart child : ((DocumentationContent)part).getChildren()) {
                DocumentationUtil.format(buf, child, -1, flags);
            }
        }
    }

    private static class FormatFlags {
        boolean collapseSpaces = true;
        boolean endsInSpace = false;

        FormatFlags() {
        }
    }
}

