/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PossibleTypesServiceData
extends Data {
    private static final Comparator<ModelElementType> COMPARATOR = new Comparator<ModelElementType>(){

        @Override
        public int compare(ModelElementType x, ModelElementType y) {
            return x.getSimpleName().compareTo(y.getSimpleName());
        }
    };
    private final SortedSet<ModelElementType> types;

    public PossibleTypesServiceData(Collection<ModelElementType> types) {
        TreeSet<ModelElementType> clean = new TreeSet<ModelElementType>(COMPARATOR);
        for (ModelElementType type : types) {
            if (type == null) continue;
            clean.add(type);
        }
        this.types = Collections.unmodifiableSortedSet(clean);
    }

    public PossibleTypesServiceData(ModelElementType ... types) {
        this(MiscUtil.list(types));
    }

    public SortedSet<ModelElementType> types() {
        return this.types;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PossibleTypesServiceData) {
            PossibleTypesServiceData data = (PossibleTypesServiceData)obj;
            return this.types.equals(data.types);
        }
        return false;
    }

    public int hashCode() {
        return this.types.hashCode();
    }
}

