/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactoryProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationsAwareServiceContext
extends ServiceContext {
    public AnnotationsAwareServiceContext(String type, ServiceContext parent) {
        super(type, parent);
    }

    @Override
    protected final List<ServiceFactoryProxy> local() {
        ArrayList<ServiceFactoryProxy> local = new ArrayList<ServiceFactoryProxy>();
        ArrayList<org.eclipse.sapphire.modeling.annotations.Service> serviceAnnotations = new ArrayList<org.eclipse.sapphire.modeling.annotations.Service>();
        serviceAnnotations.addAll(this.annotations(org.eclipse.sapphire.modeling.annotations.Service.class));
        for (Services servicesAnnotation : this.annotations(Services.class)) {
            org.eclipse.sapphire.modeling.annotations.Service[] serviceArray = servicesAnnotation.value();
            int n = serviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                org.eclipse.sapphire.modeling.annotations.Service svc = serviceArray[n2];
                serviceAnnotations.add(svc);
                ++n2;
            }
        }
        for (org.eclipse.sapphire.modeling.annotations.Service svc : serviceAnnotations) {
            Map<Object, Object> params;
            Set<Object> overrides;
            final Class<? extends Service> cl = svc.impl();
            String[] overridesInAnnotation = svc.overrides();
            if (overridesInAnnotation.length == 0) {
                overrides = Collections.emptySet();
            } else if (overridesInAnnotation.length == 1) {
                overrides = Collections.singleton(overridesInAnnotation[0]);
            } else {
                HashSet<String> temp = new HashSet<String>();
                overrides = Collections.unmodifiableSet(temp);
                String[] stringArray = overridesInAnnotation;
                int n = overridesInAnnotation.length;
                int n3 = 0;
                while (n3 < n) {
                    String override = stringArray[n3];
                    temp.add(override);
                    ++n3;
                }
            }
            Service.Param[] paramsInAnnotation = svc.params();
            if (paramsInAnnotation.length == 0) {
                params = Collections.emptyMap();
            } else if (paramsInAnnotation.length == 1) {
                params = Collections.singletonMap(paramsInAnnotation[0].name(), paramsInAnnotation[0].value());
            } else {
                HashMap<String, String> temp = new HashMap<String, String>();
                Service.Param[] paramArray = paramsInAnnotation;
                int n = paramsInAnnotation.length;
                int n4 = 0;
                while (n4 < n) {
                    Service.Param param = paramArray[n4];
                    temp.put(param.name(), param.value());
                    ++n4;
                }
                params = Collections.unmodifiableMap(temp);
            }
            ServiceFactoryProxy proxy = new ServiceFactoryProxy(){

                @Override
                public Class<? extends Service> type() {
                    return cl;
                }

                @Override
                public Set<String> overrides() {
                    return overrides;
                }

                @Override
                public Map<String, String> parameters() {
                    return params;
                }

                @Override
                protected Service createHandOff(ServiceContext context, Class<? extends Service> service) {
                    Service instance = null;
                    try {
                        instance = (Service)cl.newInstance();
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                    return instance;
                }
            };
            local.add(proxy);
        }
        return local;
    }

    protected abstract <A extends Annotation> List<A> annotations(Class<A> var1);
}

