/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReadOnlySetFactory<E> {
    private E firstElement = null;
    private Set<E> set = null;
    private boolean exported = false;

    private ReadOnlySetFactory() {
    }

    public static <E> ReadOnlySetFactory<E> create() {
        return new ReadOnlySetFactory<E>();
    }

    public static <E> Set<E> create(E element) {
        return Collections.singleton(element);
    }

    public static <E> Set<E> create(E ... elements) {
        return ReadOnlySetFactory.create().add(elements).export();
    }

    public static <E> Set<E> create(Collection<E> elements) {
        return ReadOnlySetFactory.create().add(elements).export();
    }

    public ReadOnlySetFactory<E> add(E element) {
        if (this.exported) {
            throw new IllegalStateException();
        }
        if (this.set != null) {
            this.set.add(element);
        } else if (this.firstElement != null) {
            this.set = new HashSet();
            this.set.add(this.firstElement);
            this.set.add(element);
            this.firstElement = null;
        } else {
            this.firstElement = element;
        }
        return this;
    }

    public ReadOnlySetFactory<E> add(E ... elements) {
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            this.add(element);
            ++n2;
        }
        return this;
    }

    public ReadOnlySetFactory<E> add(Collection<E> elements) {
        for (E element : elements) {
            this.add(element);
        }
        return this;
    }

    public Set<E> export() {
        if (this.exported) {
            throw new IllegalStateException();
        }
        this.exported = true;
        if (this.set != null) {
            return Collections.unmodifiableSet(this.set);
        }
        if (this.firstElement != null) {
            return Collections.singleton(this.firstElement);
        }
        return Collections.emptySet();
    }
}

