/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.FormPart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartContainer;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.FormDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.PageBookDef;
import org.eclipse.sapphire.ui.def.PageBookKeyMapping;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class PageBookPart
extends FormPart {
    private Map<Object, FormDef> pageDefs;
    private FormDef defaultPageDef;
    private SapphirePartContainer currentPage;
    private boolean exposePageValidationState = false;
    private Listener childPartListener = null;

    protected void init() {
        super.init();
        PageBookDef def = (PageBookDef)this.definition;
        this.pageDefs = new LinkedHashMap<Object, FormDef>();
        for (PageBookKeyMapping page : def.getPages()) {
            Object key = this.parsePageKey(page.getKey().getText());
            this.pageDefs.put(key, page);
        }
        this.defaultPageDef = def.getDefaultPage();
        if (this.defaultPageDef.getContent().isEmpty()) {
            this.defaultPageDef = this.initDefaultPageDef();
        }
    }

    protected FormDef initDefaultPageDef() {
        ISapphireUiDef root = (ISapphireUiDef)ISapphireUiDef.TYPE.instantiate();
        return (FormDef)root.getPartDefs().insert(FormDef.TYPE);
    }

    public void render(final SapphireRenderingContext context) {
        final Composite composite = new Composite(context.getComposite(), 0);
        composite.setLayoutData((Object)GridLayoutUtil.gdhspan(this.getScaleVertically() ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2));
        composite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        context.adapt((Control)composite);
        final Listener pageChangeListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof PageChangedEvent) {
                    Control[] controlArray = composite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        control.dispose();
                        ++n2;
                    }
                    if (PageBookPart.this.currentPage != null) {
                        PageBookPart.this.currentPage.render(new SapphireRenderingContext(PageBookPart.this, context, composite));
                    }
                    context.layout();
                }
            }
        };
        this.attach(pageChangeListener);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                PageBookPart.this.detach(pageChangeListener);
            }
        });
        if (this.currentPage != null) {
            this.currentPage.render(new SapphireRenderingContext(this, context, composite));
        }
    }

    public final SapphirePartContainer getCurrentPage() {
        return this.currentPage;
    }

    protected final void changePage(IModelElement modelElementForPage, Object pageKey) {
        FormDef pageDef = this.defaultPageDef;
        if (pageKey != null) {
            for (Map.Entry<Object, FormDef> entry : this.pageDefs.entrySet()) {
                if (!entry.getKey().equals(pageKey)) continue;
                pageDef = entry.getValue();
                break;
            }
        }
        this.changePage(modelElementForPage, pageDef);
    }

    private void changePage(IModelElement modelElementForPage, FormDef pageDef) {
        if (modelElementForPage == null) {
            throw new IllegalArgumentException();
        }
        if (this.currentPage != null) {
            this.currentPage.dispose();
        }
        if (pageDef != null) {
            this.currentPage = (SapphirePartContainer)PageBookPart.create(this, modelElementForPage, pageDef, this.params);
            if (this.childPartListener != null) {
                this.currentPage.attach(this.childPartListener);
            }
        } else {
            this.currentPage = null;
        }
        this.updateValidationState();
        this.broadcast(new PageChangedEvent(this));
    }

    protected abstract Object parsePageKey(String var1);

    protected Status computeValidationState() {
        SapphirePartContainer currentPage;
        if (this.exposePageValidationState && (currentPage = this.getCurrentPage()) != null) {
            return currentPage.getValidationState();
        }
        return Status.createOkStatus();
    }

    protected final void setExposePageValidationState(boolean exposePageValidationState) {
        if (this.exposePageValidationState != exposePageValidationState) {
            this.exposePageValidationState = exposePageValidationState;
            if (this.exposePageValidationState) {
                this.childPartListener = new Listener(){

                    public void handle(Event event) {
                        if (event instanceof SapphirePart.ValidationChangedEvent) {
                            PageBookPart.this.updateValidationState();
                        }
                    }
                };
                if (this.currentPage != null) {
                    this.currentPage.attach(this.childPartListener);
                }
            } else {
                this.childPartListener = null;
            }
            this.updateValidationState();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.currentPage != null) {
            this.currentPage.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ClassBasedKey {
        private final Class<?> cl;

        private ClassBasedKey(Class<?> cl) {
            this.cl = cl;
        }

        public static ClassBasedKey create(Class<?> cl) {
            return cl == null ? null : new ClassBasedKey(cl);
        }

        public static ClassBasedKey create(Object obj) {
            return obj == null ? null : new ClassBasedKey(obj.getClass());
        }

        public int hashCode() {
            return this.cl == null ? -1 : this.cl.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassBasedKey)) {
                return false;
            }
            Class<?> cl2 = ((ClassBasedKey)obj).cl;
            return this.cl.isAssignableFrom(cl2) || cl2.isAssignableFrom(this.cl);
        }
    }

    public static final class PageChangedEvent
    extends SapphirePart.PartEvent {
        public PageChangedEvent(SapphirePart part) {
            super(part);
        }
    }
}

