/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.ElementEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.FixedOrderList;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.ImageService;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.ui.ListSelectionService;
import org.eclipse.sapphire.ui.PropertyEditorPart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystem;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePropertyEditorActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.def.PropertyEditorDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.internal.binding.AbstractBinding;
import org.eclipse.sapphire.ui.renderers.swt.ListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.sapphire.ui.renderers.swt.ValueLabelProvider;
import org.eclipse.sapphire.ui.swt.ModelElementsTransfer;
import org.eclipse.sapphire.ui.swt.internal.PopUpListFieldCellEditorPresentation;
import org.eclipse.sapphire.ui.swt.internal.PopUpListFieldStyle;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.HyperlinkTable;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireMenuActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SapphireTextCellEditor;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SwtUtil;
import org.eclipse.sapphire.ui.util.MiscUtil;
import org.eclipse.sapphire.util.CollectionsUtil;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.sapphire.util.ReadOnlyListFactory;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListPropertyEditorRenderer
extends ListPropertyEditorRenderer {
    private boolean exposeAddAction = true;
    private boolean exposeDeleteAction = true;
    private Map<IModelElement, TableRow> rows;
    private Table table;
    private TableViewer tableViewer;
    private SelectionProvider selectionProvider;
    private List<ColumnHandler> columnHandlers;
    private Runnable refreshOperation;
    private static final ImageDescriptor IMG_CHECKBOX_ON = SwtRendererUtil.createImageDescriptor(BooleanPropertyColumnHandler.class, "CheckBoxOn.gif");
    private static final ImageDescriptor IMG_CHECKBOX_OFF = SwtRendererUtil.createImageDescriptor(BooleanPropertyColumnHandler.class, "CheckBoxOff.gif");

    public DefaultListPropertyEditorRenderer(SapphireRenderingContext context, PropertyEditorPart part) {
        super(context, part);
    }

    @Override
    protected void createContents(Composite parent) {
        this.createContents(parent, false, false);
    }

    protected Control createContents(Composite parent, final boolean suppressLabel, final boolean ignoreLeftMarginHint) {
        Composite tableComposite;
        PropertyEditorPart part = this.getPart();
        IModelElement element = part.getLocalModelElement();
        final ListProperty property = (ListProperty)part.getProperty();
        boolean isReadOnly = part.isReadOnly();
        boolean showHeader = part.getRenderingHint("show.header", true);
        final SapphireActionGroup actions = this.getActions();
        SapphireActionPresentationManager actionPresentationManager = this.getActionPresentationManager();
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(actionPresentationManager);
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Assist"));
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Jump"));
        SapphireMenuActionPresentation menuActionsPresentation = new SapphireMenuActionPresentation(actionPresentationManager);
        menuActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Assist"));
        menuActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Jump"));
        Composite mainComposite = this.createMainComposite(parent, new PropertyEditorRenderer.CreateMainCompositeDelegate(this, part){

            public boolean getShowLabel() {
                return suppressLabel ? false : super.getShowLabel();
            }

            public int getLeftMargin() {
                return ignoreLeftMarginHint ? 0 : super.getLeftMargin();
            }
        });
        mainComposite.setLayout((Layout)GridLayoutUtil.glayout(isReadOnly ? 1 : 2, 0, 0, 0, 0));
        if (this.decorator == null) {
            tableComposite = new Composite(mainComposite, 0);
            tableComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
            tableComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
            this.context.adapt((Control)tableComposite);
            this.decorator = this.createDecorator(tableComposite);
            this.decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
            this.decorator.addEditorControl((Control)tableComposite);
        } else {
            tableComposite = mainComposite;
        }
        this.decorator.addEditorControl((Control)mainComposite);
        final ArrayList<ValueProperty> columnProperties = new ArrayList<ValueProperty>();
        for (ModelProperty childProperty : part.getChildProperties()) {
            if (!(childProperty instanceof ValueProperty)) continue;
            columnProperties.add((ValueProperty)childProperty);
        }
        final Composite tableParentComposite = new Composite(tableComposite, 0);
        tableParentComposite.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdfill(), 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableParentComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = new TableViewer(tableParentComposite, 67586);
        this.table = this.tableViewer.getTable();
        this.context.adapt((Control)this.table);
        this.decorator.addEditorControl((Control)this.table);
        ArrayList relatedControls = new ArrayList();
        this.table.setData("related-controls", relatedControls);
        this.table.addListener(41, new org.eclipse.swt.widgets.Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                event.height = Math.max(event.height, 18);
            }
        });
        this.columnHandlers = new ArrayList<ColumnHandler>();
        ColumnViewerEditorActivationStrategy activationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                int columnIndex = ((ViewerCell)event.getSource()).getColumnIndex();
                ColumnHandler columnHandler = DefaultListPropertyEditorRenderer.this.getColumnHandler(columnIndex);
                return columnHandler.isEditorActivationEvent(event);
            }
        };
        TableViewerEditor.create((TableViewer)this.tableViewer, null, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)20);
        this.table.setHeaderVisible(showHeader);
        this.selectionProvider = new SelectionProvider(this.tableViewer);
        final ListSelectionService selectionService = part.service(ListSelectionService.class);
        this.selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                selectionService.select(DefaultListPropertyEditorRenderer.this.getSelectedElements());
            }
        });
        final Listener selectionServiceListener = new Listener(){

            public void handle(Event event) {
                DefaultListPropertyEditorRenderer.this.setSelectedElements(((ListSelectionService.ListSelectionChangedEvent)event).after());
            }
        };
        selectionService.attach(selectionServiceListener);
        this.addOnDisposeOperation(new Runnable(){

            public void run() {
                selectionService.detach(selectionServiceListener);
            }
        });
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                DefaultListPropertyEditorRenderer.this.handleTableFocusGainedEvent();
            }
        });
        this.refreshOperation = new Runnable(){
            boolean running = false;

            public void run() {
                if (DefaultListPropertyEditorRenderer.this.table.isDisposed()) {
                    return;
                }
                if (this.running) {
                    return;
                }
                this.running = true;
                try {
                    DefaultListPropertyEditorRenderer.this.tableViewer.refresh();
                    DefaultListPropertyEditorRenderer.this.table.notifyListeners(13, null);
                    tableParentComposite.layout();
                }
                finally {
                    this.running = false;
                }
            }
        };
        this.binding = new AbstractBinding(this.getPart(), this.context, (Control)this.table){

            protected void doUpdateModel() {
            }

            protected void doUpdateTarget() {
                DefaultListPropertyEditorRenderer.this.refreshOperation.run();
            }
        };
        this.table.setData("binding", (Object)this.binding);
        boolean showImages = true;
        String columnWidthsHint = part.getRenderingHint("column.widths", "");
        StringTokenizer columnWidthsHintTokenizer = new StringTokenizer(columnWidthsHint, ",");
        for (ValueProperty memberProperty : columnProperties) {
            String columnWidthHint;
            String[] columnWidthHintSplit;
            final TableViewerColumn col2 = new TableViewerColumn(this.tableViewer, 0);
            PropertyEditorDef childPropertyEditorDef = part.definition().getChildPropertyEditor((ModelProperty)memberProperty);
            if (childPropertyEditorDef == null) {
                String label = memberProperty.getLabel(false, CapitalizationType.TITLE_STYLE, false);
                col2.getColumn().setText(label);
            } else {
                final MutableReference labelFunctionResultRef = new MutableReference();
                Runnable updateLabelOp = new Runnable(){

                    public void run() {
                        String label = (String)((FunctionResult)labelFunctionResultRef.get()).value();
                        label = LabelTransformer.transform((String)label, (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false);
                        col2.getColumn().setText(label);
                    }
                };
                final FunctionResult labelFunctionResult = part.initExpression(element, (Function)childPropertyEditorDef.getLabel().getContent(), String.class, (Function)Literal.create((Object)memberProperty.getLabel(false, CapitalizationType.NO_CAPS, true)), updateLabelOp);
                labelFunctionResultRef.set((Object)labelFunctionResult);
                updateLabelOp.run();
                this.addOnDisposeOperation(new Runnable(){

                    public void run() {
                        labelFunctionResult.dispose();
                    }
                });
            }
            ColumnWeightData columnWeightData = null;
            if (columnWidthsHintTokenizer.hasMoreTokens() && ((columnWidthHintSplit = (columnWidthHint = columnWidthsHintTokenizer.nextToken()).split(":")).length == 1 || columnWidthHintSplit.length == 2)) {
                try {
                    int minColumnWidth = Integer.parseInt(columnWidthHintSplit[0].trim());
                    int columnWeight = columnWidthHintSplit.length == 2 ? Integer.parseInt(columnWidthHintSplit[1].trim()) : 0;
                    columnWeightData = new ColumnWeightData(columnWeight, minColumnWidth, true);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (columnWeightData == null) {
                columnWeightData = new ColumnWeightData(1, 100, true);
            }
            tableColumnLayout.setColumnData((Widget)col2.getColumn(), columnWeightData);
            final ColumnHandler columnHandler = this.createColumnHandler(this.columnHandlers, memberProperty, showImages, childPropertyEditorDef);
            showImages = false;
            col2.setLabelProvider(columnHandler.getLabelProvider());
            col2.setEditingSupport((EditingSupport)columnHandler.getEditingSupport());
            final TableColumn tableColumn = col2.getColumn();
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TableColumn currentSortColumn = DefaultListPropertyEditorRenderer.this.table.getSortColumn();
                    if (currentSortColumn != tableColumn) {
                        DefaultListPropertyEditorRenderer.this.table.setSortColumn(tableColumn);
                        DefaultListPropertyEditorRenderer.this.table.setSortDirection(1024);
                        DefaultListPropertyEditorRenderer.this.tableViewer.setComparator((ViewerComparator)new TableSorter(columnHandler, 1024));
                    } else {
                        int currentSortDirection = DefaultListPropertyEditorRenderer.this.table.getSortDirection();
                        if (currentSortDirection == 1024) {
                            DefaultListPropertyEditorRenderer.this.table.setSortDirection(128);
                            DefaultListPropertyEditorRenderer.this.tableViewer.setComparator((ViewerComparator)new TableSorter(columnHandler, 128));
                        } else {
                            DefaultListPropertyEditorRenderer.this.table.setSortColumn(null);
                            DefaultListPropertyEditorRenderer.this.tableViewer.setComparator(null);
                        }
                    }
                    for (SapphireAction action : actions.getActions()) {
                        for (SapphireActionHandler handler : action.getActiveHandlers()) {
                            if (!(handler instanceof SapphirePropertyEditorActionHandler)) continue;
                            ((SapphirePropertyEditorActionHandler)handler).refreshEnablementState();
                        }
                    }
                }
            });
        }
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ModelElementList<IModelElement> list = DefaultListPropertyEditorRenderer.this.getList();
                LinkedHashMap<IModelElement, TableRow> rows = new LinkedHashMap<IModelElement, TableRow>();
                for (IModelElement element : list) {
                    TableRow row = null;
                    if (DefaultListPropertyEditorRenderer.this.rows != null) {
                        row = (TableRow)DefaultListPropertyEditorRenderer.this.rows.remove(element);
                    }
                    if (row == null) {
                        row = new TableRow(element);
                    }
                    rows.put(element, row);
                }
                if (DefaultListPropertyEditorRenderer.this.rows != null) {
                    for (TableRow row : DefaultListPropertyEditorRenderer.this.rows.values()) {
                        row.dispose();
                    }
                }
                DefaultListPropertyEditorRenderer.this.rows = rows;
                return rows.values().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
                for (TableRow row : DefaultListPropertyEditorRenderer.this.rows.values()) {
                    row.dispose();
                }
            }
        };
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.tableViewer.setInput((Object)contentProvider);
        this.table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                DefaultListPropertyEditorRenderer.this.handleTableTraverseEvent(event);
            }
        });
        if (!isReadOnly) {
            if (this.exposeAddAction) {
                final SapphireAction addAction = actions.getAction("Sapphire.Add");
                final ArrayList addActionHandlers = new ArrayList();
                final Listener addActionHandlerListener = new Listener(){

                    public void handle(Event event) {
                        if (event instanceof SapphireActionHandler.PostExecuteEvent) {
                            if (DefaultListPropertyEditorRenderer.this.table.isDisposed()) {
                                return;
                            }
                            IModelElement newListElement = (IModelElement)((SapphireActionHandler.PostExecuteEvent)event).getResult();
                            if (newListElement != null) {
                                DefaultListPropertyEditorRenderer.this.refreshOperation.run();
                                TableRow row = (TableRow)DefaultListPropertyEditorRenderer.this.rows.get(newListElement);
                                DefaultListPropertyEditorRenderer.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)row), true);
                                DefaultListPropertyEditorRenderer.this.tableViewer.editElement((Object)row, 0);
                                DefaultListPropertyEditorRenderer.this.table.notifyListeners(13, null);
                            }
                        }
                    }
                };
                final PossibleTypesService possibleTypesService = (PossibleTypesService)element.service((ModelProperty)property, PossibleTypesService.class);
                final Runnable refreshAddActionHandlersOp = new Runnable(){

                    public void run() {
                        addAction.removeHandlers(addActionHandlers);
                        for (SapphireActionHandler addActionHandler : addActionHandlers) {
                            addActionHandler.dispose();
                        }
                        for (ModelElementType memberType : possibleTypesService.types()) {
                            AddActionHandler addActionHandler = new AddActionHandler(memberType);
                            ((SapphireActionHandler)addActionHandler).init(addAction, null);
                            addActionHandler.attach(addActionHandlerListener);
                            addActionHandlers.add(addActionHandler);
                            addAction.addHandler(addActionHandler);
                        }
                    }
                };
                refreshAddActionHandlersOp.run();
                final Listener possibleTypesServiceListener = new Listener(){

                    public void handle(Event event) {
                        refreshAddActionHandlersOp.run();
                    }
                };
                possibleTypesService.attach(possibleTypesServiceListener);
                this.addOnDisposeOperation(new Runnable(){

                    public void run() {
                        addAction.removeHandlers(addActionHandlers);
                        for (SapphireActionHandler addActionHandler : addActionHandlers) {
                            addActionHandler.dispose();
                        }
                        possibleTypesService.detach(possibleTypesServiceListener);
                    }
                });
            }
            if (this.exposeDeleteAction) {
                final SapphireAction deleteAction = actions.getAction("Sapphire.Delete");
                final DeleteActionHandler deleteActionHandler = new DeleteActionHandler();
                ((SapphireActionHandler)deleteActionHandler).init(deleteAction, null);
                deleteAction.addHandler(deleteActionHandler);
                this.addOnDisposeOperation(new Runnable(){

                    public void run() {
                        deleteAction.removeHandler(deleteActionHandler);
                    }
                });
            }
            if (!property.hasAnnotation(FixedOrderList.class)) {
                final SapphireAction moveUpAction = actions.getAction("Sapphire.Move.Up");
                final MoveUpActionHandler moveUpActionHandler = new MoveUpActionHandler();
                ((SapphireActionHandler)moveUpActionHandler).init(moveUpAction, null);
                moveUpAction.addHandler(moveUpActionHandler);
                this.addOnDisposeOperation(new Runnable(){

                    public void run() {
                        moveUpAction.removeHandler(moveUpActionHandler);
                    }
                });
                final SapphireAction moveDownAction = actions.getAction("Sapphire.Move.Down");
                final MoveDownActionHandler moveDownActionHandler = new MoveDownActionHandler();
                ((SapphireActionHandler)moveDownActionHandler).init(moveDownAction, null);
                moveDownAction.addHandler(moveDownActionHandler);
                this.addOnDisposeOperation(new Runnable(){

                    public void run() {
                        moveDownAction.removeHandler(moveDownActionHandler);
                    }
                });
                Listener moveActionHandlerListener = new Listener(){

                    public void handle(Event event) {
                        if (event instanceof SapphireActionHandler.PostExecuteEvent) {
                            DefaultListPropertyEditorRenderer.this.refreshOperation.run();
                            IModelElement element = DefaultListPropertyEditorRenderer.this.getSelectedElement();
                            TableItem[] items = DefaultListPropertyEditorRenderer.this.table.getItems();
                            int i = 0;
                            while (i < items.length) {
                                if (items[i].getData() == element) {
                                    DefaultListPropertyEditorRenderer.this.table.setSelection(i);
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                };
                moveUpAction.attach(moveActionHandlerListener);
                moveDownAction.attach(moveActionHandlerListener);
                ModelElementsTransfer transfer = new ModelElementsTransfer(this.getModelElement().type().getModelElementClass().getClassLoader());
                Transfer[] transfers = new Transfer[]{transfer};
                DragSource dragSource = new DragSource((Control)this.table, 2);
                dragSource.setTransfer(transfers);
                final ArrayList dragElements = new ArrayList();
                dragSource.addDragListener(new DragSourceListener(){

                    public void dragStart(DragSourceEvent event) {
                        if (DefaultListPropertyEditorRenderer.this.tableViewer.getComparator() == null) {
                            dragElements.addAll(DefaultListPropertyEditorRenderer.this.getSelectedElements());
                            event.doit = true;
                        } else {
                            event.doit = false;
                        }
                    }

                    public void dragSetData(DragSourceEvent event) {
                        event.data = dragElements;
                    }

                    public void dragFinished(DragSourceEvent event) {
                        block6: {
                            if (event.detail == 2) {
                                boolean droppedIntoAnotherEditor = false;
                                for (IModelElement dragElement : dragElements) {
                                    if (dragElement.disposed()) continue;
                                    droppedIntoAnotherEditor = true;
                                    break;
                                }
                                if (droppedIntoAnotherEditor) {
                                    try {
                                        IModelElement selectionPostDelete = MiscUtil.findSelectionPostDelete(DefaultListPropertyEditorRenderer.this.getList(), dragElements);
                                        for (IModelElement dragElement : dragElements) {
                                            ModelElementList dragElementContainer = (ModelElementList)dragElement.parent();
                                            dragElementContainer.remove((Object)dragElement);
                                        }
                                        DefaultListPropertyEditorRenderer.this.setSelectedElement(selectionPostDelete);
                                    }
                                    catch (Exception e) {
                                        EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                                        if (editFailedException != null) break block6;
                                        SapphireUiFrameworkPlugin.log(e);
                                    }
                                }
                            }
                        }
                        dragElements.clear();
                    }
                });
                DropTarget target = new DropTarget((Control)this.table, 2);
                target.setTransfer(transfers);
                target.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void dragOver(DropTargetEvent event) {
                        if (event.item != null) {
                            TableItem dragOverItem = (TableItem)event.item;
                            Point pt = dragOverItem.getDisplay().map(null, (Control)DefaultListPropertyEditorRenderer.this.table, event.x, event.y);
                            Rectangle bounds = dragOverItem.getBounds();
                            event.feedback = pt.y < bounds.y + bounds.height / 2 ? 2 : 4;
                        }
                        event.feedback |= 8;
                    }

                    public void drop(DropTargetEvent event) {
                        int position;
                        if (event.data == null) {
                            event.detail = 0;
                            return;
                        }
                        List droppedElements = (List)event.data;
                        SortedSet possibleTypesService = ((PossibleTypesService)property.service(PossibleTypesService.class)).types();
                        for (IModelElement droppedElement : droppedElements) {
                            if (possibleTypesService.contains(droppedElement.type())) continue;
                            event.detail = 0;
                            return;
                        }
                        ModelElementList<IModelElement> list = DefaultListPropertyEditorRenderer.this.getList();
                        if (event.item == null) {
                            position = list.size();
                        } else {
                            TableItem dropTargetItem = (TableItem)event.item;
                            TableRow dropTargetRow = (TableRow)dropTargetItem.getData();
                            IModelElement dropTargetElement = dropTargetRow.element();
                            Point pt = DefaultListPropertyEditorRenderer.this.table.getDisplay().map(null, (Control)DefaultListPropertyEditorRenderer.this.table, event.x, event.y);
                            Rectangle bounds = dropTargetItem.getBounds();
                            position = list.indexOf((Object)dropTargetElement);
                            if (pt.y >= bounds.y + bounds.height / 2) {
                                ++position;
                            }
                        }
                        try {
                            for (IModelElement dragElement : dragElements) {
                                ModelElementList dragElementContainer = (ModelElementList)dragElement.parent();
                                if (dragElementContainer == list && dragElementContainer.indexOf((Object)dragElement) < position) {
                                    --position;
                                }
                                dragElementContainer.remove((Object)dragElement);
                            }
                            ArrayList<IModelElement> newSelection = new ArrayList<IModelElement>();
                            for (IModelElement droppedElement : droppedElements) {
                                IModelElement insertedElement = list.insert(droppedElement.type(), position);
                                insertedElement.copy(droppedElement);
                                newSelection.add(insertedElement);
                                ++position;
                            }
                            DefaultListPropertyEditorRenderer.this.tableViewer.refresh();
                            DefaultListPropertyEditorRenderer.this.setSelectedElements(newSelection);
                        }
                        catch (Exception e) {
                            EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                            if (editFailedException == null) {
                                SapphireUiFrameworkPlugin.log(e);
                            }
                            event.detail = 0;
                        }
                    }
                });
            }
            ToolBar toolbar = new ToolBar(mainComposite, 0x800200);
            toolbar.setLayoutData((Object)GridLayoutUtil.gdvfill());
            toolBarActionsPresentation.setToolBar(toolbar);
            toolBarActionsPresentation.render();
            this.addControl((Control)toolbar);
            this.context.adapt((Control)toolbar);
            this.decorator.addEditorControl((Control)toolbar);
            Menu menu = new Menu((Control)this.table);
            this.table.setMenu(menu);
            menuActionsPresentation.setMenu(menu);
            menuActionsPresentation.render();
        }
        HyperlinkTable hyperlinkTable = new HyperlinkTable(this.table, actions);
        hyperlinkTable.setController(new HyperlinkTable.Controller(){

            public boolean isHyperlinkEnabled(TableItem item, int column) {
                SapphireActionHandler jumpHandler = this.getJumpHandler(item, column);
                if (jumpHandler != null) {
                    return jumpHandler.isEnabled();
                }
                return false;
            }

            public void handleHyperlinkEvent(TableItem item, int column) {
                SapphireActionHandler jumpHandler = this.getJumpHandler(item, column);
                if (jumpHandler != null) {
                    jumpHandler.execute(DefaultListPropertyEditorRenderer.this.context);
                }
            }

            private SapphireActionHandler getJumpHandler(TableItem item, int column) {
                IModelElement element = ((TableRow)item.getData()).element();
                ValueProperty property = (ValueProperty)columnProperties.get(column);
                PropertyEditorPart propertyEditor = DefaultListPropertyEditorRenderer.this.getPart().getChildPropertyEditor(element, (ModelProperty)property);
                SapphireActionGroup actions = propertyEditor.getActions();
                return actions.getAction("Sapphire.Jump").getFirstActiveHandler();
            }
        });
        SwtUtil.suppressDashedTableEntryBorder(this.table);
        this.addControl((Control)this.table);
        return this.table;
    }

    @Override
    protected boolean canScaleVertically() {
        return true;
    }

    public final PropertyEditorAssistDecorator getDecorator() {
        return this.decorator;
    }

    public final void setDecorator(PropertyEditorAssistDecorator decorator) {
        this.decorator = decorator;
    }

    public final boolean isAddActionDesired() {
        return this.exposeAddAction;
    }

    public final void setAddActionDesired(boolean exposeAddAction) {
        this.exposeAddAction = exposeAddAction;
    }

    public final boolean isDeleteActionDesired() {
        return this.exposeDeleteAction;
    }

    public final void setDeleteActionDesired(boolean exposeDeleteAction) {
        this.exposeDeleteAction = exposeDeleteAction;
    }

    public final IModelElement getSelectedElement() {
        IStructuredSelection sel = (IStructuredSelection)this.selectionProvider.getSelection();
        return (IModelElement)sel.getFirstElement();
    }

    public final List<IModelElement> getSelectedElements() {
        IStructuredSelection sel = (IStructuredSelection)this.selectionProvider.getSelection();
        ReadOnlyListFactory elements = ReadOnlyListFactory.create();
        Iterator itr = sel.iterator();
        while (itr.hasNext()) {
            elements.add((Object)((IModelElement)itr.next()));
        }
        return elements.export();
    }

    public final void setSelectedElement(IModelElement element) {
        this.setSelectedElements(element == null ? Collections.emptyList() : Collections.singletonList(element));
    }

    public final void setSelectedElements(List<IModelElement> elements) {
        if (!CollectionsUtil.equalsBasedOnEntryIdentity(this.getSelectedElements(), elements)) {
            ReadOnlyListFactory rows = ReadOnlyListFactory.create();
            for (IModelElement element : elements) {
                TableRow row = this.rows.get(element);
                if (row == null) continue;
                rows.add((Object)row);
            }
            this.tableViewer.setSelection((ISelection)new StructuredSelection(rows.export()));
        }
    }

    private final List<TableRow> getSelectedRows() {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        Iterator itr = this.selectionProvider.getSelectedRows().iterator();
        while (itr.hasNext()) {
            rows.add((TableRow)itr.next());
        }
        return rows;
    }

    public final void setFocusOnTable() {
        this.table.setFocus();
    }

    @Override
    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        this.refreshOperation.run();
    }

    @Override
    protected void handleListElementChangedEvent(final Event event) {
        super.handleListElementChangedEvent(event);
        if (!this.table.isDisposed()) {
            this.table.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    DefaultListPropertyEditorRenderer.this.update(event instanceof ElementEvent ? ((ElementEvent)event).element() : ((PropertyEvent)event).element());
                    DefaultListPropertyEditorRenderer.this.binding.updateTargetAttributes();
                }
            });
        }
    }

    protected void handleTableFocusGainedEvent() {
        if (this.tableViewer.getSelection().isEmpty() && this.table.getItemCount() > 0) {
            Object firstItem = this.table.getItem(0).getData();
            this.tableViewer.setSelection((ISelection)new StructuredSelection(firstItem));
        }
    }

    private void handleTableTraverseEvent(TraverseEvent event) {
        if (event.detail == 4) {
            event.doit = false;
            IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
            if (selection.size() == 1) {
                TableRow row = (TableRow)selection.getFirstElement();
                int firstEditableColumn = -1;
                int i = 0;
                int n = this.getColumnCount();
                while (i < n) {
                    ColumnHandler handler = this.getColumnHandler(i);
                    if (handler.getEditingSupport().canEdit(row)) {
                        firstEditableColumn = i;
                        break;
                    }
                    ++i;
                }
                if (firstEditableColumn != -1) {
                    this.tableViewer.editElement((Object)row, firstEditableColumn);
                }
            }
        }
    }

    @Override
    protected void handleFocusReceivedEvent() {
        this.table.setFocus();
    }

    private ColumnHandler createColumnHandler(List<ColumnHandler> allColumnHandlers, ValueProperty property, boolean showImages, PropertyEditorDef childPropertyEditorDef) {
        ColumnHandler columnHandler;
        if (property.isOfType(Boolean.class)) {
            columnHandler = new BooleanPropertyColumnHandler(this.context, this.tableViewer, this.selectionProvider, this.getPart(), allColumnHandlers, property, showImages);
        } else {
            String style;
            PopUpListFieldStyle popUpListFieldPresentationStyle = null;
            if (property.isOfType(Enum.class)) {
                popUpListFieldPresentationStyle = PopUpListFieldStyle.STRICT;
            } else if (childPropertyEditorDef != null && (style = childPropertyEditorDef.getStyle().getText()) != null && style.startsWith("Sapphire.PropertyEditor.PopUpListField")) {
                if (style.equals("Sapphire.PropertyEditor.PopUpListField")) {
                    PossibleValues possibleValuesAnnotation = (PossibleValues)property.getAnnotation(PossibleValues.class);
                    popUpListFieldPresentationStyle = possibleValuesAnnotation != null ? (possibleValuesAnnotation.invalidValueSeverity() == Status.Severity.ERROR ? PopUpListFieldStyle.STRICT : PopUpListFieldStyle.EDITABLE) : PopUpListFieldStyle.EDITABLE;
                } else if (style.equals("Sapphire.PropertyEditor.PopUpListField.Editable")) {
                    popUpListFieldPresentationStyle = PopUpListFieldStyle.EDITABLE;
                } else if (style.equals("Sapphire.PropertyEditor.PopUpListField.Strict")) {
                    popUpListFieldPresentationStyle = PopUpListFieldStyle.STRICT;
                }
            }
            columnHandler = popUpListFieldPresentationStyle != null ? new PopUpListFieldColumnPresentation(this.context, this.tableViewer, this.selectionProvider, this.getPart(), allColumnHandlers, property, showImages, popUpListFieldPresentationStyle) : new ColumnHandler(this.context, this.tableViewer, this.selectionProvider, this.getPart(), allColumnHandlers, property, showImages);
        }
        allColumnHandlers.add(columnHandler);
        return columnHandler;
    }

    private int getColumnCount() {
        return this.table.getColumnCount();
    }

    private ColumnHandler getColumnHandler(int column) {
        return this.columnHandlers.get(column);
    }

    private void update(IModelElement element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        TableRow row = this.rows.get(element);
        if (row != null) {
            this.update(row);
        }
    }

    private void update(TableRow row) {
        if (row == null) {
            throw new IllegalArgumentException();
        }
        this.tableViewer.update((Object)row, null);
    }

    private static abstract class AbstractColumnEditingSupport
    extends EditingSupport {
        protected final ColumnHandler columnHandler;

        public AbstractColumnEditingSupport(ColumnHandler columnHandler) {
            super((ColumnViewer)columnHandler.getTableViewer());
            this.columnHandler = columnHandler;
        }

        public boolean canEdit(Object obj) {
            PropertyEditorPart propertyEditor;
            ValueProperty property;
            IModelElement element = ((TableRow)obj).element();
            boolean canEdit = element.enabled((ModelProperty)(property = this.columnHandler.getProperty())) ? !(propertyEditor = this.columnHandler.getListPropertyEditor().getChildPropertyEditor(element, (ModelProperty)property)).isReadOnly() : false;
            return canEdit;
        }

        public abstract CellEditor getCellEditor(Object var1);

        public abstract Object getValue(Object var1);

        public abstract void setValue(Object var1, Object var2);
    }

    private final class AddActionHandler
    extends SapphirePropertyEditorActionHandler {
        private final ModelElementType type;

        public AddActionHandler(ModelElementType type) {
            this.type = type;
        }

        public void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            ImageData typeSpecificAddImage = this.type.image();
            if (typeSpecificAddImage != null) {
                this.addImage(typeSpecificAddImage);
            }
            this.setLabel(this.type.getLabel(false, CapitalizationType.TITLE_STYLE, false));
        }

        protected Object run(SapphireRenderingContext context) {
            return DefaultListPropertyEditorRenderer.this.getList().insert(this.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BooleanPropertyColumnHandler
    extends ColumnHandler {
        private static final int CHECKBOX_IMAGE_WIDTH = 16;
        private static final int CHECKBOX_IMAGE_HEIGHT = 16;

        public BooleanPropertyColumnHandler(SapphireRenderingContext context, TableViewer tableViewer, SelectionProvider selectionProvider, PropertyEditorPart listPropertyEditor, List<ColumnHandler> allColumnHandlers, ValueProperty property, boolean showElementImage) {
            super(context, tableViewer, selectionProvider, listPropertyEditor, allColumnHandlers, property, showElementImage);
        }

        @Override
        protected CellLabelProvider createLabelProvider() {
            return new OwnerDrawLabelProvider(){

                protected void erase(org.eclipse.swt.widgets.Event event, Object element) {
                }

                protected void measure(org.eclipse.swt.widgets.Event event, Object element) {
                }

                protected void paint(org.eclipse.swt.widgets.Event event, Object object) {
                    TableItem item = (TableItem)event.item;
                    IModelElement element = ((TableRow)item.getData()).element();
                    if (element.enabled((ModelProperty)BooleanPropertyColumnHandler.this.getProperty())) {
                        boolean value = BooleanPropertyColumnHandler.this.getPropertyValueAsBoolean(element);
                        Image image = BooleanPropertyColumnHandler.this.getImageCache().getImage(value ? IMG_CHECKBOX_ON : IMG_CHECKBOX_OFF);
                        Rectangle cellBounds = item.getBounds(event.index);
                        Rectangle imageBounds = image.getBounds();
                        int x = event.x + (cellBounds.width - imageBounds.width) / 2;
                        int y = event.y + (cellBounds.height - imageBounds.height) / 2;
                        event.gc.drawImage(image, x, y);
                    }
                }
            };
        }

        @Override
        protected AbstractColumnEditingSupport createEditingSupport() {
            return new AbstractColumnEditingSupport(this){
                private CheckboxCellEditor cellEditor;

                public CellEditor getCellEditor(Object element) {
                    if (this.cellEditor == null) {
                        this.cellEditor = new CheckboxCellEditor((Composite)BooleanPropertyColumnHandler.this.getTable());
                    }
                    return this.cellEditor;
                }

                public Object getValue(Object obj) {
                    Value<?> value = BooleanPropertyColumnHandler.this.getPropertyValue(((TableRow)obj).element());
                    Boolean val = (Boolean)value.getContent();
                    return val != null ? val : Boolean.FALSE;
                }

                public void setValue(Object obj, Object value) {
                    String str = String.valueOf((Boolean)value);
                    BooleanPropertyColumnHandler.this.setPropertyValue(((TableRow)obj).element(), str);
                }
            };
        }

        @Override
        public boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            if (event.eventType == 2) {
                Rectangle cellBounds = ((ViewerCell)event.getSource()).getBounds();
                Rectangle checkBoxBounds = new Rectangle(cellBounds.x + (cellBounds.width - 16) / 2, cellBounds.y + (cellBounds.height - 16) / 2, 16, 16);
                MouseEvent evt = (MouseEvent)event.sourceEvent;
                return checkBoxBounds.contains(evt.x, evt.y);
            }
            return false;
        }

        @Override
        public int comparePropertyValues(IModelElement x, IModelElement y) {
            boolean b;
            boolean a = this.getPropertyValueAsBoolean(x);
            if (a == (b = this.getPropertyValueAsBoolean(y))) {
                return 0;
            }
            if (a) {
                return -1;
            }
            return 1;
        }

        private boolean getPropertyValueAsBoolean(IModelElement element) {
            Value<?> value = this.getPropertyValue(element);
            Boolean val = (Boolean)value.getContent();
            return val != null && val != false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnHandler {
        protected final SapphireRenderingContext context;
        protected final Table table;
        protected final TableViewer tableViewer;
        protected final SelectionProvider selectionProvider;
        protected final PropertyEditorPart listPropertyEditor;
        protected final List<ColumnHandler> allColumnHandlers;
        protected final ValueProperty property;
        protected final boolean showElementImage;
        protected final Collator collator;
        private CellLabelProvider labelProvider;
        private AbstractColumnEditingSupport editingSupport;

        public ColumnHandler(SapphireRenderingContext context, TableViewer tableViewer, SelectionProvider selectionProvider, PropertyEditorPart listPropertyEditor, List<ColumnHandler> allColumnHandlers, ValueProperty property, boolean showElementImage) {
            this.context = context;
            this.table = tableViewer.getTable();
            this.tableViewer = tableViewer;
            this.selectionProvider = selectionProvider;
            this.listPropertyEditor = listPropertyEditor;
            this.allColumnHandlers = allColumnHandlers;
            this.property = property;
            this.showElementImage = showElementImage;
            this.collator = Collator.getInstance();
        }

        public final SapphireRenderingContext getContext() {
            return this.context;
        }

        public final Table getTable() {
            return this.table;
        }

        public final TableViewer getTableViewer() {
            return this.tableViewer;
        }

        public final SelectionProvider getSelectionProvider() {
            return this.selectionProvider;
        }

        public final PropertyEditorPart getListPropertyEditor() {
            return this.listPropertyEditor;
        }

        public final SapphireImageCache getImageCache() {
            return this.listPropertyEditor.getImageCache();
        }

        public final boolean isElementImageDesired() {
            return this.showElementImage;
        }

        public final ValueProperty getProperty() {
            return this.property;
        }

        public final Value<?> getPropertyValue(IModelElement element) {
            return element.read(this.property);
        }

        public final void setPropertyValue(IModelElement element, String value) {
            element.write(this.property, (Object)value);
        }

        public final CellLabelProvider getLabelProvider() {
            if (this.labelProvider == null) {
                this.labelProvider = this.createLabelProvider();
            }
            return this.labelProvider;
        }

        protected CellLabelProvider createLabelProvider() {
            return new DefaultColumnLabelProvider(this);
        }

        public final AbstractColumnEditingSupport getEditingSupport() {
            if (this.editingSupport == null && !this.property.isReadOnly()) {
                this.editingSupport = this.createEditingSupport();
            }
            return this.editingSupport;
        }

        protected AbstractColumnEditingSupport createEditingSupport() {
            return new AbstractColumnEditingSupport(this){
                private SapphireTextCellEditor cellEditor;

                public CellEditor getCellEditor(Object obj) {
                    if (this.cellEditor != null) {
                        this.cellEditor.dispose();
                    }
                    IModelElement element = ((TableRow)obj).element();
                    ValueProperty property = ColumnHandler.this.property;
                    PropertyEditorPart propertyEditor = ColumnHandler.this.getListPropertyEditor().getChildPropertyEditor(element, (ModelProperty)property);
                    SapphireActionGroup actions = propertyEditor.getActions();
                    int style = ColumnHandler.this.getTable().getLinesVisible() ? 0 : 2048;
                    this.cellEditor = new SapphireTextCellEditor(ColumnHandler.this.getContext(), (StructuredViewer)ColumnHandler.this.getTableViewer(), ColumnHandler.this.getSelectionProvider(), element, ColumnHandler.this.getProperty(), actions, style);
                    if (ColumnHandler.this.isElementImageDesired()) {
                        this.cellEditor.setHorizonalIndent(3);
                    }
                    return this.cellEditor;
                }

                public Object getValue(Object obj) {
                    return ColumnHandler.this.getPropertyValue(((TableRow)obj).element());
                }

                public void setValue(Object obj, Object value) {
                    ColumnHandler.this.setPropertyValue(((TableRow)obj).element(), (String)value);
                }
            };
        }

        public boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            return event.eventType == 3 || event.eventType == 4 || event.eventType == 5;
        }

        public int comparePropertyValues(IModelElement x, IModelElement y) {
            boolean bEmpty;
            String a = this.getPropertyValue(x).getText();
            String b = this.getPropertyValue(y).getText();
            boolean aEmpty = a == null || a.trim().length() == 0;
            boolean bl = bEmpty = b == null || b.trim().length() == 0;
            if (aEmpty && bEmpty) {
                return 0;
            }
            if (aEmpty) {
                return 1;
            }
            if (bEmpty) {
                return -1;
            }
            return this.collator.compare(a, b);
        }

        public boolean isEmptyTextLabelDesired(IModelElement element) {
            if (this.allColumnHandlers.get(0) == this) {
                for (ColumnHandler handler : this.allColumnHandlers) {
                    if (!(handler instanceof BooleanPropertyColumnHandler)) continue;
                    return false;
                }
                for (ColumnHandler handler : this.allColumnHandlers) {
                    if (handler.getPropertyValue(element).getText() == null) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private class DefaultColumnLabelProvider
    extends ColumnLabelProvider {
        private final ColumnHandler columnHandler;
        private final ValueLabelProvider valueLabelProvider;

        public DefaultColumnLabelProvider(ColumnHandler columnHandler) {
            this.columnHandler = columnHandler;
            this.valueLabelProvider = new ValueLabelProvider(DefaultListPropertyEditorRenderer.this.getPart(), columnHandler.getProperty());
        }

        public String getText(Object obj) {
            IModelElement element = ((TableRow)obj).element();
            Value<?> value = this.columnHandler.getPropertyValue(element);
            String str = this.valueLabelProvider.getText(value.getText());
            if (str == null) {
                str = this.columnHandler.isEmptyTextLabelDesired(element) ? Resources.emptyRowIndicator : "";
            }
            return str;
        }

        public Image getImage(Object obj) {
            if (this.columnHandler.isElementImageDesired()) {
                IModelElement element;
                Value<?> value;
                ImageData valueImageData;
                TableRow row = (TableRow)obj;
                Image image = row.image();
                if (image == null && (valueImageData = this.valueLabelProvider.getImageData((value = this.columnHandler.getPropertyValue(element = row.element())).getText())) != null) {
                    image = DefaultListPropertyEditorRenderer.this.getPart().getImageCache().getImage(valueImageData, element.validation().severity());
                }
                return image;
            }
            return null;
        }

        public Color getForeground(Object obj) {
            Value value = ((TableRow)obj).element().read(this.columnHandler.getProperty());
            if (value.getText(false) == null) {
                return Display.getCurrent().getSystemColor(16);
            }
            return null;
        }
    }

    private final class DeleteActionHandler
    extends SelectionBasedActionHandler {
        private DeleteActionHandler() {
        }

        protected final Object run(SapphireRenderingContext context) {
            List rowsToDelete = DefaultListPropertyEditorRenderer.this.getSelectedRows();
            TableRow selectionPostDelete = (TableRow)MiscUtil.findSelectionPostDelete(DefaultListPropertyEditorRenderer.this.rows.values(), rowsToDelete);
            ModelElementList<IModelElement> list = DefaultListPropertyEditorRenderer.this.getList();
            for (TableRow row : rowsToDelete) {
                list.remove((Object)row.element());
            }
            DefaultListPropertyEditorRenderer.this.refreshOperation.run();
            if (selectionPostDelete != null) {
                DefaultListPropertyEditorRenderer.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)selectionPostDelete));
            }
            return null;
        }

        protected boolean computeEnablementState() {
            if (super.computeEnablementState()) {
                return !DefaultListPropertyEditorRenderer.this.getSelectedElements().isEmpty();
            }
            return false;
        }
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(PropertyEditorPart propertyEditorDefinition) {
            return propertyEditorDefinition.getProperty() instanceof ListProperty;
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, PropertyEditorPart part) {
            return new DefaultListPropertyEditorRenderer(context, part);
        }
    }

    private final class MoveDownActionHandler
    extends SelectionBasedActionHandler {
        private MoveDownActionHandler() {
        }

        protected boolean computeEnablementState() {
            if (super.computeEnablementState() && DefaultListPropertyEditorRenderer.this.getSelectedElements().size() == 1 && DefaultListPropertyEditorRenderer.this.tableViewer.getComparator() == null) {
                IModelElement modelElement = DefaultListPropertyEditorRenderer.this.getSelectedElement();
                ModelElementList<IModelElement> list = DefaultListPropertyEditorRenderer.this.getList();
                return list.indexOf((Object)modelElement) < list.size() - 1;
            }
            return false;
        }

        protected final Object run(SapphireRenderingContext context) {
            IModelElement element = DefaultListPropertyEditorRenderer.this.getSelectedElement();
            DefaultListPropertyEditorRenderer.this.getList().moveDown(element);
            DefaultListPropertyEditorRenderer.this.tableViewer.reveal((Object)element);
            return null;
        }
    }

    private final class MoveUpActionHandler
    extends SelectionBasedActionHandler {
        private MoveUpActionHandler() {
        }

        protected boolean computeEnablementState() {
            if (super.computeEnablementState() && DefaultListPropertyEditorRenderer.this.getSelectedElements().size() == 1 && DefaultListPropertyEditorRenderer.this.tableViewer.getComparator() == null) {
                IModelElement modelElement = DefaultListPropertyEditorRenderer.this.getSelectedElement();
                return DefaultListPropertyEditorRenderer.this.getList().indexOf((Object)modelElement) > 0;
            }
            return false;
        }

        protected final Object run(SapphireRenderingContext context) {
            IModelElement element = DefaultListPropertyEditorRenderer.this.getSelectedElement();
            DefaultListPropertyEditorRenderer.this.getList().moveUp(element);
            DefaultListPropertyEditorRenderer.this.tableViewer.reveal((Object)element);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PopUpListFieldColumnPresentation
    extends ColumnHandler {
        private final PopUpListFieldStyle popUpListFieldStyle;

        public PopUpListFieldColumnPresentation(SapphireRenderingContext context, TableViewer tableViewer, SelectionProvider selectionProvider, PropertyEditorPart listPropertyEditor, List<ColumnHandler> allColumnHandlers, ValueProperty property, boolean showElementImage, PopUpListFieldStyle popUpListFieldStyle) {
            super(context, tableViewer, selectionProvider, listPropertyEditor, allColumnHandlers, property, showElementImage);
            this.popUpListFieldStyle = popUpListFieldStyle;
        }

        @Override
        protected AbstractColumnEditingSupport createEditingSupport() {
            return new AbstractColumnEditingSupport(this){
                private PopUpListFieldCellEditorPresentation cellEditor;

                public CellEditor getCellEditor(Object obj) {
                    if (this.cellEditor != null) {
                        this.cellEditor.dispose();
                    }
                    int style = PopUpListFieldColumnPresentation.this.getTable().getLinesVisible() ? 0 : 2048;
                    this.cellEditor = new PopUpListFieldCellEditorPresentation((StructuredViewer)PopUpListFieldColumnPresentation.this.getTableViewer(), PopUpListFieldColumnPresentation.this.getSelectionProvider(), ((TableRow)obj).element(), PopUpListFieldColumnPresentation.this.getProperty(), PopUpListFieldColumnPresentation.this.popUpListFieldStyle, style);
                    return this.cellEditor;
                }

                public Object getValue(Object obj) {
                    return PopUpListFieldColumnPresentation.this.getPropertyValue(((TableRow)obj).element());
                }

                public void setValue(Object obj, Object value) {
                    PopUpListFieldColumnPresentation.this.setPropertyValue(((TableRow)obj).element(), (String)value);
                }
            };
        }
    }

    private static final class Resources
    extends NLS {
        public static String emptyRowIndicator;

        static {
            Resources.initializeMessages((String)DefaultListPropertyEditorRenderer.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static abstract class SelectionBasedActionHandler
    extends SapphirePropertyEditorActionHandler {
        private SelectionBasedActionHandler() {
        }

        public void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            final ListSelectionService selectionService = action.getPart().service(ListSelectionService.class);
            final Listener selectionListener = new Listener(){

                public void handle(Event event) {
                    SelectionBasedActionHandler.this.refreshEnablementState();
                }
            };
            selectionService.attach(selectionListener);
            this.attach(new Listener(){

                public void handle(Event event) {
                    if (event instanceof DisposeEvent) {
                        selectionService.detach(selectionListener);
                    }
                }
            });
        }
    }

    public static final class SelectionProvider
    implements ISelectionProvider {
        private final TableViewer tableViewer;
        private final Set<ISelectionChangedListener> listeners;
        private ISelection fakeSelection;

        public SelectionProvider(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
            this.listeners = new CopyOnWriteArraySet<ISelectionChangedListener>();
            this.fakeSelection = null;
            this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SelectionProvider.this.notifySelectionChangedListeners();
                }
            });
        }

        public IStructuredSelection getSelectedRows() {
            return (IStructuredSelection)(this.fakeSelection != null ? this.fakeSelection : this.tableViewer.getSelection());
        }

        public ISelection getSelection() {
            ReadOnlyListFactory elements = ReadOnlyListFactory.create();
            for (TableRow row : this.getSelectedRows()) {
                elements.add((Object)row.element());
            }
            return new StructuredSelection(elements.export());
        }

        public void setSelection(ISelection selection) {
            throw new UnsupportedOperationException();
        }

        public void setFakeSelection(ISelection selection) {
            this.fakeSelection = selection;
            this.notifySelectionChangedListeners();
        }

        public final void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add(listener);
        }

        public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        private final void notifySelectionChangedListeners() {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            for (ISelectionChangedListener listener : this.listeners) {
                listener.selectionChanged(event);
            }
        }
    }

    private final class TableRow {
        private final IModelElement element;
        private final ImageService imageService;
        private final Listener listener;

        public TableRow(IModelElement element) {
            this.element = element;
            this.imageService = (ImageService)element.service(ImageService.class);
            if (this.imageService == null) {
                this.listener = null;
            } else {
                this.listener = new Listener(){

                    public void handle(Event event) {
                        DefaultListPropertyEditorRenderer.this.update(TableRow.this);
                    }
                };
                this.imageService.attach(this.listener);
            }
        }

        public IModelElement element() {
            return this.element;
        }

        public Image image() {
            if (this.imageService == null) {
                return null;
            }
            return DefaultListPropertyEditorRenderer.this.getPart().getImageCache().getImage(this.imageService.image(), this.element.validation().severity());
        }

        public void dispose() {
            if (this.imageService != null) {
                this.imageService.detach(this.listener);
            }
        }
    }

    private static final class TableSorter
    extends ViewerComparator {
        private final ColumnHandler columnHandler;
        private final int direction;

        public TableSorter(ColumnHandler columnHandler, int direction) {
            this.columnHandler = columnHandler;
            this.direction = direction;
        }

        public int compare(Viewer viewer, Object x, Object y) {
            int result = this.columnHandler.comparePropertyValues(((TableRow)x).element(), ((TableRow)y).element());
            if (this.direction == 128) {
                result *= -1;
            }
            return result;
        }
    }
}

