/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.net.URL;
import java.util.List;
import org.eclipse.sapphire.modeling.ExtensionsLocator;
import org.eclipse.sapphire.util.ReadOnlyListFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public final class ExtensionsLocatorFactory
extends ExtensionsLocator.Factory {
    public boolean applicable() {
        return FrameworkUtil.getBundle(ExtensionsLocatorFactory.class) != null;
    }

    public ExtensionsLocator create() {
        return new ExtensionsLocator(){
            private List<ExtensionsLocator.Handle> handles;

            public synchronized List<ExtensionsLocator.Handle> find() {
                if (this.handles == null) {
                    BundleContext context = FrameworkUtil.getBundle(ExtensionsLocatorFactory.class).getBundleContext();
                    ReadOnlyListFactory handlesListFactory = ReadOnlyListFactory.create();
                    Bundle[] bundleArray = context.getBundles();
                    int n = bundleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        URL url;
                        final Bundle bundle = bundleArray[n2];
                        int state = bundle.getState();
                        if ((state == 4 || state == 8 || state == 32) && (url = bundle.getEntry("META-INF/sapphire-extension.xml")) != null) {
                            ExtensionsLocator.Handle handle = new ExtensionsLocator.Handle(){

                                public URL extension() {
                                    return url;
                                }

                                public URL findResource(String name) {
                                    return bundle.getResource(name);
                                }

                                public <T> Class<T> findClass(String name) {
                                    try {
                                        return bundle.loadClass(name);
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        return null;
                                    }
                                }
                            };
                            handlesListFactory.add((Object)handle);
                        }
                        ++n2;
                    }
                    this.handles = handlesListFactory.export();
                }
                return this.handles;
            }
        };
    }
}

