/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.policies;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.swt.gef.commands.CreateNodeCommand;
import org.eclipse.sapphire.ui.swt.gef.commands.DndObjectCommand;
import org.eclipse.sapphire.ui.swt.gef.commands.MoveConnectionLabelCommand;
import org.eclipse.sapphire.ui.swt.gef.commands.MoveNodeCommand;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramConnectionLabelEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramNodeEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.IConfigurationManagerHolder;
import org.eclipse.sapphire.ui.swt.gef.policies.DiagramNodeSelectionEditPolicy;

public class DiagramXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    private DiagramModel model;

    public DiagramXYLayoutEditPolicy(DiagramModel model) {
        this.model = model;
    }

    protected Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
        if (child instanceof DiagramNodeEditPart) {
            return super.getCurrentConstraintFor(child);
        }
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof DiagramNodeEditPart) {
            return new DiagramNodeSelectionEditPolicy();
        }
        return new NonResizableEditPolicy();
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (child instanceof DiagramNodeEditPart && constraint instanceof Rectangle) {
            this.model.getSapphireDiagramEditor().getContextButtonManager().hideContextButtonsInstantly();
            DiagramNodeModel node = ((DiagramNodeEditPart)child).getCastedModel();
            return new MoveNodeCommand(node, (Rectangle)constraint);
        }
        return super.createChangeConstraintCommand(request, child, constraint);
    }

    protected Command createChangeConstraintCommand(EditPart part, Object constraint) {
        if (part instanceof DiagramConnectionLabelEditPart && constraint instanceof Rectangle) {
            return new MoveConnectionLabelCommand((DiagramConnectionLabelEditPart)part, (Rectangle)constraint);
        }
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object cmd = UnexecutableCommand.INSTANCE;
        Rectangle rectangle = null;
        Point pt = new Point(-1, -1);
        if (request.getLocation() != null) {
            rectangle = (Rectangle)this.getConstraintFor(request);
            pt = new Point(rectangle.x, rectangle.y);
        }
        IConfigurationManagerHolder host = (IConfigurationManagerHolder)this.getHost();
        if (request.getNewObjectType() == DiagramNodeTemplate.class) {
            DiagramNodeTemplate nodeTemplate = (DiagramNodeTemplate)request.getNewObject();
            if (nodeTemplate.getDiagramEditorPart() == this.model.getModelPart()) {
                cmd = new CreateNodeCommand(this.model, host, nodeTemplate, pt);
            }
        } else if (request.getNewObjectType() == ISelection.class) {
            ISelection selection = (ISelection)request.getNewObject();
            DiagramModel diagramModel = (DiagramModel)this.getHost().getModel();
            cmd = new DndObjectCommand(diagramModel, selection, pt);
        }
        return cmd;
    }
}

