/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.gallery.IChildElementWithEnum;
import org.eclipse.sapphire.samples.gallery.ThreeChoiceAnswer;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.services.ValueSerializationMasterService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChildElementWithEnum
extends ModelElement
implements IChildElementWithEnum {
    private Value<ThreeChoiceAnswer> pEnumValue;
    private Value<String> pStringValue;

    public ChildElementWithEnum(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public ChildElementWithEnum(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<ThreeChoiceAnswer> getEnumValue() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pEnumValue == null) {
                this.refresh((ModelProperty)PROP_ENUM_VALUE, true);
            }
            return this.pEnumValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnumValue(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ENUM_VALUE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_ENUM_VALUE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_ENUM_VALUE, true);
            if (!ChildElementWithEnum.equal((String)this.pEnumValue.getText(false), (String)value)) {
                this.resource().binding(PROP_ENUM_VALUE).write(value);
                this.refresh((ModelProperty)PROP_ENUM_VALUE, false);
            }
        }
    }

    @Override
    public void setEnumValue(ThreeChoiceAnswer value) {
        this.setEnumValue(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_ENUM_VALUE, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getStringValue() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pStringValue == null) {
                this.refresh((ModelProperty)PROP_STRING_VALUE, true);
            }
            return this.pStringValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringValue(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_STRING_VALUE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_STRING_VALUE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_STRING_VALUE, true);
            if (!ChildElementWithEnum.equal((String)this.pStringValue.getText(false), (String)value)) {
                this.resource().binding(PROP_STRING_VALUE).write(value);
                this.refresh((ModelProperty)PROP_STRING_VALUE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ENUM_VALUE) {
                if (this.pEnumValue != null || force) {
                    Value<ThreeChoiceAnswer> oldValue = this.pEnumValue;
                    String val = this.resource().binding(PROP_ENUM_VALUE).read();
                    this.pEnumValue = new Value((IModelElement)this, PROP_ENUM_VALUE, ((ValueNormalizationService)this.service((ModelProperty)PROP_ENUM_VALUE, ValueNormalizationService.class)).normalize(PROP_ENUM_VALUE.encodeKeywords(val)));
                    this.pEnumValue.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ENUM_VALUE);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_ENUM_VALUE));
                    } else {
                        if (this.pEnumValue.equals(oldValue)) {
                            this.pEnumValue = oldValue;
                        } else {
                            if (!ChildElementWithEnum.equal((String)this.pEnumValue.getText(false), (String)oldValue.getText(false)) || !ChildElementWithEnum.equal((String)this.pEnumValue.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_ENUM_VALUE));
                            }
                            if (!this.pEnumValue.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_ENUM_VALUE, oldValue.validation(), this.pEnumValue.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_ENUM_VALUE, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_STRING_VALUE && (this.pStringValue != null || force)) {
                Value<String> oldValue = this.pStringValue;
                String val = this.resource().binding(PROP_STRING_VALUE).read();
                this.pStringValue = new Value((IModelElement)this, PROP_STRING_VALUE, ((ValueNormalizationService)this.service((ModelProperty)PROP_STRING_VALUE, ValueNormalizationService.class)).normalize(PROP_STRING_VALUE.encodeKeywords(val)));
                this.pStringValue.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_STRING_VALUE);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_STRING_VALUE));
                } else {
                    if (this.pStringValue.equals(oldValue)) {
                        this.pStringValue = oldValue;
                    } else {
                        if (!ChildElementWithEnum.equal((String)this.pStringValue.getText(false), (String)oldValue.getText(false)) || !ChildElementWithEnum.equal((String)this.pStringValue.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_STRING_VALUE));
                        }
                        if (!this.pStringValue.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_STRING_VALUE, oldValue.validation(), this.pStringValue.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_STRING_VALUE, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_ENUM_VALUE) {
            return this.getEnumValue();
        }
        if (property == PROP_STRING_VALUE) {
            return this.getStringValue();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_ENUM_VALUE) {
            if (!(value instanceof String)) {
                this.setEnumValue((ThreeChoiceAnswer)((Object)value));
            } else {
                this.setEnumValue((String)value);
            }
            return;
        }
        if (property == PROP_STRING_VALUE) {
            this.setStringValue((String)value);
            return;
        }
        super.write(property, value);
    }
}

