/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraintBehavior;
import org.eclipse.sapphire.java.JavaTypeConstraintService;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeReferenceService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.ReferenceService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaTypeConstraintFactsService
extends FactsService {
    protected void facts(List<String> facts) {
        ArrayList<String> types;
        ValueProperty property;
        IModelElement element = (IModelElement)this.context(IModelElement.class);
        JavaTypeConstraintService service = (JavaTypeConstraintService)element.service((ModelProperty)(property = (ValueProperty)this.context(ValueProperty.class)), JavaTypeConstraintService.class);
        ArrayList<JavaTypeKind> kinds = new ArrayList<JavaTypeKind>(service.kinds());
        if (kinds.size() > 0 && kinds.size() < 5) {
            if (kinds.size() == 1) {
                facts.add(NLS.bind((String)Resources.statementKindOne, (Object[])new Object[]{JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(0)))}));
            } else if (kinds.size() == 2) {
                facts.add(NLS.bind((String)Resources.statementKindTwo, (Object[])new Object[]{JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(0))), JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(1)))}));
            } else if (kinds.size() == 3) {
                facts.add(NLS.bind((String)Resources.statementKindThree, (Object[])new Object[]{JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(0))), JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(1))), JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(2)))}));
            } else if (kinds.size() == 4) {
                facts.add(NLS.bind((String)Resources.statementKindFour, (Object[])new Object[]{JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(0))), JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(1))), JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(2))), JavaTypeConstraintFactsService.term((JavaTypeKind)((Object)kinds.get(3)))}));
            }
        }
        if ((types = new ArrayList<String>(service.types())).size() > 0) {
            if (types.size() == 1) {
                String typeName = (String)types.get(0);
                String verb = Resources.verbImplementOrExtend;
                ReferenceService referenceService = (ReferenceService)element.service((ModelProperty)property, ReferenceService.class);
                if (referenceService != null && referenceService instanceof JavaTypeReferenceService) {
                    JavaType type = null;
                    try {
                        type = ((JavaTypeReferenceService)referenceService).resolve(typeName);
                    }
                    catch (Exception e) {
                        LoggingService.log((Exception)e);
                    }
                    if (type != null) {
                        JavaTypeKind k = type.kind();
                        if (k == JavaTypeKind.CLASS || k == JavaTypeKind.ABSTRACT_CLASS) {
                            verb = Resources.verbExtend;
                        } else if (k == JavaTypeKind.INTERFACE) {
                            boolean allowsClass = false;
                            boolean allowsInterface = false;
                            for (JavaTypeKind kind : kinds) {
                                if (kind == JavaTypeKind.CLASS || kind == JavaTypeKind.ABSTRACT_CLASS) {
                                    allowsClass = true;
                                    continue;
                                }
                                if (kind != JavaTypeKind.INTERFACE) continue;
                                allowsInterface = true;
                            }
                            if (allowsInterface && !allowsClass) {
                                verb = Resources.verbExtend;
                            } else if (allowsClass && !allowsInterface) {
                                verb = Resources.verbImplement;
                            }
                        }
                    }
                }
                facts.add(NLS.bind((String)Resources.statementTypeOne, (Object[])new Object[]{verb, typeName}));
            } else {
                StringBuilder buf = new StringBuilder();
                for (String type : types) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(type);
                }
                JavaTypeConstraintBehavior behavior = service.behavior();
                if (behavior == JavaTypeConstraintBehavior.AT_LEAST_ONE) {
                    facts.add(NLS.bind((String)Resources.statementTypeOneOf, (Object[])new Object[]{buf.toString()}));
                } else if (behavior == JavaTypeConstraintBehavior.ALL) {
                    facts.add(NLS.bind((String)Resources.statementTypeAll, (Object[])new Object[]{buf.toString()}));
                } else {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private static String term(JavaTypeKind kind) {
        switch (kind) {
            case CLASS: {
                return Resources.termConcreteClass;
            }
            case ABSTRACT_CLASS: {
                return Resources.termAbstractClass;
            }
            case INTERFACE: {
                return Resources.termInterface;
            }
            case ANNOTATION: {
                return Resources.termAnnotation;
            }
            case ENUM: {
                return Resources.termEnumeration;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = (ValueProperty)context.find(ValueProperty.class);
            IModelElement element = (IModelElement)context.find(IModelElement.class);
            return property != null && element != null && element.service((ModelProperty)property, JavaTypeConstraintService.class) != null;
        }

        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new JavaTypeConstraintFactsService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String termConcreteClass;
        public static String termAbstractClass;
        public static String termInterface;
        public static String termAnnotation;
        public static String termEnumeration;
        public static String statementKindOne;
        public static String statementKindTwo;
        public static String statementKindThree;
        public static String statementKindFour;
        public static String statementTypeOne;
        public static String statementTypeOneOf;
        public static String statementTypeAll;
        public static String verbImplement;
        public static String verbExtend;
        public static String verbImplementOrExtend;

        static {
            Resources.initializeMessages((String)JavaTypeConstraintFactsService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

