/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.ElementValidationEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelParticle;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Transient;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.ClearOnDisable;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.AdapterService;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DependenciesAggregationService;
import org.eclipse.sapphire.services.DerivedValueService;
import org.eclipse.sapphire.services.EnablementService;
import org.eclipse.sapphire.services.EqualityService;
import org.eclipse.sapphire.services.InitialValueService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationAggregationService;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.sapphire.services.internal.ElementInstanceServiceContext;
import org.eclipse.sapphire.services.internal.PropertyInstanceServiceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelElement
extends ModelParticle
implements IModelElement {
    private final ModelElementType type;
    private final ModelProperty parentProperty;
    private Status validation;
    private final ListenerContext listeners = new ListenerContext();
    private final Map<ModelProperty, Boolean> enablementStatuses;
    private boolean enablementServicesInitialized;
    private ElementInstanceServiceContext elementServiceContext;
    private final Map<ModelProperty, PropertyInstanceServiceContext> propertyServiceContexts;
    private boolean disposed = false;

    public ModelElement(ModelElementType type, IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(parent, resource);
        this.type = type;
        this.parentProperty = parentProperty;
        this.validation = null;
        this.enablementStatuses = new HashMap<ModelProperty, Boolean>();
        this.propertyServiceContexts = new HashMap<ModelProperty, PropertyInstanceServiceContext>();
        if (parent != null) {
            ModelElement p = (ModelElement)parent.nearest(IModelElement.class);
            this.listeners.coordinate(p.listeners);
        }
        resource.init(this);
        this.attach(new GlobalBridgeListener());
        this.attach(new PropertyInitializationListener());
    }

    @Override
    public ModelElementType type() {
        return this.type;
    }

    @Override
    public ModelProperty getParentProperty() {
        return this.parentProperty;
    }

    @Override
    public final void initialize() {
        for (ModelProperty property : this.properties()) {
            if (property instanceof ValueProperty) {
                InitialValueService initialValueService = this.service(property, InitialValueService.class);
                if (initialValueService == null) continue;
                this.write((ValueProperty)property, (Object)initialValueService.value());
                continue;
            }
            if (!(property instanceof ImpliedElementProperty)) continue;
            this.read((ImpliedElementProperty)property).initialize();
        }
    }

    @Override
    public List<ModelProperty> properties() {
        return this.type.properties();
    }

    @Override
    public <T extends ModelProperty> T property(String name) {
        return this.type.property(name);
    }

    @Override
    public Object read(ModelProperty property) {
        String msg = NLS.bind(Resources.cannotReadProperty, property.getName());
        throw new IllegalArgumentException(msg);
    }

    @Override
    public final <T> Value<T> read(ValueProperty property) {
        return (Value)this.read((ModelProperty)property);
    }

    @Override
    public final <T extends IModelElement> ModelElementHandle<T> read(ElementProperty property) {
        return (ModelElementHandle)this.read((ModelProperty)property);
    }

    @Override
    public final <T extends IModelElement> T read(ImpliedElementProperty property) {
        return (T)((IModelElement)this.read((ModelProperty)property));
    }

    @Override
    public final <T extends IModelElement> ModelElementList<T> read(ListProperty property) {
        return (ModelElementList)this.read((ModelProperty)property);
    }

    @Override
    public final <T> Transient<T> read(TransientProperty property) {
        return (Transient)this.read((ModelProperty)property);
    }

    @Override
    public final SortedSet<String> read(ModelPath path) {
        TreeSet<String> result = new TreeSet<String>();
        this.read(path, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void read(ModelPath path, Collection<String> result) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            ModelPath.Segment head = path.head();
            if (head instanceof ModelPath.ModelRootSegment) {
                ((IModelElement)this.root()).read(path.tail(), result);
            } else if (head instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.parent();
                if (parent == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                if (parent instanceof ModelElementList) {
                    parent = parent.parent();
                }
                ((IModelElement)parent).read(path.tail(), result);
            } else if (head instanceof ModelPath.AllSiblingsSegment) {
                IModelParticle parent = this.parent();
                if (parent == null || !(parent instanceof ModelElementList)) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                parent = parent.parent();
                ModelPath p = new ModelPath(this.getParentProperty().getName()).append(path.tail());
                ((IModelElement)parent).read(p, result);
            } else if (head instanceof ModelPath.AllDescendentsSegment) {
                for (ModelProperty property : this.properties()) {
                    Object obj = this.read(property);
                    if (obj instanceof Value) {
                        String val = ((Value)obj).getText();
                        if (val == null) continue;
                        result.add(val);
                        continue;
                    }
                    if (obj instanceof IModelElement) {
                        ((IModelElement)obj).read(path, result);
                        continue;
                    }
                    if (!(obj instanceof ModelElementList)) continue;
                    for (IModelElement entry : (ModelElementList)obj) {
                        entry.read(path, result);
                    }
                }
            } else if (head instanceof ModelPath.TypeFilterSegment) {
                String t = this.type().getSimpleName();
                boolean match = false;
                for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                    if (!type.equalsIgnoreCase(t)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    this.read(path.tail(), result);
                }
            } else {
                String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
                Object property = this.property(propertyName);
                if (property == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                Object obj = this.read((ModelProperty)property);
                if (obj instanceof Value) {
                    String val = ((Value)obj).getText();
                    if (val != null) {
                        result.add(val);
                    }
                    if (path.length() != 1) {
                        this.logInvalidModelPathMessage(path);
                        return;
                    }
                } else if (obj instanceof IModelElement) {
                    ((IModelElement)obj).read(path.tail(), result);
                } else if (obj instanceof ModelElementList) {
                    for (IModelElement entry : (ModelElementList)obj) {
                        entry.read(path.tail(), result);
                    }
                }
            }
        }
    }

    @Override
    public void write(ValueProperty property, Object value) {
        String msg = NLS.bind(Resources.cannotWriteProperty, property.getName());
        throw new IllegalArgumentException(msg);
    }

    @Override
    public void write(TransientProperty property, Object value) {
        String msg = NLS.bind(Resources.cannotWriteProperty, property.getName());
        throw new IllegalArgumentException(msg);
    }

    @Override
    public final void refresh() {
        this.refresh(false, false);
    }

    @Override
    public final void refresh(boolean force) {
        this.refresh(force, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void refresh(boolean force, boolean deep) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            this.assertNotDisposed();
            for (ModelProperty property : this.properties()) {
                if (this.disposed()) break;
                this.refresh(property, force, deep);
            }
        }
    }

    @Override
    public final void refresh(ModelProperty property) {
        this.refresh(property, false, false);
    }

    @Override
    public final void refresh(ModelProperty property, boolean force) {
        this.refresh(property, force, false);
    }

    @Override
    public final void refresh(ModelProperty property, boolean force, boolean deep) {
        this.assertNotDisposed();
        this.refreshProperty(property, force);
        if (deep) {
            if (property instanceof ElementProperty) {
                Object child = property instanceof ImpliedElementProperty ? this.read((ImpliedElementProperty)property) : this.read((ElementProperty)property).element();
                if (child != null) {
                    child.refresh(force, true);
                }
            } else if (property instanceof ListProperty) {
                for (IModelElement child : this.read((ListProperty)property)) {
                    child.refresh(force, true);
                }
            }
        }
    }

    protected void refreshProperty(ModelProperty property, boolean force) {
    }

    @Override
    public final void copy(IModelElement element) {
        if (this.type != element.type()) {
            throw new IllegalArgumentException();
        }
        for (ModelProperty property : this.type.properties()) {
            ModelProperty prop;
            if (property.isReadOnly()) continue;
            if (property instanceof ValueProperty) {
                prop = (ValueProperty)property;
                this.write((ValueProperty)prop, (Object)element.read((ValueProperty)prop).getText(false));
                continue;
            }
            if (property instanceof ImpliedElementProperty) {
                prop = (ImpliedElementProperty)property;
                this.read((ImpliedElementProperty)prop).copy((IModelElement)element.read((ImpliedElementProperty)prop));
                continue;
            }
            if (property instanceof ElementProperty) {
                prop = (ElementProperty)property;
                Object elementChild = element.read((ElementProperty)prop).element();
                ModelElementHandle handle = this.read((ElementProperty)prop);
                if (elementChild == null) {
                    handle.remove();
                    continue;
                }
                Object thisChild = handle.element(true, elementChild.type());
                thisChild.copy((IModelElement)elementChild);
                continue;
            }
            if (property instanceof ListProperty) {
                prop = (ListProperty)property;
                ModelElementList list = this.read((ListProperty)prop);
                list.clear();
                for (IModelElement elementChild : element.read((ListProperty)prop)) {
                    Object thisChild = list.insert(elementChild.type());
                    thisChild.copy(elementChild);
                }
                continue;
            }
            if (!(property instanceof TransientProperty)) continue;
            prop = (TransientProperty)property;
            this.write((TransientProperty)prop, element.read((TransientProperty)prop).content());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean equals(Object obj) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            EqualityService equalityService;
            boolean result = false;
            if (this == obj) {
                result = true;
            } else if (obj instanceof IModelElement && !this.disposed() && (equalityService = this.service(EqualityService.class)) != null) {
                result = equalityService.doEquals(obj);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hashCode() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            EqualityService equalityService;
            int result = this.disposed() ? super.hashCode() : ((equalityService = this.service(EqualityService.class)) != null ? equalityService.doHashCode() : super.hashCode());
            return result;
        }
    }

    @Override
    public final <S extends Service> S service(Class<S> serviceType) {
        List<S> services = this.services(serviceType);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <S extends Service> List<S> services(Class<S> serviceType) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.elementServiceContext == null) {
                this.elementServiceContext = new ElementInstanceServiceContext(this);
            }
        }
        return this.elementServiceContext.services(serviceType);
    }

    @Override
    public final <S extends Service> S service(ModelProperty property, Class<S> serviceType) {
        List<S> services = this.services(property, serviceType);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <S extends Service> List<S> services(ModelProperty property, Class<S> serviceType) {
        PropertyInstanceServiceContext context;
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            context = this.propertyServiceContexts.get(property);
            if (context == null) {
                context = new PropertyInstanceServiceContext(this, property);
                this.propertyServiceContexts.put(property, context);
            }
        }
        return context.services(serviceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean enabled(ModelProperty property) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            Boolean status = this.enablementStatuses.get(property);
            if (status == null) {
                this.refreshProperty(property, true);
                status = this.enablementStatuses.get(property);
            }
            return status;
        }
    }

    protected final EnablementRefreshResult refreshPropertyEnablement(ModelProperty property) {
        return this.refreshPropertyEnablement(property, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EnablementRefreshResult refreshPropertyEnablement(ModelProperty property, boolean notifyListenersIfNecessary) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            Boolean oldState;
            if (!this.enablementServicesInitialized) {
                for (final ModelProperty prop : this.type.properties()) {
                    Listener enablementServiceListener = new Listener(){

                        public void handle(Event event) {
                            if (!ModelElement.this.disposed()) {
                                ModelElement.this.refreshPropertyEnablement(prop, true);
                            }
                        }
                    };
                    for (EnablementService service : this.services(prop, EnablementService.class)) {
                        service.attach(enablementServiceListener);
                    }
                }
                this.enablementServicesInitialized = true;
            }
            boolean newState = true;
            for (EnablementService service : this.services(property, EnablementService.class)) {
                boolean bl = newState = newState && service.enablement();
                if (!newState) break;
            }
            if ((oldState = this.enablementStatuses.get(property)) == null) {
                this.enablementStatuses.put(property, newState);
            } else if (!oldState.equals(newState)) {
                this.enablementStatuses.put(property, newState);
                if (notifyListenersIfNecessary) {
                    this.broadcast(new PropertyEnablementEvent(this, property, oldState, newState));
                }
            }
            return new EnablementRefreshResult(oldState, newState);
        }
    }

    @Override
    public final Status validation() {
        if (this.validation == null) {
            this.refreshValidationResult();
        }
        return this.validation;
    }

    @Override
    public final Status validation(ModelProperty property) {
        Status validation;
        if (property instanceof ValueProperty) {
            validation = this.read((ValueProperty)property).validation();
        } else if (property instanceof ListProperty) {
            validation = this.read((ListProperty)property).validation();
        } else if (property instanceof ImpliedElementProperty) {
            validation = this.read((ImpliedElementProperty)property).validation();
        } else if (property instanceof ElementProperty) {
            validation = this.read((ElementProperty)property).validation();
        } else if (property instanceof TransientProperty) {
            validation = this.read((TransientProperty)property).validation();
        } else {
            throw new IllegalStateException();
        }
        return validation;
    }

    private void refreshValidationResult() {
        ValidationAggregationService service = this.service(ValidationAggregationService.class);
        Status validation = service.validation();
        if (this.validation == null) {
            this.validation = validation;
            Listener validationAggregationServiceListener = new Listener(){

                public void handle(Event event) {
                    ModelElement.this.refreshValidationResult();
                }
            };
            service.attach(validationAggregationServiceListener);
        } else if (!this.validation.equals(validation)) {
            Status oldValidationState = this.validation;
            this.validation = validation;
            this.broadcast(new ElementValidationEvent(this, oldValidationState, this.validation));
        }
    }

    @Override
    public final boolean attach(Listener listener) {
        return this.listeners.attach(listener);
    }

    @Override
    public final void attach(Listener listener, String path) {
        this.attach(listener, new ModelPath(path));
    }

    @Override
    public final void attach(Listener listener, ModelPath path) {
        ModelPath.Segment head = path.head();
        if (head instanceof ModelPath.ModelRootSegment) {
            ((IModelElement)this.root()).attach(listener, path.tail());
        } else if (head instanceof ModelPath.ParentElementSegment) {
            IModelParticle parent = this.parent();
            if (parent == null) {
                this.logInvalidModelPathMessage(path);
                return;
            }
            if (parent instanceof ModelElementList) {
                parent = parent.parent();
            }
            ((IModelElement)parent).attach(listener, path.tail());
        } else if (head instanceof ModelPath.AllSiblingsSegment) {
            IModelParticle parent = this.parent();
            if (parent == null || !(parent instanceof ModelElementList)) {
                this.logInvalidModelPathMessage(path);
                return;
            }
            parent = parent.parent();
            ModelPath p = new ModelPath(this.parentProperty.getName()).append(path.tail());
            ((IModelElement)parent).attach(listener, p);
        } else if (head instanceof ModelPath.AllDescendentsSegment) {
            if (this.attach(new PropagationListener(path, listener))) {
                for (ModelProperty property : this.type.properties()) {
                    if (property instanceof ImpliedElementProperty) {
                        this.read((ImpliedElementProperty)property).attach(listener, path);
                        continue;
                    }
                    if (property instanceof ElementProperty) {
                        Object element = this.read((ElementProperty)property).element();
                        if (element == null) continue;
                        element.attach(listener, path);
                        continue;
                    }
                    if (property instanceof ListProperty) {
                        ModelElementList list = this.read((ListProperty)property);
                        for (IModelElement x : list) {
                            x.attach(listener, path);
                        }
                        continue;
                    }
                    this.attach(PropertyEvent.filter(listener));
                }
            }
        } else if (head instanceof ModelPath.TypeFilterSegment) {
            String t = this.type.getSimpleName();
            boolean match = false;
            for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                if (!type.equalsIgnoreCase(t)) continue;
                match = true;
                break;
            }
            if (match) {
                this.attach(listener, path.tail());
            }
        } else {
            String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
            Object property = this.type.property(propertyName);
            if (property == null) {
                this.logInvalidModelPathMessage(path);
                return;
            }
            if (path.length() == 1) {
                this.attach(PropertyEvent.filter(listener, property));
            } else {
                ModelPath tail = path.tail();
                if (property instanceof ImpliedElementProperty) {
                    this.read((ImpliedElementProperty)property).attach(listener, tail);
                } else if (property instanceof ElementProperty) {
                    Object element;
                    if (this.attach(PropertyEvent.filter((Listener)new PropagationListener(tail, listener), property)) && (element = this.read((ElementProperty)property).element()) != null) {
                        element.attach(listener, tail);
                    }
                } else if (property instanceof ListProperty) {
                    if (this.attach(PropertyEvent.filter((Listener)new PropagationListener(tail, listener), property))) {
                        ModelElementList list = this.read((ListProperty)property);
                        for (IModelElement x : list) {
                            x.attach(listener, tail);
                        }
                    }
                } else {
                    this.logInvalidModelPathMessage(path);
                }
            }
        }
    }

    @Override
    public final boolean detach(Listener listener) {
        return this.listeners.detach(listener);
    }

    @Override
    public final void detach(Listener listener, String path) {
        this.detach(listener, new ModelPath(path));
    }

    @Override
    public final void detach(Listener listener, ModelPath path) {
        ModelPath.Segment head = path.head();
        if (head instanceof ModelPath.ModelRootSegment) {
            ((IModelElement)this.root()).detach(listener, path.tail());
        } else if (head instanceof ModelPath.ParentElementSegment) {
            IModelParticle parent = this.parent();
            if (parent == null) {
                this.logInvalidModelPathMessage(path);
                return;
            }
            if (parent instanceof ModelElementList) {
                parent = parent.parent();
            }
            ((IModelElement)parent).detach(listener, path.tail());
        } else if (head instanceof ModelPath.AllSiblingsSegment) {
            IModelParticle parent = this.parent();
            if (parent == null || !(parent instanceof ModelElementList)) {
                this.logInvalidModelPathMessage(path);
                return;
            }
            parent = parent.parent();
            ModelPath p = new ModelPath(this.parentProperty.getName()).append(path.tail());
            ((IModelElement)parent).detach(listener, p);
        } else if (head instanceof ModelPath.AllDescendentsSegment) {
            this.detach(new PropagationListener(path, listener));
            for (ModelProperty property : this.type.properties()) {
                if (property instanceof ImpliedElementProperty) {
                    this.read((ImpliedElementProperty)property).detach(listener, path);
                    continue;
                }
                if (property instanceof ElementProperty) {
                    Object element = this.read((ElementProperty)property).element();
                    if (element == null) continue;
                    element.detach(listener, path);
                    continue;
                }
                if (property instanceof ListProperty) {
                    ModelElementList list = this.read((ListProperty)property);
                    for (IModelElement x : list) {
                        x.detach(listener, path);
                    }
                    continue;
                }
                this.detach(PropertyEvent.filter(listener));
            }
        } else if (head instanceof ModelPath.TypeFilterSegment) {
            String t = this.type.getSimpleName();
            boolean match = false;
            for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                if (!type.equalsIgnoreCase(t)) continue;
                match = true;
                break;
            }
            if (match) {
                this.detach(listener, path.tail());
            }
        } else {
            String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
            Object property = this.type.property(propertyName);
            if (property == null) {
                this.logInvalidModelPathMessage(path);
                return;
            }
            if (path.length() == 1) {
                this.detach(PropertyEvent.filter(listener, property));
            } else {
                ModelPath tail = path.tail();
                if (property instanceof ImpliedElementProperty) {
                    this.read((ImpliedElementProperty)property).detach(listener, tail);
                } else if (property instanceof ElementProperty) {
                    this.detach(PropertyEvent.filter((Listener)new PropagationListener(tail, listener), property));
                    Object element = this.read((ElementProperty)property).element();
                    if (element != null) {
                        element.detach(listener, tail);
                    }
                } else if (property instanceof ListProperty) {
                    this.detach(PropertyEvent.filter((Listener)new PropagationListener(tail, listener), property));
                    ModelElementList list = this.read((ListProperty)property);
                    for (IModelElement x : list) {
                        x.detach(listener, tail);
                    }
                } else {
                    this.logInvalidModelPathMessage(path);
                }
            }
        }
    }

    protected final void broadcast(Event event) {
        this.listeners.broadcast(event);
    }

    final void broadcastPropertyContentEvent(ModelProperty property) {
        this.broadcast(new PropertyContentEvent(this, property));
    }

    final void broadcastPropertyValidationEvent(ModelProperty property, Status before, Status after) {
        this.broadcast(new PropertyValidationEvent(this, property, before, after));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean disposed() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            return this.disposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            this.disposed = true;
            if (this.elementServiceContext != null) {
                this.elementServiceContext.dispose();
            }
            for (ServiceContext serviceContext : this.propertyServiceContexts.values()) {
                serviceContext.dispose();
            }
            this.broadcast(new ElementDisposeEvent(this));
            this.disposeProperties();
            try {
                this.resource().dispose();
            }
            catch (Exception exception) {
                LoggingService.log(exception);
            }
        }
    }

    protected void disposeProperties() {
    }

    protected final void assertNotDisposed() {
        if (this.disposed()) {
            String msg = NLS.bind(Resources.elementAlreadyDisposed, this.type.getSimpleName());
            throw new IllegalStateException(msg);
        }
    }

    private void logInvalidModelPathMessage(ModelPath path) {
        String message = NLS.bind(Resources.invalidModelPath, this.type.getModelElementClass().getName(), path.toString());
        LoggingService.log(Status.createErrorStatus(message));
    }

    @Override
    public <A> A adapt(Class<A> adapterType) {
        A result = null;
        for (AdapterService service : this.services(AdapterService.class)) {
            result = service.adapt(adapterType);
            if (result != null) break;
        }
        if (result == null) {
            result = super.adapt(adapterType);
        }
        return result;
    }

    protected static final boolean equal(String value1, String value2) {
        String val1 = ModelElement.normalize(value1);
        String val2 = ModelElement.normalize(value2);
        boolean valuesAreEqual = false;
        if (val1 == val2) {
            valuesAreEqual = true;
        } else if (val1 != null && val2 != null) {
            valuesAreEqual = val1.equals(val2);
        }
        return valuesAreEqual;
    }

    protected static final String normalize(String value) {
        if (value != null && value.equals("")) {
            return null;
        }
        return value;
    }

    protected final class EnablementRefreshResult {
        private final Boolean oldEnablementState;
        private final boolean newEnablementState;

        public EnablementRefreshResult(Boolean before, boolean after) {
            this.oldEnablementState = before;
            this.newEnablementState = after;
        }

        public Boolean before() {
            return this.oldEnablementState;
        }

        public boolean after() {
            return this.newEnablementState;
        }

        public boolean changed() {
            if (this.oldEnablementState == null) {
                return false;
            }
            return this.oldEnablementState ^ this.newEnablementState;
        }
    }

    private final class GlobalBridgeListener
    extends Listener {
        private GlobalBridgeListener() {
        }

        public void handle(Event event) {
            ModelElement.this.type().broadcast(event);
            if (event instanceof PropertyEvent) {
                PropertyEvent evt = (PropertyEvent)event;
                evt.property().broadcast(evt);
            }
        }
    }

    private final class PropagationListener
    extends Listener {
        private final ModelPath path;
        private final Listener listener;

        public PropagationListener(ModelPath path, Listener listener) {
            this.path = path;
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PropagationListener) {
                PropagationListener pl = (PropagationListener)obj;
                return this.path.equals(pl.path) && this.listener.equals(pl.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode() ^ this.listener.hashCode();
        }

        public void handle(Event event) {
            if (event instanceof PropertyContentEvent) {
                ModelProperty property = ((PropertyContentEvent)event).property();
                if (property instanceof ListProperty) {
                    ModelElementList list = ModelElement.this.read((ListProperty)property);
                    for (IModelElement x : list) {
                        x.attach(this.listener, this.path);
                    }
                    this.listener.handle(event);
                } else if (property instanceof ElementProperty && !(property instanceof ImpliedElementProperty)) {
                    Object element = ModelElement.this.read((ElementProperty)property).element();
                    if (element != null) {
                        element.attach(this.listener, this.path);
                    }
                    this.listener.handle(event);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropertyInitializationListener
    extends FilteredListener<PropertyInitializationEvent> {
        private PropertyInitializationListener() {
        }

        @Override
        protected void handleTypedEvent(PropertyInitializationEvent event) {
            DerivedValueService derivedValueService;
            final IModelElement element = event.element();
            final ModelProperty property = event.property();
            final Listener triggerRefreshListener = new Listener(){

                public void handle(Event event) {
                    if (!element.disposed()) {
                        element.refresh(property);
                    }
                }
            };
            final Set<ModelPath> dependencies = element.service(property, DependenciesAggregationService.class).dependencies();
            for (ModelPath dependency : dependencies) {
                element.attach(triggerRefreshListener, dependency);
            }
            for (ValidationService validationService : element.services(property, ValidationService.class)) {
                validationService.attach(triggerRefreshListener);
            }
            DefaultValueService defaultValueService = element.service(property, DefaultValueService.class);
            if (defaultValueService != null) {
                defaultValueService.attach(triggerRefreshListener);
            }
            if ((derivedValueService = element.service(property, DerivedValueService.class)) != null) {
                derivedValueService.attach(triggerRefreshListener);
            }
            if (property.hasAnnotation(ClearOnDisable.class)) {
                FilteredListener<PropertyEnablementEvent> clearOnDisableListener = null;
                if (property instanceof ValueProperty) {
                    final ValueProperty prop = (ValueProperty)property;
                    clearOnDisableListener = new FilteredListener<PropertyEnablementEvent>(){

                        @Override
                        protected void handleTypedEvent(PropertyEnablementEvent event) {
                            if (event.before() && !event.after()) {
                                element.write(prop, null);
                            }
                        }
                    };
                } else if (property instanceof ListProperty) {
                    final ListProperty prop = (ListProperty)property;
                    clearOnDisableListener = new FilteredListener<PropertyEnablementEvent>(){

                        @Override
                        protected void handleTypedEvent(PropertyEnablementEvent event) {
                            if (event.before() && !event.after()) {
                                element.read(prop).clear();
                            }
                        }
                    };
                } else if (property instanceof ElementProperty && !(property instanceof ImpliedElementProperty)) {
                    final ElementProperty prop = (ElementProperty)property;
                    clearOnDisableListener = new FilteredListener<PropertyEnablementEvent>(){

                        @Override
                        protected void handleTypedEvent(PropertyEnablementEvent event) {
                            if (event.before() && !event.after()) {
                                element.read(prop).remove();
                            }
                        }
                    };
                }
                if (clearOnDisableListener != null) {
                    element.attach((Listener)clearOnDisableListener, property.getName());
                }
            }
            if (!dependencies.isEmpty()) {
                FilteredListener<ElementDisposeEvent> disposeListener = new FilteredListener<ElementDisposeEvent>(){

                    @Override
                    protected void handleTypedEvent(ElementDisposeEvent event) {
                        for (ModelPath dependency : dependencies) {
                            element.detach(triggerRefreshListener, dependency);
                        }
                    }
                };
                element.attach(disposeListener);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String invalidModelPath;
        public static String cannotReadProperty;
        public static String cannotWriteProperty;
        public static String elementAlreadyDisposed;

        static {
            Resources.initializeMessages(ModelElement.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

