/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.SortedSet;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.modeling.ElementBindingImpl;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.ElementValidationEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.ValidationAggregationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelElementHandle<T extends IModelElement> {
    private final ModelElement parent;
    private final ElementProperty property;
    private final PossibleTypesService possibleTypesService;
    private final ElementBindingImpl binding;
    private T element;
    private Status validationStateLocal;
    private Status validationStateFull;

    public ModelElementHandle(IModelElement parent, ElementProperty property) {
        this.parent = (ModelElement)parent;
        this.property = property;
        this.possibleTypesService = parent.service(property, PossibleTypesService.class);
        this.binding = parent.resource().binding(property);
    }

    public void init() {
        this.refresh();
    }

    public IModelElement root() {
        return (IModelElement)this.parent.root();
    }

    public IModelElement parent() {
        return this.parent;
    }

    public T element() {
        return this.element(false);
    }

    public T element(boolean createIfNecessary) {
        if (createIfNecessary) {
            SortedSet<ModelElementType> possible = this.possibleTypesService.types();
            if (possible.size() > 1) {
                throw new IllegalArgumentException();
            }
            return this.element(true, possible.first());
        }
        return this.element(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T element(boolean createIfNecessary, ModelElementType type) {
        SortedSet<ModelElementType> possible = this.possibleTypesService.types();
        if (type != null && !possible.contains(type)) {
            throw new IllegalArgumentException();
        }
        boolean changed = false;
        if (createIfNecessary) {
            ModelElementType t = type;
            if (t == null) {
                if (possible.size() > 1) {
                    throw new IllegalArgumentException();
                }
                t = possible.first();
            }
            ModelElementHandle modelElementHandle = this;
            synchronized (modelElementHandle) {
                if (this.element == null) {
                    this.refresh();
                }
                if (this.element == null || this.element.type() != t) {
                    Resource resource = this.binding.create(t);
                    this.element = t.instantiate(this.parent, this.property, resource);
                    this.element.initialize();
                    this.element.attach(new FilteredListener<ElementValidationEvent>(){

                        @Override
                        protected void handleTypedEvent(ElementValidationEvent event) {
                            ModelElementHandle.this.refreshValidationResult();
                        }
                    });
                    changed = true;
                }
            }
        }
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            if (this.element != null && type != null && this.element.type() != type) {
                throw new IllegalArgumentException();
            }
        }
        if (changed) {
            if (!(this.property instanceof ImpliedElementProperty)) {
                this.parent.broadcastPropertyContentEvent(this.property);
            }
            this.refreshValidationResult();
        }
        return this.element;
    }

    public Status validation() {
        return this.validation(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status validation(boolean includeChildValidation) {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            return includeChildValidation ? this.validationStateFull : this.validationStateLocal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enabled() {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            return this.parent.enabled(this.property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove() {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            boolean changed = false;
            if (this.element != null) {
                this.binding.remove();
                changed = this.refresh();
            }
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removable() {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            return this.binding.removable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refresh() {
        boolean changed = false;
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            Resource oldResource = this.element == null ? null : this.element.resource();
            Resource newResource = this.binding.read();
            if (newResource != oldResource) {
                if (this.element != null) {
                    try {
                        this.element.dispose();
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                }
                if (newResource == null) {
                    this.element = null;
                } else {
                    ModelElementType type = this.binding.type(newResource);
                    this.element = type.instantiate(this.parent, this.property, newResource);
                    this.element.attach(new FilteredListener<ElementValidationEvent>(){

                        @Override
                        protected void handleTypedEvent(ElementValidationEvent event) {
                            ModelElementHandle.this.refreshValidationResult();
                        }
                    });
                }
                changed = true;
            }
        }
        if (changed && !(this.property instanceof ImpliedElementProperty)) {
            this.parent.broadcastPropertyContentEvent(this.property);
        }
        return changed |= this.refreshValidationResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshValidationResult() {
        boolean changed = false;
        Status before = null;
        Status after = null;
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            Status oldValidationStateFull;
            Status newValidationStateFull;
            Status newValidationStateLocal;
            Status.CompositeStatusFactory newValidationStateFullFactory = Status.factoryForComposite();
            if (this.enabled()) {
                newValidationStateLocal = this.parent().service(this.property, ValidationAggregationService.class).validation();
                newValidationStateFullFactory.merge(newValidationStateLocal);
                if (this.element != null) {
                    newValidationStateFullFactory.merge(this.element.validation());
                }
            } else {
                newValidationStateLocal = Status.createOkStatus();
            }
            if (!(newValidationStateFull = newValidationStateFullFactory.create()).equals(oldValidationStateFull = this.validationStateFull)) {
                this.validationStateLocal = newValidationStateLocal;
                this.validationStateFull = newValidationStateFull;
                if (oldValidationStateFull != null) {
                    changed = true;
                    before = oldValidationStateFull;
                    after = this.validationStateFull;
                }
            }
        }
        if (changed) {
            ((ModelElement)this.parent()).broadcastPropertyValidationEvent(this.property, before, after);
        }
        return changed;
    }
}

