/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sapphire.modeling.DoubleValueKeyword;
import org.eclipse.sapphire.modeling.FloatValueKeyword;
import org.eclipse.sapphire.modeling.IntegerValueKeyword;
import org.eclipse.sapphire.modeling.LongValueKeyword;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueKeyword;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueProperty
extends ModelProperty {
    private static final Set<ValueKeyword> NO_KEYWORDS = Collections.emptySet();
    private static final Set<ValueKeyword> INTEGER_KEYWORDS;
    private static final Set<ValueKeyword> LONG_KEYWORDS;
    private static final Set<ValueKeyword> FLOAT_KEYWORDS;
    private static final Set<ValueKeyword> DOUBLE_KEYWORDS;
    private final Set<ValueKeyword> keywords;

    static {
        HashSet<ValueKeyword> keywords = new HashSet<ValueKeyword>();
        keywords.add(new IntegerValueKeyword("max-int", String.valueOf(Integer.MAX_VALUE)));
        keywords.add(new IntegerValueKeyword("min-int", String.valueOf(Integer.MIN_VALUE)));
        INTEGER_KEYWORDS = Collections.unmodifiableSet(keywords);
        keywords = new HashSet();
        keywords.add(new LongValueKeyword("max-long", String.valueOf(Long.MAX_VALUE)));
        keywords.add(new LongValueKeyword("min-long", String.valueOf(Long.MIN_VALUE)));
        LONG_KEYWORDS = Collections.unmodifiableSet(keywords);
        keywords = new HashSet();
        keywords.add(new FloatValueKeyword("max-float", String.valueOf(Float.MAX_VALUE)));
        keywords.add(new FloatValueKeyword("min-float", String.valueOf(Float.MIN_VALUE)));
        FLOAT_KEYWORDS = Collections.unmodifiableSet(keywords);
        keywords = new HashSet();
        keywords.add(new DoubleValueKeyword("max-double", String.valueOf(Double.MAX_VALUE)));
        keywords.add(new DoubleValueKeyword("min-double", String.valueOf(Double.MIN_VALUE)));
        DOUBLE_KEYWORDS = Collections.unmodifiableSet(keywords);
    }

    public ValueProperty(ModelElementType type, String propertyName) {
        this(type, propertyName, null);
    }

    public ValueProperty(ModelElementType type, ValueProperty baseProperty) {
        this(type, baseProperty.getName(), baseProperty);
    }

    private ValueProperty(ModelElementType type, String propertyName, ValueProperty baseProperty) {
        super(type, propertyName, baseProperty);
        Class<?> propType = this.getTypeClass();
        this.keywords = propType == Integer.class ? INTEGER_KEYWORDS : (propType == Long.class ? LONG_KEYWORDS : (propType == Float.class ? FLOAT_KEYWORDS : (propType == Double.class ? DOUBLE_KEYWORDS : NO_KEYWORDS)));
    }

    public Set<ValueKeyword> getKeywords() {
        return this.keywords;
    }

    public ValueKeyword getKeyword(String keyword) {
        for (ValueKeyword kwd : this.keywords) {
            if (!kwd.getKeyword().equals(keyword)) continue;
            return kwd;
        }
        return null;
    }

    public String decodeKeywords(String value) {
        String result = value;
        if (value != null) {
            for (ValueKeyword keyword : this.keywords) {
                result = keyword.decode(value);
                if (result != value) break;
            }
        }
        return result;
    }

    public String encodeKeywords(String value) {
        String result = value;
        if (value != null) {
            for (ValueKeyword keyword : this.keywords) {
                result = keyword.encode(value);
                if (result != value) break;
            }
        }
        return result;
    }
}

