/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.util.NLS;

public final class GreaterThanFunction
extends Function {
    public static GreaterThanFunction create(Function a, Function b) {
        GreaterThanFunction function = new GreaterThanFunction();
        function.init(a, b);
        return function;
    }

    public String name() {
        return ">";
    }

    public boolean operator() {
        return true;
    }

    public int precedence() {
        return 5;
    }

    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            protected Object evaluate() {
                Object b;
                Object a = this.operand(0).value();
                if (a == (b = this.operand(1).value())) {
                    return false;
                }
                if (a == null || b == null) {
                    return false;
                }
                if (a instanceof BigDecimal || b instanceof BigDecimal) {
                    BigDecimal y;
                    BigDecimal x = this.cast(a, BigDecimal.class);
                    if (x.compareTo(y = this.cast(b, BigDecimal.class)) > 0) {
                        return true;
                    }
                    return false;
                }
                if (a instanceof Float || a instanceof Double || b instanceof Float || b instanceof Double) {
                    Double x = this.cast(a, Double.class);
                    Double y = this.cast(b, Double.class);
                    if (x > y) {
                        return true;
                    }
                    return false;
                }
                if (a instanceof BigInteger || b instanceof BigInteger) {
                    BigInteger y;
                    BigInteger x = this.cast(a, BigInteger.class);
                    if (x.compareTo(y = this.cast(b, BigInteger.class)) > 0) {
                        return true;
                    }
                    return false;
                }
                if (a instanceof Byte || a instanceof Short || a instanceof Character || a instanceof Integer || a instanceof Long || b instanceof Byte || b instanceof Short || b instanceof Character || b instanceof Integer || b instanceof Long) {
                    Long x = this.cast(a, Long.class);
                    Long y = this.cast(b, Long.class);
                    if (x > y) {
                        return true;
                    }
                    return false;
                }
                if (a instanceof String || b instanceof String) {
                    String y;
                    String x = this.cast(a, String.class);
                    if (x.compareTo(y = this.cast(b, String.class)) > 0) {
                        return true;
                    }
                    return false;
                }
                if (a instanceof Comparable) {
                    if (((Comparable)a).compareTo(b) > 0) {
                        return true;
                    }
                    return false;
                }
                if (b instanceof Comparable) {
                    if (((Comparable)b).compareTo(a) < 0) {
                        return true;
                    }
                    return false;
                }
                throw new FunctionException(NLS.bind(Resources.cannotApplyMessage, a.getClass().getName(), b.getClass().getName()));
            }
        };
    }

    private static final class Resources
    extends NLS {
        public static String cannotApplyMessage;

        static {
            Resources.initializeMessages(GreaterThanFunction.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

