/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.internal.FunctionUtils;

public final class MultiplyFunction
extends Function {
    public static MultiplyFunction create(Function a, Function b) {
        MultiplyFunction function = new MultiplyFunction();
        function.init(a, b);
        return function;
    }

    public static MultiplyFunction create(Number a, Number b) {
        return MultiplyFunction.create(Literal.create(a), Literal.create(b));
    }

    public String name() {
        return "*";
    }

    public boolean operator() {
        return true;
    }

    public int precedence() {
        return 3;
    }

    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            protected Object evaluate() {
                Object a = this.operand(0).value();
                Object b = this.operand(1).value();
                if (a == null && b == null) {
                    return 0L;
                }
                if (a instanceof BigDecimal || b instanceof BigDecimal) {
                    BigDecimal x = this.cast(a, BigDecimal.class);
                    BigDecimal y = this.cast(b, BigDecimal.class);
                    return x.multiply(y);
                }
                if (a instanceof Float || a instanceof Double || FunctionUtils.isDecimalString(a) || b instanceof Float || b instanceof Double || FunctionUtils.isDecimalString(b)) {
                    if (a instanceof BigInteger || b instanceof BigInteger) {
                        BigDecimal x = this.cast(a, BigDecimal.class);
                        BigDecimal y = this.cast(b, BigDecimal.class);
                        return x.multiply(y);
                    }
                    Double x = this.cast(a, Double.class);
                    Double y = this.cast(b, Double.class);
                    return x * y;
                }
                if (a instanceof BigInteger || b instanceof BigInteger) {
                    BigInteger x = this.cast(a, BigInteger.class);
                    BigInteger y = this.cast(b, BigInteger.class);
                    return x.multiply(y);
                }
                Long x = this.cast(a, Long.class);
                Long y = this.cast(b, Long.class);
                return x * y;
            }
        };
    }
}

