/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.util.IdentityHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependencySorter<K, T> {
    private final Map<K, T> objectByKey = new HashMap<K, T>();
    private final Map<T, Set<K>> objectToDependencies = new IdentityHashMap<T, Set<K>>();

    public void add(K key, T object) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (this.objectByKey.containsKey(key)) {
            if (this.objectByKey.get(key) != object) {
                throw new IllegalArgumentException();
            }
        } else {
            this.objectByKey.put(key, object);
            this.objectToDependencies.put(object, new HashSet());
        }
    }

    public void dependency(T from, K toKey) {
        if (!this.objectToDependencies.containsKey(from)) {
            throw new IllegalArgumentException();
        }
        this.objectToDependencies.get(from).add(toKey);
    }

    public List<T> sort() {
        if (this.objectToDependencies.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> roots = new ArrayList<T>();
        for (T x : this.objectToDependencies.keySet()) {
            boolean bl = false;
            for (Set<K> dependencies : this.objectToDependencies.values()) {
                for (K dependency : dependencies) {
                    if (this.objectByKey.get(dependency) != x) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            if (bl) continue;
            roots.add(x);
        }
        IdentityHashSet visited = new IdentityHashSet();
        for (Object e : roots) {
            this.visit(e, visited);
        }
        block4: while (visited.size() != this.objectToDependencies.size()) {
            for (T t : this.objectToDependencies.keySet()) {
                if (visited.contains(t)) continue;
                roots.add(t);
                this.visit(t, visited);
                continue block4;
            }
        }
        ArrayList arrayList = new ArrayList();
        visited.clear();
        for (Object e : roots) {
            this.traverse(e, arrayList, visited);
        }
        return arrayList;
    }

    private void visit(T object, Set<T> visited) {
        if (visited.contains(object)) {
            return;
        }
        visited.add(object);
        for (K key : this.objectToDependencies.get(object)) {
            T x = this.objectByKey.get(key);
            if (x == null) continue;
            this.visit(x, visited);
        }
    }

    private void traverse(T object, List<T> list, Set<T> visited) {
        if (visited.contains(object)) {
            return;
        }
        visited.add(object);
        for (K key : this.objectToDependencies.get(object)) {
            T x = this.objectByKey.get(key);
            if (x == null) continue;
            this.traverse(x, list, visited);
        }
        list.add(object);
    }
}

