/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NLS {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final String EXTENSION = ".properties";
    private static String[] nlSuffixes;
    static final Object ASSIGNED;

    static {
        ASSIGNED = new Object();
    }

    protected NLS() {
    }

    public static String bind(String message, Object ... bindings) {
        int length;
        int bufLen;
        if (message == null) {
            return "No message available.";
        }
        if (bindings == null || bindings.length == 0) {
            bindings = EMPTY_ARGS;
        }
        StringBuffer buffer = new StringBuffer((bufLen = (length = message.length()) + bindings.length * 5) < 0 ? 0 : bufLen);
        int i = 0;
        while (i < length) {
            char c = message.charAt(i);
            switch (c) {
                case '{': {
                    int index = message.indexOf(125, i);
                    if (index == -1) {
                        buffer.append(c);
                        break;
                    }
                    if (++i >= length) {
                        buffer.append(c);
                        break;
                    }
                    int number = -1;
                    try {
                        number = Integer.parseInt(message.substring(i, index));
                    }
                    catch (NumberFormatException e) {
                        throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
                    }
                    if (number >= bindings.length || number < 0) {
                        buffer.append("<missing argument>");
                        i = index;
                        break;
                    }
                    buffer.append(bindings[number]);
                    i = index;
                    break;
                }
                case '\'': {
                    int nextIndex = i + 1;
                    if (nextIndex >= length) {
                        buffer.append(c);
                        break;
                    }
                    char next = message.charAt(nextIndex);
                    if (next == '\'') {
                        ++i;
                        buffer.append(c);
                        break;
                    }
                    int index = message.indexOf(39, nextIndex);
                    if (index == -1) {
                        buffer.append(c);
                        break;
                    }
                    buffer.append(message.substring(nextIndex, index));
                    i = index;
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void initializeMessages(final String baseName, final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            NLS.load(baseName, clazz);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                NLS.load(baseName, clazz);
                return null;
            }
        });
    }

    private static String[] buildVariants(String root) {
        if (nlSuffixes == null) {
            String nl = Locale.getDefault().toString();
            ArrayList<String> result = new ArrayList<String>(4);
            while (true) {
                result.add(String.valueOf('_') + nl + EXTENSION);
                int lastSeparator = nl.lastIndexOf(95);
                if (lastSeparator == -1) break;
                nl = nl.substring(0, lastSeparator);
            }
            result.add(EXTENSION);
            nlSuffixes = result.toArray(new String[result.size()]);
        }
        root = root.replace('.', '/');
        String[] variants = new String[nlSuffixes.length];
        int i = 0;
        while (i < variants.length) {
            variants[i] = String.valueOf(root) + nlSuffixes[i];
            ++i;
        }
        return variants;
    }

    private static void computeMissingMessages(String bundleName, Class<?> clazz, Map<Object, Object> fieldMap, Field[] fieldArray, boolean isAccessible) {
        int numFields = fieldArray.length;
        int i = 0;
        while (i < numFields) {
            Field field = fieldArray[i];
            if ((field.getModifiers() & 0x19) == 9 && fieldMap.get(field.getName()) != ASSIGNED) {
                try {
                    String value = "NLS missing message: " + field.getName() + " in: " + bundleName;
                    if (!isAccessible) {
                        field.setAccessible(true);
                    }
                    field.set(null, value);
                }
                catch (Exception e) {
                    System.err.println("Error setting the missing message value for: " + field.getName());
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    static void load(String bundleName, Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        ClassLoader loader = clazz.getClassLoader();
        boolean isAccessible = (clazz.getModifiers() & 1) != 0;
        int len = fieldArray.length;
        HashMap<Object, Object> fields = new HashMap<Object, Object>(len * 2);
        int i = 0;
        while (i < len) {
            fields.put(fieldArray[i].getName(), fieldArray[i]);
            ++i;
        }
        String[] variants = NLS.buildVariants(bundleName);
        int i2 = 0;
        while (i2 < variants.length) {
            block14: {
                InputStream input;
                InputStream inputStream = input = loader == null ? ClassLoader.getSystemResourceAsStream(variants[i2]) : loader.getResourceAsStream(variants[i2]);
                if (input != null) {
                    try {
                        try {
                            MessagesProperties properties = new MessagesProperties(fields, bundleName, isAccessible);
                            properties.load(input);
                        }
                        catch (IOException e) {
                            System.err.println("Error loading " + variants[i2]);
                            e.printStackTrace();
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ++i2;
        }
        NLS.computeMissingMessages(bundleName, clazz, fields, fieldArray, isAccessible);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessagesProperties
    extends Properties {
        private static final int MOD_EXPECTED = 9;
        private static final int MOD_MASK = 25;
        private static final long serialVersionUID = 1L;
        private final String bundleName;
        private final Map<Object, Object> fields;
        private final boolean isAccessible;

        public MessagesProperties(Map<Object, Object> fieldMap, String bundleName, boolean isAccessible) {
            this.fields = fieldMap;
            this.bundleName = bundleName;
            this.isAccessible = isAccessible;
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            Object fieldObject = this.fields.put(key, ASSIGNED);
            if (fieldObject == ASSIGNED) {
                return null;
            }
            if (fieldObject == null) {
                String msg = "NLS unused message: " + key + " in: " + this.bundleName;
                System.err.println(msg);
                return null;
            }
            Field field = (Field)fieldObject;
            if ((field.getModifiers() & 0x19) != 9) {
                return null;
            }
            try {
                if (!this.isAccessible) {
                    field.setAccessible(true);
                }
                field.set(null, new String(((String)value).toCharArray()));
            }
            catch (Exception e) {
                System.err.println("Exception setting field value.");
                e.printStackTrace();
            }
            return null;
        }
    }
}

